/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.condition;

import java.util.Collection;
import java.util.SortedSet;
import org.opends.server.admin.AbstractManagedObjectDefinition;
import org.opends.server.admin.IllegalPropertyValueStringException;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.ManagementContext;
import org.opends.server.admin.condition.Condition;
import org.opends.server.admin.server.ServerManagedObject;
import org.opends.server.config.ConfigException;
import org.opends.server.util.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ContainsCondition
implements Condition {
    private Impl<?> impl = null;
    private final String propertyName;
    private final String propertyStringValue;

    public ContainsCondition(String propertyName, String stringValue) {
        Validator.ensureNotNull(propertyName, stringValue);
        this.propertyName = propertyName;
        this.propertyStringValue = stringValue;
    }

    @Override
    public boolean evaluate(ManagementContext context, ManagedObject<?> managedObject) throws AuthorizationException, CommunicationException {
        return this.impl.evaluate(context, managedObject);
    }

    @Override
    public boolean evaluate(ServerManagedObject<?> managedObject) throws ConfigException {
        return this.impl.evaluate(managedObject);
    }

    public void setPropertyValue(ManagedObject<?> managedObject) {
        ((Impl)this.impl).setPropertyValue(managedObject);
    }

    @Override
    public void initialize(AbstractManagedObjectDefinition<?, ?> d) throws Exception {
        this.buildImpl(d.getPropertyDefinition(this.propertyName));
    }

    private <T> void buildImpl(PropertyDefinition<T> pd) throws IllegalPropertyValueStringException {
        T value = pd.decodeValue(this.propertyStringValue);
        this.impl = new Impl(pd, value);
    }

    public PropertyDefinition<?> getPropertyDefinition() {
        return this.impl.pd;
    }

    public Object getValue() {
        return this.impl.value;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Impl<T>
    implements Condition {
        final PropertyDefinition<T> pd;
        final T value;

        private Impl(PropertyDefinition<T> pd, T value) throws IllegalPropertyValueStringException {
            this.pd = pd;
            this.value = value;
        }

        @Override
        public boolean evaluate(ManagementContext context, ManagedObject<?> managedObject) throws AuthorizationException, CommunicationException {
            SortedSet<T> values = managedObject.getPropertyValues(this.pd);
            return values.contains(this.value);
        }

        @Override
        public boolean evaluate(ServerManagedObject<?> managedObject) throws ConfigException {
            Collection values = managedObject.getPropertyValues((PropertyDefinition)this.pd);
            return values.contains(this.value);
        }

        @Override
        public void initialize(AbstractManagedObjectDefinition<?, ?> d) throws Exception {
        }

        private void setPropertyValue(ManagedObject<?> managedObject) {
            managedObject.setPropertyValue(this.pd, this.value);
        }
    }
}

