/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.api.plugin;

import java.util.List;
import java.util.Set;
import org.opends.messages.Message;
import org.opends.messages.PluginMessages;
import org.opends.server.admin.std.server.PluginCfg;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.plugin.PluginResult;
import org.opends.server.api.plugin.PluginType;
import org.opends.server.config.ConfigException;
import org.opends.server.types.CanceledOperationException;
import org.opends.server.types.DN;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.IntermediateResponse;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.Modification;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchResultReference;
import org.opends.server.types.StabilityLevel;
import org.opends.server.types.operation.PostOperationAbandonOperation;
import org.opends.server.types.operation.PostOperationAddOperation;
import org.opends.server.types.operation.PostOperationBindOperation;
import org.opends.server.types.operation.PostOperationCompareOperation;
import org.opends.server.types.operation.PostOperationDeleteOperation;
import org.opends.server.types.operation.PostOperationExtendedOperation;
import org.opends.server.types.operation.PostOperationModifyDNOperation;
import org.opends.server.types.operation.PostOperationModifyOperation;
import org.opends.server.types.operation.PostOperationSearchOperation;
import org.opends.server.types.operation.PostOperationUnbindOperation;
import org.opends.server.types.operation.PostResponseAddOperation;
import org.opends.server.types.operation.PostResponseBindOperation;
import org.opends.server.types.operation.PostResponseCompareOperation;
import org.opends.server.types.operation.PostResponseDeleteOperation;
import org.opends.server.types.operation.PostResponseExtendedOperation;
import org.opends.server.types.operation.PostResponseModifyDNOperation;
import org.opends.server.types.operation.PostResponseModifyOperation;
import org.opends.server.types.operation.PostResponseSearchOperation;
import org.opends.server.types.operation.PostSynchronizationAddOperation;
import org.opends.server.types.operation.PostSynchronizationDeleteOperation;
import org.opends.server.types.operation.PostSynchronizationModifyDNOperation;
import org.opends.server.types.operation.PostSynchronizationModifyOperation;
import org.opends.server.types.operation.PreOperationAddOperation;
import org.opends.server.types.operation.PreOperationBindOperation;
import org.opends.server.types.operation.PreOperationCompareOperation;
import org.opends.server.types.operation.PreOperationDeleteOperation;
import org.opends.server.types.operation.PreOperationExtendedOperation;
import org.opends.server.types.operation.PreOperationModifyDNOperation;
import org.opends.server.types.operation.PreOperationModifyOperation;
import org.opends.server.types.operation.PreOperationSearchOperation;
import org.opends.server.types.operation.PreParseAbandonOperation;
import org.opends.server.types.operation.PreParseAddOperation;
import org.opends.server.types.operation.PreParseBindOperation;
import org.opends.server.types.operation.PreParseCompareOperation;
import org.opends.server.types.operation.PreParseDeleteOperation;
import org.opends.server.types.operation.PreParseExtendedOperation;
import org.opends.server.types.operation.PreParseModifyDNOperation;
import org.opends.server.types.operation.PreParseModifyOperation;
import org.opends.server.types.operation.PreParseSearchOperation;
import org.opends.server.types.operation.PreParseUnbindOperation;
import org.opends.server.types.operation.SearchEntrySearchOperation;
import org.opends.server.types.operation.SearchReferenceSearchOperation;
import org.opends.server.types.operation.SubordinateModifyDNOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=false, mayExtend=true, mayInvoke=false)
public abstract class DirectoryServerPlugin<T extends PluginCfg> {
    private boolean invokeForInternalOps;
    private DN pluginDN;
    private Set<PluginType> pluginTypes;

    protected DirectoryServerPlugin() {
    }

    public boolean isConfigurationAcceptable(PluginCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @PublicAPI(stability=StabilityLevel.PRIVATE, mayInstantiate=false, mayExtend=false, mayInvoke=false)
    public final void initializeInternal(PluginCfg configuration, Set<PluginType> pluginTypes) {
        this.pluginTypes = pluginTypes;
        this.pluginDN = configuration.dn();
        this.invokeForInternalOps = configuration.isInvokeForInternalOperations();
    }

    public abstract void initializePlugin(Set<PluginType> var1, T var2) throws ConfigException, InitializationException;

    public void finalizePlugin() {
    }

    public final DN getPluginEntryDN() {
        return this.pluginDN;
    }

    public final Set<PluginType> getPluginTypes() {
        return this.pluginTypes;
    }

    public final boolean invokeForInternalOperations() {
        return this.invokeForInternalOps;
    }

    @PublicAPI(stability=StabilityLevel.PRIVATE, mayInstantiate=false, mayExtend=false, mayInvoke=false)
    public final void setInvokeForInternalOperations(boolean invokeForInternalOps) {
        this.invokeForInternalOps = invokeForInternalOps;
    }

    public PluginResult.Startup doStartup() {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.STARTUP.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public void doShutdown(Message reason) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.SHUTDOWN.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PluginResult.PostConnect doPostConnect(ClientConnection clientConnection) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.POST_CONNECT.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PluginResult.PostDisconnect doPostDisconnect(ClientConnection clientConnection, DisconnectReason disconnectReason, Message message) {
        Message msg = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.POST_DISCONNECT.getName());
        throw new UnsupportedOperationException(msg.toString());
    }

    public PluginResult.ImportLDIF doLDIFImport(LDIFImportConfig importConfig, Entry entry) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.LDIF_IMPORT.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PluginResult.ImportLDIF doLDIFExport(LDIFExportConfig exportConfig, Entry entry) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.LDIF_EXPORT.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PluginResult.PreParse doPreParse(PreParseAbandonOperation abandonOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.PRE_PARSE_ABANDON.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PluginResult.PostOperation doPostOperation(PostOperationAbandonOperation abandonOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.POST_OPERATION_ABANDON.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PluginResult.PreParse doPreParse(PreParseAddOperation addOperation) throws CanceledOperationException {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.PRE_PARSE_ADD.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PluginResult.PreOperation doPreOperation(PreOperationAddOperation addOperation) throws CanceledOperationException {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.PRE_OPERATION_ADD.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PluginResult.PostOperation doPostOperation(PostOperationAddOperation addOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.POST_OPERATION_ADD.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PluginResult.PostResponse doPostResponse(PostResponseAddOperation addOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.POST_RESPONSE_ADD.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public void doPostSynchronization(PostSynchronizationAddOperation addOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.POST_SYNCHRONIZATION_ADD.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PluginResult.PreParse doPreParse(PreParseBindOperation bindOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.PRE_PARSE_BIND.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PluginResult.PreOperation doPreOperation(PreOperationBindOperation bindOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.PRE_OPERATION_BIND.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PluginResult.PostOperation doPostOperation(PostOperationBindOperation bindOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.POST_OPERATION_BIND.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PluginResult.PostResponse doPostResponse(PostResponseBindOperation bindOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.POST_RESPONSE_BIND.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PluginResult.PreParse doPreParse(PreParseCompareOperation compareOperation) throws CanceledOperationException {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.PRE_PARSE_COMPARE.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PluginResult.PreOperation doPreOperation(PreOperationCompareOperation compareOperation) throws CanceledOperationException {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.PRE_OPERATION_COMPARE.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PluginResult.PostOperation doPostOperation(PostOperationCompareOperation compareOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.POST_OPERATION_COMPARE.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PluginResult.PostResponse doPostResponse(PostResponseCompareOperation compareOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.POST_RESPONSE_COMPARE.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PluginResult.PreParse doPreParse(PreParseDeleteOperation deleteOperation) throws CanceledOperationException {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.PRE_PARSE_DELETE.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PluginResult.PreOperation doPreOperation(PreOperationDeleteOperation deleteOperation) throws CanceledOperationException {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.PRE_OPERATION_DELETE.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PluginResult.PostOperation doPostOperation(PostOperationDeleteOperation deleteOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.POST_OPERATION_DELETE.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PluginResult.PostResponse doPostResponse(PostResponseDeleteOperation deleteOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.POST_RESPONSE_DELETE.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public void doPostSynchronization(PostSynchronizationDeleteOperation deleteOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.POST_SYNCHRONIZATION_DELETE.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PluginResult.PreParse doPreParse(PreParseExtendedOperation extendedOperation) throws CanceledOperationException {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.PRE_PARSE_EXTENDED.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PluginResult.PreOperation doPreOperation(PreOperationExtendedOperation extendedOperation) throws CanceledOperationException {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.PRE_OPERATION_EXTENDED.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PluginResult.PostOperation doPostOperation(PostOperationExtendedOperation extendedOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.POST_OPERATION_EXTENDED.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PluginResult.PostResponse doPostResponse(PostResponseExtendedOperation extendedOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.POST_RESPONSE_EXTENDED.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PluginResult.PreParse doPreParse(PreParseModifyOperation modifyOperation) throws CanceledOperationException {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.PRE_PARSE_MODIFY.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PluginResult.PreOperation doPreOperation(PreOperationModifyOperation modifyOperation) throws CanceledOperationException {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.PRE_OPERATION_MODIFY.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PluginResult.PostOperation doPostOperation(PostOperationModifyOperation modifyOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.POST_OPERATION_MODIFY.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PluginResult.PostResponse doPostResponse(PostResponseModifyOperation modifyOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.POST_RESPONSE_MODIFY.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public void doPostSynchronization(PostSynchronizationModifyOperation modifyOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.POST_SYNCHRONIZATION_MODIFY.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PluginResult.PreParse doPreParse(PreParseModifyDNOperation modifyDNOperation) throws CanceledOperationException {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.PRE_PARSE_MODIFY_DN.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PluginResult.PreOperation doPreOperation(PreOperationModifyDNOperation modifyDNOperation) throws CanceledOperationException {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.PRE_OPERATION_MODIFY_DN.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PluginResult.SubordinateModifyDN processSubordinateModifyDN(SubordinateModifyDNOperation modifyDNOperation, Entry oldEntry, Entry newEntry, List<Modification> modifications) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.SUBORDINATE_MODIFY_DN.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PluginResult.PostOperation doPostOperation(PostOperationModifyDNOperation modifyDNOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.POST_OPERATION_MODIFY_DN.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PluginResult.PostResponse doPostResponse(PostResponseModifyDNOperation modifyDNOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.POST_RESPONSE_MODIFY_DN.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public void doPostSynchronization(PostSynchronizationModifyDNOperation modifyDNOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.POST_SYNCHRONIZATION_MODIFY_DN.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PluginResult.PreParse doPreParse(PreParseSearchOperation searchOperation) throws CanceledOperationException {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.PRE_PARSE_SEARCH.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PluginResult.PreOperation doPreOperation(PreOperationSearchOperation searchOperation) throws CanceledOperationException {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.PRE_OPERATION_SEARCH.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PluginResult.IntermediateResponse processSearchEntry(SearchEntrySearchOperation searchOperation, SearchResultEntry searchEntry) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.SEARCH_RESULT_ENTRY.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PluginResult.IntermediateResponse processSearchReference(SearchReferenceSearchOperation searchOperation, SearchResultReference searchReference) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.SEARCH_RESULT_REFERENCE.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PluginResult.PostOperation doPostOperation(PostOperationSearchOperation searchOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.POST_OPERATION_SEARCH.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PluginResult.PostResponse doPostResponse(PostResponseSearchOperation searchOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.POST_RESPONSE_SEARCH.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PluginResult.PreParse doPreParse(PreParseUnbindOperation unbindOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.PRE_PARSE_UNBIND.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PluginResult.PostOperation doPostOperation(PostOperationUnbindOperation unbindOperation) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.POST_OPERATION_UNBIND.getName());
        throw new UnsupportedOperationException(message.toString());
    }

    public PluginResult.IntermediateResponse processIntermediateResponse(IntermediateResponse intermediateResponse) {
        Message message = PluginMessages.ERR_PLUGIN_TYPE_NOT_SUPPORTED.get(String.valueOf(this.pluginDN), PluginType.INTERMEDIATE_RESPONSE.getName());
        throw new UnsupportedOperationException(message.toString());
    }
}

