/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.io.IOException;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.controls.ControlDecoder;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.protocols.ldap.LDAPReader;
import org.opends.server.protocols.ldap.SearchResultEntryProtocolOp;
import org.opends.server.types.ByteString;
import org.opends.server.types.Control;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.LDAPException;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchResultEntry;

public class LDAPPostReadResponseControl
extends Control {
    public static final ControlDecoder<LDAPPostReadResponseControl> DECODER = new Decoder();
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private SearchResultEntry searchEntry;

    public LDAPPostReadResponseControl(SearchResultEntry searchEntry) {
        this(false, searchEntry);
    }

    public LDAPPostReadResponseControl(boolean isCritical, SearchResultEntry searchEntry) {
        super("1.3.6.1.1.13.2", isCritical);
        this.searchEntry = searchEntry;
    }

    public void writeValue(ASN1Writer writer) throws IOException {
        writer.writeStartSequence((byte)4);
        SearchResultEntryProtocolOp protocolOp = new SearchResultEntryProtocolOp(this.searchEntry);
        protocolOp.write(writer);
        writer.writeEndSequence();
    }

    public SearchResultEntry getSearchEntry() {
        return this.searchEntry;
    }

    public void toString(StringBuilder buffer) {
        buffer.append("LDAPPostReadResponseControl(criticality=");
        buffer.append(this.isCritical());
        buffer.append(",entry=");
        this.searchEntry.toSingleLineString(buffer);
        buffer.append(")");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Decoder
    implements ControlDecoder<LDAPPostReadResponseControl> {
        private Decoder() {
        }

        @Override
        public LDAPPostReadResponseControl decode(boolean isCritical, ByteString value) throws DirectoryException {
            SearchResultEntry searchEntry;
            if (value == null) {
                Message message = ProtocolMessages.ERR_POSTREADRESP_NO_CONTROL_VALUE.get();
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
            }
            ASN1Reader reader = ASN1.getReader(value);
            try {
                SearchResultEntryProtocolOp searchResultEntryProtocolOp = LDAPReader.readSearchEntry(reader);
                searchEntry = searchResultEntryProtocolOp.toSearchResultEntry();
            }
            catch (LDAPException le) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, le);
                }
                Message message = ProtocolMessages.ERR_POSTREADRESP_CANNOT_DECODE_VALUE.get(le.getMessage());
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, le);
            }
            return new LDAPPostReadResponseControl(isCritical, searchEntry);
        }

        @Override
        public String getOID() {
            return "1.3.6.1.1.13.2";
        }
    }
}

