/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opends.messages.CoreMessages;
import org.opends.messages.MessageBuilder;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.plugin.PluginResult;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.PluginConfigManager;
import org.opends.server.core.Workflow;
import org.opends.server.core.networkgroups.NetworkGroup;
import org.opends.server.loggers.AccessLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.AbstractOperation;
import org.opends.server.types.ByteString;
import org.opends.server.types.CancelResult;
import org.opends.server.types.CanceledOperationException;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.OperationType;
import org.opends.server.types.ResultCode;
import org.opends.server.types.operation.PostResponseDeleteOperation;
import org.opends.server.types.operation.PreParseDeleteOperation;
import org.opends.server.workflowelement.localbackend.LocalBackendDeleteOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteOperationBasis
extends AbstractOperation
implements PreParseDeleteOperation,
DeleteOperation,
PostResponseDeleteOperation {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ByteString rawEntryDN;
    private DN entryDN;
    private DN proxiedAuthorizationDN;
    private List<Control> responseControls;
    private long changeNumber;

    public DeleteOperationBasis(ClientConnection clientConnection, long operationID, int messageID, List<Control> requestControls, ByteString rawEntryDN) {
        super(clientConnection, operationID, messageID, requestControls);
        this.rawEntryDN = rawEntryDN;
        this.entryDN = null;
        this.responseControls = new ArrayList<Control>();
        this.cancelRequest = null;
        this.changeNumber = -1L;
    }

    public DeleteOperationBasis(ClientConnection clientConnection, long operationID, int messageID, List<Control> requestControls, DN entryDN) {
        super(clientConnection, operationID, messageID, requestControls);
        this.entryDN = entryDN;
        this.rawEntryDN = ByteString.valueOf(entryDN.toString());
        this.responseControls = new ArrayList<Control>();
        this.cancelRequest = null;
        this.changeNumber = -1L;
    }

    @Override
    public final ByteString getRawEntryDN() {
        return this.rawEntryDN;
    }

    @Override
    public final void setRawEntryDN(ByteString rawEntryDN) {
        this.rawEntryDN = rawEntryDN;
        this.entryDN = null;
    }

    @Override
    public final DN getEntryDN() {
        try {
            if (this.entryDN == null) {
                this.entryDN = DN.decode(this.rawEntryDN);
            }
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            this.setResultCode(de.getResultCode());
            this.appendErrorMessage(de.getMessageObject());
            this.setMatchedDN(de.getMatchedDN());
            this.setReferralURLs(de.getReferralURLs());
        }
        return this.entryDN;
    }

    @Override
    public final long getChangeNumber() {
        return this.changeNumber;
    }

    @Override
    public final void setChangeNumber(long changeNumber) {
        this.changeNumber = changeNumber;
    }

    @Override
    public final OperationType getOperationType() {
        return OperationType.DELETE;
    }

    @Override
    public final String[][] getRequestLogElements() {
        return new String[][]{{"entryDN", String.valueOf(this.rawEntryDN)}};
    }

    @Override
    public final String[][] getResponseLogElements() {
        String referrals;
        String resultCode = String.valueOf(this.getResultCode().getIntValue());
        MessageBuilder errorMessageBuffer = this.getErrorMessage();
        String errorMessage = errorMessageBuffer == null ? null : errorMessageBuffer.toString();
        DN matchedDN = this.getMatchedDN();
        String matchedDNStr = matchedDN == null ? null : matchedDN.toString();
        List<String> referralURLs = this.getReferralURLs();
        if (referralURLs == null || referralURLs.isEmpty()) {
            referrals = null;
        } else {
            StringBuilder buffer = new StringBuilder();
            Iterator<String> iterator = referralURLs.iterator();
            buffer.append(iterator.next());
            while (iterator.hasNext()) {
                buffer.append(", ");
                buffer.append(iterator.next());
            }
            referrals = buffer.toString();
        }
        String processingTime = String.valueOf(this.getProcessingTime());
        return new String[][]{{"resultCode", resultCode}, {"errorMessage", errorMessage}, {"matchedDN", matchedDNStr}, {"referralURLs", referrals}, {"processingTime", processingTime}};
    }

    @Override
    public DN getProxiedAuthorizationDN() {
        return this.proxiedAuthorizationDN;
    }

    @Override
    public final List<Control> getResponseControls() {
        return this.responseControls;
    }

    @Override
    public final void addResponseControl(Control control) {
        this.responseControls.add(control);
    }

    @Override
    public final void removeResponseControl(Control control) {
        this.responseControls.remove(control);
    }

    @Override
    public final void toString(StringBuilder buffer) {
        buffer.append("DeleteOperation(connID=");
        buffer.append(this.clientConnection.getConnectionID());
        buffer.append(", opID=");
        buffer.append(this.operationID);
        buffer.append(", dn=");
        buffer.append(this.rawEntryDN);
        buffer.append(")");
    }

    @Override
    public void setProxiedAuthorizationDN(DN proxiedAuthorizationDN) {
        this.proxiedAuthorizationDN = proxiedAuthorizationDN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void run() {
        boolean workflowExecuted;
        block24: {
            block23: {
                block22: {
                    block21: {
                        this.setResultCode(ResultCode.UNDEFINED);
                        this.setProcessingStartTime();
                        AccessLogger.logDeleteRequest(this);
                        PluginConfigManager pluginConfigManager = DirectoryServer.getPluginConfigManager();
                        workflowExecuted = false;
                        try {
                            try {
                                PluginResult.PreParse preParseResult = pluginConfigManager.invokePreParseDeletePlugins(this);
                                if (!preParseResult.continueProcessing()) {
                                    this.setResultCode(preParseResult.getResultCode());
                                    this.appendErrorMessage(preParseResult.getErrorMessage());
                                    this.setMatchedDN(preParseResult.getMatchedDN());
                                    this.setReferralURLs(preParseResult.getReferralURLs());
                                    Object var8_5 = null;
                                    break block21;
                                }
                                this.checkIfCanceled(false);
                                DN entryDN = this.getEntryDN();
                                if (entryDN == null) {
                                    break block22;
                                }
                                NetworkGroup ng = this.getClientConnection().getNetworkGroup();
                                Workflow workflow = ng.getWorkflowCandidate(entryDN);
                                if (workflow == null) {
                                    this.updateOperationErrMsgAndResCode();
                                    break block23;
                                }
                                workflow.execute(this);
                                workflowExecuted = true;
                                break block24;
                            }
                            catch (CanceledOperationException coe) {
                                if (DebugLogger.debugEnabled()) {
                                    TRACER.debugCaught(DebugLogLevel.ERROR, coe);
                                }
                                this.setResultCode(ResultCode.CANCELED);
                                this.cancelResult = new CancelResult(ResultCode.CANCELED, null);
                                this.appendErrorMessage(coe.getCancelRequest().getCancelReason());
                                Object var8_9 = null;
                                this.setProcessingStopTime();
                                if (this.cancelRequest == null || this.cancelResult == null || this.cancelResult.getResultCode() != ResultCode.CANCELED || this.cancelRequest.notifyOriginalRequestor() || DirectoryServer.notifyAbandonedOperations()) {
                                    this.clientConnection.sendResponse(this);
                                }
                                AccessLogger.logDeleteResponse(this);
                                if (workflowExecuted) {
                                    this.invokePostResponseCallbacks();
                                }
                                this.invokePostResponsePlugins(workflowExecuted);
                                if (this.cancelResult != null) return;
                                this.cancelResult = new CancelResult(ResultCode.TOO_LATE, null);
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var8_10 = null;
                            this.setProcessingStopTime();
                            if (this.cancelRequest == null || this.cancelResult == null || this.cancelResult.getResultCode() != ResultCode.CANCELED || this.cancelRequest.notifyOriginalRequestor() || DirectoryServer.notifyAbandonedOperations()) {
                                this.clientConnection.sendResponse(this);
                            }
                            AccessLogger.logDeleteResponse(this);
                            if (workflowExecuted) {
                                this.invokePostResponseCallbacks();
                            }
                            this.invokePostResponsePlugins(workflowExecuted);
                            if (this.cancelResult != null) throw throwable;
                            this.cancelResult = new CancelResult(ResultCode.TOO_LATE, null);
                            throw throwable;
                        }
                    }
                    this.setProcessingStopTime();
                    if (this.cancelRequest == null || this.cancelResult == null || this.cancelResult.getResultCode() != ResultCode.CANCELED || this.cancelRequest.notifyOriginalRequestor() || DirectoryServer.notifyAbandonedOperations()) {
                        this.clientConnection.sendResponse(this);
                    }
                    AccessLogger.logDeleteResponse(this);
                    if (workflowExecuted) {
                        this.invokePostResponseCallbacks();
                    }
                    this.invokePostResponsePlugins(workflowExecuted);
                    if (this.cancelResult != null) return;
                    this.cancelResult = new CancelResult(ResultCode.TOO_LATE, null);
                    return;
                }
                Object var8_6 = null;
                this.setProcessingStopTime();
                if (this.cancelRequest == null || this.cancelResult == null || this.cancelResult.getResultCode() != ResultCode.CANCELED || this.cancelRequest.notifyOriginalRequestor() || DirectoryServer.notifyAbandonedOperations()) {
                    this.clientConnection.sendResponse(this);
                }
                AccessLogger.logDeleteResponse(this);
                if (workflowExecuted) {
                    this.invokePostResponseCallbacks();
                }
                this.invokePostResponsePlugins(workflowExecuted);
                if (this.cancelResult != null) return;
                this.cancelResult = new CancelResult(ResultCode.TOO_LATE, null);
                return;
            }
            Object var8_7 = null;
            this.setProcessingStopTime();
            if (this.cancelRequest == null || this.cancelResult == null || this.cancelResult.getResultCode() != ResultCode.CANCELED || this.cancelRequest.notifyOriginalRequestor() || DirectoryServer.notifyAbandonedOperations()) {
                this.clientConnection.sendResponse(this);
            }
            AccessLogger.logDeleteResponse(this);
            if (workflowExecuted) {
                this.invokePostResponseCallbacks();
            }
            this.invokePostResponsePlugins(workflowExecuted);
            if (this.cancelResult != null) return;
            this.cancelResult = new CancelResult(ResultCode.TOO_LATE, null);
            return;
        }
        Object var8_8 = null;
        this.setProcessingStopTime();
        if (this.cancelRequest == null || this.cancelResult == null || this.cancelResult.getResultCode() != ResultCode.CANCELED || this.cancelRequest.notifyOriginalRequestor() || DirectoryServer.notifyAbandonedOperations()) {
            this.clientConnection.sendResponse(this);
        }
        AccessLogger.logDeleteResponse(this);
        if (workflowExecuted) {
            this.invokePostResponseCallbacks();
        }
        this.invokePostResponsePlugins(workflowExecuted);
        if (this.cancelResult != null) return;
        this.cancelResult = new CancelResult(ResultCode.TOO_LATE, null);
    }

    private void invokePostResponsePlugins(boolean workflowExecuted) {
        PluginConfigManager pluginConfigManager = DirectoryServer.getPluginConfigManager();
        if (workflowExecuted) {
            List localOperations = (List)this.getAttachment("LocalBackendOperations");
            if (localOperations != null) {
                for (Object localOp : localOperations) {
                    LocalBackendDeleteOperation localOperation = (LocalBackendDeleteOperation)localOp;
                    pluginConfigManager.invokePostResponseDeletePlugins(localOperation);
                }
            }
        } else {
            pluginConfigManager.invokePostResponseDeletePlugins(this);
        }
    }

    private void updateOperationErrMsgAndResCode() {
        this.setResultCode(ResultCode.NO_SUCH_OBJECT);
        this.appendErrorMessage(CoreMessages.ERR_DELETE_NO_SUCH_ENTRY.get(String.valueOf(this.getEntryDN())));
    }

    @Override
    public Entry getEntryToDelete() {
        return null;
    }
}

