/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.meta.ExtensionCfgDefn;
import org.opends.server.admin.std.server.ExtensionCfg;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.api.Extension;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionConfigManager
implements ConfigurationChangeListener<ExtensionCfg>,
ConfigurationAddListener<ExtensionCfg>,
ConfigurationDeleteListener<ExtensionCfg> {
    private ConcurrentHashMap<DN, Extension> extensions = new ConcurrentHashMap();

    public void initializeExtensions() throws ConfigException, InitializationException {
        ServerManagementContext managementContext = ServerManagementContext.getInstance();
        RootCfg rootConfiguration = managementContext.getRootConfiguration();
        rootConfiguration.addExtensionAddListener(this);
        rootConfiguration.addExtensionDeleteListener(this);
        for (String name : rootConfiguration.listExtensions()) {
            ExtensionCfg extensionConfig = rootConfiguration.getExtension(name);
            extensionConfig.addChangeListener(this);
            if (!extensionConfig.isEnabled()) continue;
            String className = extensionConfig.getJavaClass();
            try {
                Extension extension = this.loadExtension(className, extensionConfig, true);
                this.extensions.put(extensionConfig.dn(), extension);
                DirectoryServer.registerExtension(extensionConfig.dn(), extension);
            }
            catch (InitializationException ie) {
                ErrorLogger.logError(ie.getMessageObject());
            }
        }
    }

    @Override
    public boolean isConfigurationAddAcceptable(ExtensionCfg configuration, List<Message> unacceptableReasons) {
        if (configuration.isEnabled()) {
            String className = configuration.getJavaClass();
            try {
                this.loadExtension(className, configuration, false);
            }
            catch (InitializationException ie) {
                unacceptableReasons.add(ie.getMessageObject());
                return false;
            }
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(ExtensionCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        configuration.addChangeListener(this);
        if (!configuration.isEnabled()) {
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        Extension extension = null;
        String className = configuration.getJavaClass();
        try {
            extension = this.loadExtension(className, configuration, true);
        }
        catch (InitializationException ie) {
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            messages.add(ie.getMessageObject());
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.extensions.put(configuration.dn(), extension);
            DirectoryServer.registerExtension(configuration.dn(), extension);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationDeleteAcceptable(ExtensionCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(ExtensionCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        DirectoryServer.deregisterExtension(configuration.dn());
        Extension extension = this.extensions.remove(configuration.dn());
        if (extension != null) {
            extension.finalizeExtension();
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(ExtensionCfg configuration, List<Message> unacceptableReasons) {
        if (configuration.isEnabled()) {
            String className = configuration.getJavaClass();
            try {
                this.loadExtension(className, configuration, false);
            }
            catch (InitializationException ie) {
                unacceptableReasons.add(ie.getMessageObject());
                return false;
            }
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(ExtensionCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        Extension existingExtension = this.extensions.get(configuration.dn());
        if (!configuration.isEnabled()) {
            if (existingExtension != null) {
                DirectoryServer.deregisterExtension(configuration.dn());
                Extension extension = this.extensions.remove(configuration.dn());
                if (extension != null) {
                    extension.finalizeExtension();
                }
            }
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        String className = configuration.getJavaClass();
        if (existingExtension != null) {
            if (!className.equals(existingExtension.getClass().getName())) {
                adminActionRequired = true;
            }
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        Extension extension = null;
        try {
            extension = this.loadExtension(className, configuration, true);
        }
        catch (InitializationException ie) {
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            messages.add(ie.getMessageObject());
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.extensions.put(configuration.dn(), extension);
            DirectoryServer.registerExtension(configuration.dn(), extension);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    private Extension loadExtension(String className, ExtensionCfg configuration, boolean initialize) throws InitializationException {
        try {
            ExtensionCfgDefn definition = ExtensionCfgDefn.getInstance();
            ClassPropertyDefinition propertyDefinition = definition.getJavaClassPropertyDefinition();
            Class<Extension> extensionClass = propertyDefinition.loadClass(className, Extension.class);
            Extension extension = extensionClass.newInstance();
            if (initialize) {
                Method method = extension.getClass().getMethod("initializeExtension", configuration.configurationClass());
                method.invoke((Object)extension, configuration);
            } else {
                Method method = extension.getClass().getMethod("isConfigurationAcceptable", ExtensionCfg.class, List.class);
                ArrayList unacceptableReasons = new ArrayList();
                Boolean acceptable = (Boolean)method.invoke((Object)extension, configuration, unacceptableReasons);
                if (!acceptable.booleanValue()) {
                    StringBuilder buffer = new StringBuilder();
                    if (!unacceptableReasons.isEmpty()) {
                        Iterator iterator = unacceptableReasons.iterator();
                        buffer.append((CharSequence)iterator.next());
                        while (iterator.hasNext()) {
                            buffer.append(".  ");
                            buffer.append((CharSequence)iterator.next());
                        }
                    }
                    Message message = ConfigMessages.ERR_CONFIG_EXTENSION_CONFIG_NOT_ACCEPTABLE.get(String.valueOf(configuration.dn()), buffer.toString());
                    throw new InitializationException(message);
                }
            }
            return extension;
        }
        catch (InitializationException ie) {
            throw ie;
        }
        catch (Exception e) {
            Message message = ConfigMessages.ERR_CONFIG_EXTENSION_INITIALIZATION_FAILED.get(className, String.valueOf(configuration.dn()), StaticUtils.stackTraceToSingleLineString(e));
            throw new InitializationException(message, (Throwable)e);
        }
    }
}

