/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opends.messages.CoreMessages;
import org.opends.messages.MessageBuilder;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.plugin.PluginResult;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.PluginConfigManager;
import org.opends.server.core.Workflow;
import org.opends.server.core.networkgroups.NetworkGroup;
import org.opends.server.loggers.AccessLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.AbstractOperation;
import org.opends.server.types.ByteString;
import org.opends.server.types.CancelResult;
import org.opends.server.types.CanceledOperationException;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.Modification;
import org.opends.server.types.OperationType;
import org.opends.server.types.RDN;
import org.opends.server.types.ResultCode;
import org.opends.server.types.operation.PostResponseModifyDNOperation;
import org.opends.server.types.operation.PreParseModifyDNOperation;
import org.opends.server.workflowelement.localbackend.LocalBackendModifyDNOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyDNOperationBasis
extends AbstractOperation
implements ModifyDNOperation,
PreParseModifyDNOperation,
PostResponseModifyDNOperation {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private boolean deleteOldRDN;
    private ByteString rawEntryDN;
    private ByteString rawNewRDN;
    private ByteString rawNewSuperior;
    private DN entryDN;
    private DN newSuperior;
    private DN proxiedAuthorizationDN;
    private List<Control> responseControls;
    private List<Modification> modifications;
    private long changeNumber;
    private RDN newRDN;
    private DN newDN = null;

    public ModifyDNOperationBasis(ClientConnection clientConnection, long operationID, int messageID, List<Control> requestControls, ByteString rawEntryDN, ByteString rawNewRDN, boolean deleteOldRDN, ByteString rawNewSuperior) {
        super(clientConnection, operationID, messageID, requestControls);
        this.rawEntryDN = rawEntryDN;
        this.rawNewRDN = rawNewRDN;
        this.deleteOldRDN = deleteOldRDN;
        this.rawNewSuperior = rawNewSuperior;
        this.entryDN = null;
        this.newRDN = null;
        this.newSuperior = null;
        this.responseControls = new ArrayList<Control>();
        this.cancelRequest = null;
        this.modifications = null;
        this.changeNumber = -1L;
    }

    public ModifyDNOperationBasis(ClientConnection clientConnection, long operationID, int messageID, List<Control> requestControls, DN entryDN, RDN newRDN, boolean deleteOldRDN, DN newSuperior) {
        super(clientConnection, operationID, messageID, requestControls);
        this.entryDN = entryDN;
        this.newRDN = newRDN;
        this.deleteOldRDN = deleteOldRDN;
        this.newSuperior = newSuperior;
        this.rawEntryDN = ByteString.valueOf(entryDN.toString());
        this.rawNewRDN = ByteString.valueOf(newRDN.toString());
        this.rawNewSuperior = newSuperior == null ? null : ByteString.valueOf(newSuperior.toString());
        this.responseControls = new ArrayList<Control>();
        this.cancelRequest = null;
        this.modifications = null;
        this.changeNumber = -1L;
    }

    @Override
    public final ByteString getRawEntryDN() {
        return this.rawEntryDN;
    }

    @Override
    public final void setRawEntryDN(ByteString rawEntryDN) {
        this.rawEntryDN = rawEntryDN;
        this.entryDN = null;
    }

    @Override
    public final DN getEntryDN() {
        try {
            if (this.entryDN == null) {
                this.entryDN = DN.decode(this.rawEntryDN);
            }
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            this.setResultCode(de.getResultCode());
            this.appendErrorMessage(de.getMessageObject());
        }
        return this.entryDN;
    }

    @Override
    public final ByteString getRawNewRDN() {
        return this.rawNewRDN;
    }

    @Override
    public final void setRawNewRDN(ByteString rawNewRDN) {
        this.rawNewRDN = rawNewRDN;
        this.newRDN = null;
        this.newDN = null;
    }

    @Override
    public final RDN getNewRDN() {
        try {
            if (this.newRDN == null) {
                this.newRDN = RDN.decode(this.rawNewRDN.toString());
            }
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            this.setResultCode(de.getResultCode());
            this.appendErrorMessage(de.getMessageObject());
        }
        return this.newRDN;
    }

    @Override
    public final boolean deleteOldRDN() {
        return this.deleteOldRDN;
    }

    @Override
    public final void setDeleteOldRDN(boolean deleteOldRDN) {
        this.deleteOldRDN = deleteOldRDN;
    }

    @Override
    public final ByteString getRawNewSuperior() {
        return this.rawNewSuperior;
    }

    @Override
    public final void setRawNewSuperior(ByteString rawNewSuperior) {
        this.rawNewSuperior = rawNewSuperior;
        this.newSuperior = null;
        this.newDN = null;
    }

    @Override
    public final DN getNewSuperior() {
        if (this.rawNewSuperior == null) {
            this.newSuperior = null;
        } else {
            try {
                if (this.newSuperior == null) {
                    this.newSuperior = DN.decode(this.rawNewSuperior);
                }
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                this.setResultCode(de.getResultCode());
                this.appendErrorMessage(de.getMessageObject());
            }
        }
        return this.newSuperior;
    }

    @Override
    public final List<Modification> getModifications() {
        return this.modifications;
    }

    @Override
    public final void addModification(Modification modification) {
        if (this.modifications == null) {
            this.modifications = new ArrayList<Modification>();
        }
        if (modification != null) {
            this.modifications.add(modification);
        }
    }

    @Override
    public final Entry getOriginalEntry() {
        return null;
    }

    @Override
    public final Entry getUpdatedEntry() {
        return null;
    }

    @Override
    public final long getChangeNumber() {
        return this.changeNumber;
    }

    @Override
    public final void setChangeNumber(long changeNumber) {
        this.changeNumber = changeNumber;
    }

    @Override
    public final OperationType getOperationType() {
        return OperationType.MODIFY_DN;
    }

    @Override
    public final String[][] getRequestLogElements() {
        String newSuperiorStr = this.rawNewSuperior == null ? null : this.rawNewSuperior.toString();
        return new String[][]{{"entryDN", String.valueOf(this.rawEntryDN)}, {"newRDN", String.valueOf(this.newRDN)}, {"deleteOldRDN", String.valueOf(this.deleteOldRDN)}, {"newSuperior", newSuperiorStr}};
    }

    @Override
    public final String[][] getResponseLogElements() {
        String referrals;
        String resultCode = String.valueOf(this.getResultCode().getIntValue());
        MessageBuilder errorMessageBuffer = this.getErrorMessage();
        String errorMessage = errorMessageBuffer == null ? null : errorMessageBuffer.toString();
        DN matchedDN = this.getMatchedDN();
        String matchedDNStr = matchedDN == null ? null : matchedDN.toString();
        List<String> referralURLs = this.getReferralURLs();
        if (referralURLs == null || referralURLs.isEmpty()) {
            referrals = null;
        } else {
            StringBuilder buffer = new StringBuilder();
            Iterator<String> iterator = referralURLs.iterator();
            buffer.append(iterator.next());
            while (iterator.hasNext()) {
                buffer.append(", ");
                buffer.append(iterator.next());
            }
            referrals = buffer.toString();
        }
        String processingTime = String.valueOf(this.getProcessingTime());
        return new String[][]{{"resultCode", resultCode}, {"errorMessage", errorMessage}, {"matchedDN", matchedDNStr}, {"referralURLs", referrals}, {"processingTime", processingTime}};
    }

    @Override
    public DN getProxiedAuthorizationDN() {
        return this.proxiedAuthorizationDN;
    }

    @Override
    public final List<Control> getResponseControls() {
        return this.responseControls;
    }

    @Override
    public final void addResponseControl(Control control) {
        this.responseControls.add(control);
    }

    @Override
    public final void removeResponseControl(Control control) {
        this.responseControls.remove(control);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void run() {
        boolean workflowExecuted;
        block24: {
            block23: {
                block22: {
                    block21: {
                        this.setResultCode(ResultCode.UNDEFINED);
                        this.setProcessingStartTime();
                        AccessLogger.logModifyDNRequest(this);
                        PluginConfigManager pluginConfigManager = DirectoryServer.getPluginConfigManager();
                        workflowExecuted = false;
                        try {
                            try {
                                this.checkIfCanceled(false);
                                PluginResult.PreParse preParseResult = pluginConfigManager.invokePreParseModifyDNPlugins(this);
                                if (!preParseResult.continueProcessing()) {
                                    this.setResultCode(preParseResult.getResultCode());
                                    this.appendErrorMessage(preParseResult.getErrorMessage());
                                    this.setMatchedDN(preParseResult.getMatchedDN());
                                    this.setReferralURLs(preParseResult.getReferralURLs());
                                    Object var8_5 = null;
                                    break block21;
                                }
                                this.checkIfCanceled(false);
                                DN entryDN = this.getEntryDN();
                                if (entryDN == null) {
                                    break block22;
                                }
                                NetworkGroup ng = this.getClientConnection().getNetworkGroup();
                                Workflow workflow = ng.getWorkflowCandidate(entryDN);
                                if (workflow == null) {
                                    this.updateOperationErrMsgAndResCode();
                                    break block23;
                                }
                                workflow.execute(this);
                                workflowExecuted = true;
                                break block24;
                            }
                            catch (CanceledOperationException coe) {
                                if (DebugLogger.debugEnabled()) {
                                    TRACER.debugCaught(DebugLogLevel.ERROR, coe);
                                }
                                this.setResultCode(ResultCode.CANCELED);
                                this.cancelResult = new CancelResult(ResultCode.CANCELED, null);
                                this.appendErrorMessage(coe.getCancelRequest().getCancelReason());
                                Object var8_9 = null;
                                this.setProcessingStopTime();
                                if (this.cancelRequest == null || this.cancelResult == null || this.cancelResult.getResultCode() != ResultCode.CANCELED || this.cancelRequest.notifyOriginalRequestor() || DirectoryServer.notifyAbandonedOperations()) {
                                    this.clientConnection.sendResponse(this);
                                }
                                AccessLogger.logModifyDNResponse(this);
                                if (workflowExecuted) {
                                    this.invokePostResponseCallbacks();
                                }
                                this.invokePostResponsePlugins(workflowExecuted);
                                if (this.cancelResult != null) return;
                                this.cancelResult = new CancelResult(ResultCode.TOO_LATE, null);
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var8_10 = null;
                            this.setProcessingStopTime();
                            if (this.cancelRequest == null || this.cancelResult == null || this.cancelResult.getResultCode() != ResultCode.CANCELED || this.cancelRequest.notifyOriginalRequestor() || DirectoryServer.notifyAbandonedOperations()) {
                                this.clientConnection.sendResponse(this);
                            }
                            AccessLogger.logModifyDNResponse(this);
                            if (workflowExecuted) {
                                this.invokePostResponseCallbacks();
                            }
                            this.invokePostResponsePlugins(workflowExecuted);
                            if (this.cancelResult != null) throw throwable;
                            this.cancelResult = new CancelResult(ResultCode.TOO_LATE, null);
                            throw throwable;
                        }
                    }
                    this.setProcessingStopTime();
                    if (this.cancelRequest == null || this.cancelResult == null || this.cancelResult.getResultCode() != ResultCode.CANCELED || this.cancelRequest.notifyOriginalRequestor() || DirectoryServer.notifyAbandonedOperations()) {
                        this.clientConnection.sendResponse(this);
                    }
                    AccessLogger.logModifyDNResponse(this);
                    if (workflowExecuted) {
                        this.invokePostResponseCallbacks();
                    }
                    this.invokePostResponsePlugins(workflowExecuted);
                    if (this.cancelResult != null) return;
                    this.cancelResult = new CancelResult(ResultCode.TOO_LATE, null);
                    return;
                }
                Object var8_6 = null;
                this.setProcessingStopTime();
                if (this.cancelRequest == null || this.cancelResult == null || this.cancelResult.getResultCode() != ResultCode.CANCELED || this.cancelRequest.notifyOriginalRequestor() || DirectoryServer.notifyAbandonedOperations()) {
                    this.clientConnection.sendResponse(this);
                }
                AccessLogger.logModifyDNResponse(this);
                if (workflowExecuted) {
                    this.invokePostResponseCallbacks();
                }
                this.invokePostResponsePlugins(workflowExecuted);
                if (this.cancelResult != null) return;
                this.cancelResult = new CancelResult(ResultCode.TOO_LATE, null);
                return;
            }
            Object var8_7 = null;
            this.setProcessingStopTime();
            if (this.cancelRequest == null || this.cancelResult == null || this.cancelResult.getResultCode() != ResultCode.CANCELED || this.cancelRequest.notifyOriginalRequestor() || DirectoryServer.notifyAbandonedOperations()) {
                this.clientConnection.sendResponse(this);
            }
            AccessLogger.logModifyDNResponse(this);
            if (workflowExecuted) {
                this.invokePostResponseCallbacks();
            }
            this.invokePostResponsePlugins(workflowExecuted);
            if (this.cancelResult != null) return;
            this.cancelResult = new CancelResult(ResultCode.TOO_LATE, null);
            return;
        }
        Object var8_8 = null;
        this.setProcessingStopTime();
        if (this.cancelRequest == null || this.cancelResult == null || this.cancelResult.getResultCode() != ResultCode.CANCELED || this.cancelRequest.notifyOriginalRequestor() || DirectoryServer.notifyAbandonedOperations()) {
            this.clientConnection.sendResponse(this);
        }
        AccessLogger.logModifyDNResponse(this);
        if (workflowExecuted) {
            this.invokePostResponseCallbacks();
        }
        this.invokePostResponsePlugins(workflowExecuted);
        if (this.cancelResult != null) return;
        this.cancelResult = new CancelResult(ResultCode.TOO_LATE, null);
    }

    private void invokePostResponsePlugins(boolean workflowExecuted) {
        PluginConfigManager pluginConfigManager = DirectoryServer.getPluginConfigManager();
        if (workflowExecuted) {
            List localOperations = (List)this.getAttachment("LocalBackendOperations");
            if (localOperations != null) {
                for (Object localOp : localOperations) {
                    LocalBackendModifyDNOperation localOperation = (LocalBackendModifyDNOperation)localOp;
                    pluginConfigManager.invokePostResponseModifyDNPlugins(localOperation);
                }
            }
        } else {
            pluginConfigManager.invokePostResponseModifyDNPlugins(this);
        }
    }

    private void updateOperationErrMsgAndResCode() {
        this.setResultCode(ResultCode.NO_SUCH_OBJECT);
        this.appendErrorMessage(CoreMessages.ERR_MODDN_NO_BACKEND_FOR_CURRENT_ENTRY.get(String.valueOf(this.entryDN)));
    }

    @Override
    public final void toString(StringBuilder buffer) {
        buffer.append("ModifyDNOperation(connID=");
        buffer.append(this.clientConnection.getConnectionID());
        buffer.append(", opID=");
        buffer.append(this.operationID);
        buffer.append(", dn=");
        buffer.append(this.rawEntryDN);
        buffer.append(", newRDN=");
        buffer.append(this.rawNewRDN);
        buffer.append(", deleteOldRDN=");
        buffer.append(this.deleteOldRDN);
        if (this.rawNewSuperior != null) {
            buffer.append(", newSuperior=");
            buffer.append(this.rawNewSuperior);
        }
        buffer.append(")");
    }

    @Override
    public void setProxiedAuthorizationDN(DN dn) {
        this.proxiedAuthorizationDN = dn;
    }

    @Override
    public DN getNewDN() {
        if (this.newDN == null) {
            DN parentDN = null;
            if (this.getNewSuperior() == null) {
                if (this.getEntryDN() != null) {
                    parentDN = this.entryDN.getParentDNInSuffix();
                }
            } else {
                parentDN = this.newSuperior;
            }
            if (parentDN == null || parentDN.isNullDN()) {
                this.setResultCode(ResultCode.UNWILLING_TO_PERFORM);
                this.appendErrorMessage(CoreMessages.ERR_MODDN_NO_PARENT.get(String.valueOf(this.entryDN)));
            }
            this.newDN = parentDN.concat(this.getNewRDN());
        }
        return this.newDN;
    }
}

