/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.plugin.PluginResult;
import org.opends.server.controls.AccountUsableResponseControl;
import org.opends.server.controls.MatchedValuesControl;
import org.opends.server.core.AccessControlConfigManager;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.PasswordPolicyState;
import org.opends.server.core.PluginConfigManager;
import org.opends.server.core.SearchOperation;
import org.opends.server.core.Workflow;
import org.opends.server.core.networkgroups.NetworkGroup;
import org.opends.server.loggers.AccessLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.ldap.LDAPFilter;
import org.opends.server.types.AbstractOperation;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.ByteString;
import org.opends.server.types.CancelRequest;
import org.opends.server.types.CancelResult;
import org.opends.server.types.CanceledOperationException;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.FilterType;
import org.opends.server.types.OperationType;
import org.opends.server.types.RawFilter;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchResultReference;
import org.opends.server.types.SearchScope;
import org.opends.server.types.operation.PostResponseSearchOperation;
import org.opends.server.types.operation.PreParseSearchOperation;
import org.opends.server.types.operation.SearchEntrySearchOperation;
import org.opends.server.types.operation.SearchReferenceSearchOperation;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchOperationBasis
extends AbstractOperation
implements PreParseSearchOperation,
PostResponseSearchOperation,
SearchEntrySearchOperation,
SearchReferenceSearchOperation,
SearchOperation {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private AtomicBoolean responseSent;
    private boolean clientAcceptsReferrals;
    private boolean includeUsableControl;
    private boolean realAttributesOnly;
    private boolean returnLDAPSubentries;
    private boolean typesOnly;
    private boolean virtualAttributesOnly;
    private ByteString rawBaseDN;
    private DereferencePolicy derefPolicy;
    private DN baseDN;
    private DN proxiedAuthorizationDN;
    private int entriesSent;
    private int referencesSent;
    private int sizeLimit;
    private int timeLimit;
    private RawFilter rawFilter;
    private LinkedHashSet<String> attributes;
    private List<Control> responseControls;
    private long processingStartTime;
    private long processingStopTime;
    private long timeLimitExpiration;
    private MatchedValuesControl matchedValuesControl;
    private SearchFilter filter;
    private SearchScope scope;
    private boolean sendResponse = true;

    public SearchOperationBasis(ClientConnection clientConnection, long operationID, int messageID, List<Control> requestControls, ByteString rawBaseDN, SearchScope scope, DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, RawFilter rawFilter, LinkedHashSet<String> attributes) {
        super(clientConnection, operationID, messageID, requestControls);
        this.rawBaseDN = rawBaseDN;
        this.scope = scope;
        this.derefPolicy = derefPolicy;
        this.sizeLimit = sizeLimit;
        this.timeLimit = timeLimit;
        this.typesOnly = typesOnly;
        this.rawFilter = rawFilter;
        this.attributes = attributes == null ? new LinkedHashSet(0) : attributes;
        this.sizeLimit = clientConnection.getSizeLimit() <= 0 ? sizeLimit : (sizeLimit <= 0 ? clientConnection.getSizeLimit() : Math.min(sizeLimit, clientConnection.getSizeLimit()));
        this.timeLimit = clientConnection.getTimeLimit() <= 0 ? timeLimit : (timeLimit <= 0 ? clientConnection.getTimeLimit() : Math.min(timeLimit, clientConnection.getTimeLimit()));
        this.baseDN = null;
        this.filter = null;
        this.entriesSent = 0;
        this.referencesSent = 0;
        this.responseControls = new ArrayList<Control>();
        this.cancelRequest = null;
        this.clientAcceptsReferrals = true;
        this.includeUsableControl = false;
        this.responseSent = new AtomicBoolean(false);
        this.returnLDAPSubentries = false;
        this.matchedValuesControl = null;
        this.realAttributesOnly = false;
        this.virtualAttributesOnly = false;
    }

    public SearchOperationBasis(ClientConnection clientConnection, long operationID, int messageID, List<Control> requestControls, DN baseDN, SearchScope scope, DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, SearchFilter filter, LinkedHashSet<String> attributes) {
        super(clientConnection, operationID, messageID, requestControls);
        this.baseDN = baseDN;
        this.scope = scope;
        this.derefPolicy = derefPolicy;
        this.sizeLimit = sizeLimit;
        this.timeLimit = timeLimit;
        this.typesOnly = typesOnly;
        this.filter = filter;
        this.attributes = attributes == null ? new LinkedHashSet(0) : attributes;
        this.rawBaseDN = ByteString.valueOf(baseDN.toString());
        this.rawFilter = new LDAPFilter(filter);
        this.sizeLimit = clientConnection.getSizeLimit() <= 0 ? sizeLimit : (sizeLimit <= 0 ? clientConnection.getSizeLimit() : Math.min(sizeLimit, clientConnection.getSizeLimit()));
        this.timeLimit = clientConnection.getTimeLimit() <= 0 ? timeLimit : (timeLimit <= 0 ? clientConnection.getTimeLimit() : Math.min(timeLimit, clientConnection.getTimeLimit()));
        this.entriesSent = 0;
        this.referencesSent = 0;
        this.responseControls = new ArrayList<Control>();
        this.cancelRequest = null;
        this.clientAcceptsReferrals = true;
        this.includeUsableControl = false;
        this.responseSent = new AtomicBoolean(false);
        this.returnLDAPSubentries = false;
        this.matchedValuesControl = null;
    }

    @Override
    public final ByteString getRawBaseDN() {
        return this.rawBaseDN;
    }

    @Override
    public final void setRawBaseDN(ByteString rawBaseDN) {
        this.rawBaseDN = rawBaseDN;
        this.baseDN = null;
    }

    @Override
    public final DN getBaseDN() {
        try {
            if (this.baseDN == null) {
                this.baseDN = DN.decode(this.rawBaseDN);
            }
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            this.setResultCode(de.getResultCode());
            this.appendErrorMessage(de.getMessageObject());
            this.setMatchedDN(de.getMatchedDN());
            this.setReferralURLs(de.getReferralURLs());
        }
        return this.baseDN;
    }

    @Override
    public final void setBaseDN(DN baseDN) {
        this.baseDN = baseDN;
    }

    @Override
    public final SearchScope getScope() {
        return this.scope;
    }

    @Override
    public final void setScope(SearchScope scope) {
        this.scope = scope;
    }

    @Override
    public final DereferencePolicy getDerefPolicy() {
        return this.derefPolicy;
    }

    @Override
    public final void setDerefPolicy(DereferencePolicy derefPolicy) {
        this.derefPolicy = derefPolicy;
    }

    @Override
    public final int getSizeLimit() {
        return this.sizeLimit;
    }

    @Override
    public final void setSizeLimit(int sizeLimit) {
        this.sizeLimit = sizeLimit;
    }

    @Override
    public final int getTimeLimit() {
        return this.timeLimit;
    }

    @Override
    public final void setTimeLimit(int timeLimit) {
        this.timeLimit = timeLimit;
    }

    @Override
    public final boolean getTypesOnly() {
        return this.typesOnly;
    }

    @Override
    public final void setTypesOnly(boolean typesOnly) {
        this.typesOnly = typesOnly;
    }

    @Override
    public final RawFilter getRawFilter() {
        return this.rawFilter;
    }

    @Override
    public final void setRawFilter(RawFilter rawFilter) {
        this.rawFilter = rawFilter;
        this.filter = null;
    }

    @Override
    public final SearchFilter getFilter() {
        try {
            if (this.filter == null) {
                this.filter = this.rawFilter.toSearchFilter();
            }
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            this.setResultCode(de.getResultCode());
            this.appendErrorMessage(de.getMessageObject());
            this.setMatchedDN(de.getMatchedDN());
            this.setReferralURLs(de.getReferralURLs());
        }
        return this.filter;
    }

    @Override
    public final LinkedHashSet<String> getAttributes() {
        return this.attributes;
    }

    @Override
    public final void setAttributes(LinkedHashSet<String> attributes) {
        if (attributes == null) {
            this.attributes.clear();
        } else {
            this.attributes = attributes;
        }
    }

    @Override
    public final int getEntriesSent() {
        return this.entriesSent;
    }

    @Override
    public final int getReferencesSent() {
        return this.referencesSent;
    }

    @Override
    public final boolean returnEntry(Entry entry, List<Control> controls) {
        return this.returnEntry(entry, controls, true);
    }

    @Override
    public final boolean returnEntry(Entry entry, List<Control> controls, boolean evaluateAci) {
        PluginResult.IntermediateResponse pluginResult;
        boolean typesOnly;
        block32: {
            typesOnly = this.getTypesOnly();
            if (this.getSizeLimit() > 0 && this.getEntriesSent() >= this.getSizeLimit()) {
                this.setResultCode(ResultCode.SIZE_LIMIT_EXCEEDED);
                this.appendErrorMessage(CoreMessages.ERR_SEARCH_SIZE_LIMIT_EXCEEDED.get(this.getSizeLimit()));
                return false;
            }
            if (this.getTimeLimit() > 0 && TimeThread.getTime() >= this.getTimeLimitExpiration()) {
                this.setResultCode(ResultCode.TIME_LIMIT_EXCEEDED);
                this.appendErrorMessage(CoreMessages.ERR_SEARCH_TIME_LIMIT_EXCEEDED.get(this.getTimeLimit()));
                return false;
            }
            if (this.getScope() != SearchScope.BASE_OBJECT && !this.isReturnLDAPSubentries() && entry.isLDAPSubentry()) {
                SearchFilter filter = this.getFilter();
                block2 : switch (filter.getFilterType()) {
                    case AND: 
                    case OR: {
                        for (SearchFilter f : filter.getFilterComponents()) {
                            if (f.getFilterType() != FilterType.EQUALITY || !f.getAttributeType().isObjectClassType()) continue;
                            AttributeValue v = f.getAssertionValue();
                            if (!StaticUtils.toLowerCase(v.getValue().toString()).equals("ldapsubentry")) break block2;
                            this.setReturnLDAPSubentries(true);
                            break block2;
                        }
                        break;
                    }
                    case EQUALITY: {
                        AttributeValue v;
                        AttributeType t = filter.getAttributeType();
                        if (!t.isObjectClassType() || !StaticUtils.toLowerCase((v = filter.getAssertionValue()).getValue().toString()).equals("ldapsubentry")) break;
                        this.setReturnLDAPSubentries(true);
                    }
                }
                if (!this.isReturnLDAPSubentries()) {
                    return true;
                }
            }
            if (this.isIncludeUsableControl()) {
                try {
                    PasswordPolicyState pwpState = new PasswordPolicyState(entry, false);
                    boolean isInactive = pwpState.isDisabled() || pwpState.isAccountExpired();
                    boolean isLocked = pwpState.lockedDueToFailures() || pwpState.lockedDueToMaximumResetAge() || pwpState.lockedDueToIdleInterval();
                    boolean isReset = pwpState.mustChangePassword();
                    boolean isExpired = pwpState.isPasswordExpired();
                    if (isInactive || isLocked || isReset || isExpired) {
                        int secondsBeforeUnlock = pwpState.getSecondsUntilUnlock();
                        int remainingGraceLogins = pwpState.getGraceLoginsRemaining();
                        if (controls == null) {
                            controls = new ArrayList<Control>(1);
                        }
                        controls.add(new AccountUsableResponseControl(isInactive, isReset, isExpired, remainingGraceLogins, isLocked, secondsBeforeUnlock));
                    } else {
                        if (controls == null) {
                            controls = new ArrayList<Control>(1);
                        }
                        int secondsBeforeExpiration = pwpState.getSecondsUntilExpiration();
                        controls.add(new AccountUsableResponseControl(secondsBeforeExpiration));
                    }
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block32;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
        if (evaluateAci) {
            SearchResultEntry tmpSearchEntry = new SearchResultEntry(entry, controls);
            if (!AccessControlConfigManager.getInstance().getAccessControlHandler().maySend(this, tmpSearchEntry)) {
                return true;
            }
        }
        Entry entryToReturn = entry.filterEntry(this.getAttributes(), typesOnly, this.isVirtualAttributesOnly(), this.isRealAttributesOnly());
        MatchedValuesControl matchedValuesControl = this.getMatchedValuesControl();
        if (matchedValuesControl != null && !typesOnly) {
            AttributeBuilder builder;
            AttributeType attrType = DirectoryServer.getObjectClassAttributeType();
            Iterator<String> ocIterator = entryToReturn.getObjectClasses().values().iterator();
            while (ocIterator.hasNext()) {
                String ocName = ocIterator.next();
                AttributeValue v = AttributeValues.create(attrType, ocName);
                if (matchedValuesControl.valueMatches(attrType, v)) continue;
                ocIterator.remove();
            }
            LinkedList<Attribute> modifiedAttributes = new LinkedList<Attribute>();
            for (AttributeType t : entryToReturn.getUserAttributes().keySet()) {
                for (Attribute a : entryToReturn.getUserAttribute(t)) {
                    builder = new AttributeBuilder(a, true);
                    for (AttributeValue v : a) {
                        if (!matchedValuesControl.valueMatches(t, v)) continue;
                        builder.add(v);
                    }
                    modifiedAttributes.add(builder.toAttribute());
                }
            }
            for (AttributeType t : entryToReturn.getOperationalAttributes().keySet()) {
                for (Attribute a : entryToReturn.getUserAttribute(t)) {
                    builder = new AttributeBuilder(a);
                    for (AttributeValue v : a) {
                        if (!matchedValuesControl.valueMatches(t, v)) continue;
                        builder.add(v);
                    }
                    modifiedAttributes.add(builder.toAttribute());
                }
            }
            for (Attribute a : modifiedAttributes) {
                entryToReturn.replaceAttribute(a);
                if (!a.isEmpty()) continue;
                entryToReturn.addAttribute(a, null);
            }
        }
        SearchResultEntry searchEntry = new SearchResultEntry(entryToReturn, controls);
        if (evaluateAci) {
            searchEntry = AccessControlConfigManager.getInstance().getAccessControlHandler().filterEntry(this, searchEntry);
        }
        if ((pluginResult = DirectoryServer.getPluginConfigManager().invokeSearchResultEntryPlugins(this, searchEntry)).sendResponse()) {
            try {
                this.sendSearchEntry(searchEntry);
                AccessLogger.logSearchResultEntry(this, searchEntry);
                this.incrementEntriesSent();
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                this.setResponseData(de);
                return false;
            }
        }
        return pluginResult.continueProcessing();
    }

    @Override
    public final boolean returnReference(DN dn, SearchResultReference reference) {
        return this.returnReference(dn, reference, true);
    }

    @Override
    public final boolean returnReference(DN dn, SearchResultReference reference, boolean evaluateAci) {
        if (this.getTimeLimit() > 0 && TimeThread.getTime() >= this.getTimeLimitExpiration()) {
            this.setResultCode(ResultCode.TIME_LIMIT_EXCEEDED);
            this.appendErrorMessage(CoreMessages.ERR_SEARCH_TIME_LIMIT_EXCEEDED.get(this.getTimeLimit()));
            return false;
        }
        if (!this.isClientAcceptsReferrals()) {
            return true;
        }
        if (evaluateAci && !AccessControlConfigManager.getInstance().getAccessControlHandler().maySend(dn, this, reference)) {
            return true;
        }
        PluginResult.IntermediateResponse pluginResult = DirectoryServer.getPluginConfigManager().invokeSearchResultReferencePlugins(this, reference);
        if (pluginResult.sendResponse()) {
            try {
                if (this.sendSearchReference(reference)) {
                    AccessLogger.logSearchResultReference(this, reference);
                    this.incrementReferencesSent();
                } else {
                    this.setClientAcceptsReferrals(false);
                }
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                this.setResponseData(de);
                return false;
            }
        }
        return pluginResult.continueProcessing();
    }

    @Override
    public final void sendSearchResultDone() {
        if (this.responseSent.compareAndSet(false, true)) {
            this.clientConnection.sendResponse(this);
            AccessLogger.logSearchResultDone(this);
            this.invokePostResponsePlugins();
        }
    }

    @Override
    public final OperationType getOperationType() {
        return OperationType.SEARCH;
    }

    @Override
    public final String[][] getRequestLogElements() {
        String attrs;
        if (this.attributes == null || this.attributes.isEmpty()) {
            attrs = null;
        } else {
            StringBuilder attrBuffer = new StringBuilder();
            Iterator iterator = this.attributes.iterator();
            attrBuffer.append((String)iterator.next());
            while (iterator.hasNext()) {
                attrBuffer.append(", ");
                attrBuffer.append((String)iterator.next());
            }
            attrs = attrBuffer.toString();
        }
        return new String[][]{{"baseDN", String.valueOf(this.rawBaseDN)}, {"scope", String.valueOf((Object)this.scope)}, {"sizeLimit", String.valueOf(this.sizeLimit)}, {"timeLimit", String.valueOf(this.timeLimit)}, {"filter", String.valueOf(this.rawFilter)}, {"attributes", attrs}};
    }

    @Override
    public final String[][] getResponseLogElements() {
        String referrals;
        String resultCode = String.valueOf(this.getResultCode().getIntValue());
        MessageBuilder errorMessageBuffer = this.getErrorMessage();
        String errorMessage = errorMessageBuffer == null ? null : errorMessageBuffer.toString();
        DN matchedDN = this.getMatchedDN();
        String matchedDNStr = matchedDN == null ? null : matchedDN.toString();
        List<String> referralURLs = this.getReferralURLs();
        if (referralURLs == null || referralURLs.isEmpty()) {
            referrals = null;
        } else {
            StringBuilder buffer = new StringBuilder();
            Iterator<String> iterator = referralURLs.iterator();
            buffer.append(iterator.next());
            while (iterator.hasNext()) {
                buffer.append(", ");
                buffer.append(iterator.next());
            }
            referrals = buffer.toString();
        }
        String processingTime = String.valueOf(this.processingStopTime - this.processingStartTime);
        return new String[][]{{"resultCode", resultCode}, {"errorMessage", errorMessage}, {"matchedDN", matchedDNStr}, {"referralURLs", referrals}, {"entriesSent", String.valueOf(this.entriesSent)}, {"referencesSent", String.valueOf(this.referencesSent)}, {"processingTime", processingTime}};
    }

    @Override
    public DN getProxiedAuthorizationDN() {
        return this.proxiedAuthorizationDN;
    }

    @Override
    public final List<Control> getResponseControls() {
        return this.responseControls;
    }

    @Override
    public final void addResponseControl(Control control) {
        this.responseControls.add(control);
    }

    @Override
    public final void removeResponseControl(Control control) {
        this.responseControls.remove(control);
    }

    @Override
    public void abort(CancelRequest cancelRequest) {
        if (this.cancelResult == null && this.cancelRequest == null) {
            this.cancelRequest = cancelRequest;
        }
    }

    @Override
    public final void toString(StringBuilder buffer) {
        buffer.append("SearchOperation(connID=");
        buffer.append(this.clientConnection.getConnectionID());
        buffer.append(", opID=");
        buffer.append(this.operationID);
        buffer.append(", baseDN=");
        buffer.append(this.rawBaseDN);
        buffer.append(", scope=");
        buffer.append(this.scope.toString());
        buffer.append(", filter=");
        buffer.append(this.rawFilter.toString());
        buffer.append(")");
    }

    @Override
    public void setTimeLimitExpiration(Long timeLimitExpiration) {
        this.timeLimitExpiration = timeLimitExpiration;
    }

    @Override
    public boolean isReturnLDAPSubentries() {
        return this.returnLDAPSubentries;
    }

    @Override
    public void setReturnLDAPSubentries(boolean returnLDAPSubentries) {
        this.returnLDAPSubentries = returnLDAPSubentries;
    }

    @Override
    public MatchedValuesControl getMatchedValuesControl() {
        return this.matchedValuesControl;
    }

    @Override
    public void setMatchedValuesControl(MatchedValuesControl controls) {
        this.matchedValuesControl = controls;
    }

    @Override
    public boolean isIncludeUsableControl() {
        return this.includeUsableControl;
    }

    @Override
    public void setIncludeUsableControl(boolean includeUsableControl) {
        this.includeUsableControl = includeUsableControl;
    }

    @Override
    public Long getTimeLimitExpiration() {
        return this.timeLimitExpiration;
    }

    @Override
    public boolean isClientAcceptsReferrals() {
        return this.clientAcceptsReferrals;
    }

    @Override
    public void setClientAcceptsReferrals(boolean clientAcceptReferrals) {
        this.clientAcceptsReferrals = clientAcceptReferrals;
    }

    @Override
    public void incrementEntriesSent() {
        ++this.entriesSent;
    }

    @Override
    public void incrementReferencesSent() {
        ++this.referencesSent;
    }

    @Override
    public boolean isSendResponse() {
        return this.sendResponse;
    }

    @Override
    public void setSendResponse(boolean sendResponse) {
        this.sendResponse = sendResponse;
    }

    @Override
    public boolean isRealAttributesOnly() {
        return this.realAttributesOnly;
    }

    @Override
    public boolean isVirtualAttributesOnly() {
        return this.virtualAttributesOnly;
    }

    @Override
    public void setRealAttributesOnly(boolean realAttributesOnly) {
        this.realAttributesOnly = realAttributesOnly;
    }

    @Override
    public void setVirtualAttributesOnly(boolean virtualAttributesOnly) {
        this.virtualAttributesOnly = virtualAttributesOnly;
    }

    @Override
    public void sendSearchEntry(SearchResultEntry searchEntry) throws DirectoryException {
        this.getClientConnection().sendSearchEntry(this, searchEntry);
    }

    @Override
    public boolean sendSearchReference(SearchResultReference searchReference) throws DirectoryException {
        return this.getClientConnection().sendSearchReference(this, searchReference);
    }

    @Override
    public void setProxiedAuthorizationDN(DN proxiedAuthorizationDN) {
        this.proxiedAuthorizationDN = proxiedAuthorizationDN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void run() {
        block42: {
            block41: {
                block40: {
                    block39: {
                        this.setResultCode(ResultCode.UNDEFINED);
                        this.setProcessingStartTime();
                        AccessLogger.logSearchRequest(this);
                        this.setSendResponse(true);
                        PluginConfigManager pluginConfigManager = DirectoryServer.getPluginConfigManager();
                        int timeLimit = this.getTimeLimit();
                        Long timeLimitExpiration = timeLimit <= 0 ? Long.valueOf(Long.MAX_VALUE) : Long.valueOf(this.getProcessingStartTime() + 1000L * (long)timeLimit);
                        this.setTimeLimitExpiration(timeLimitExpiration);
                        try {
                            try {
                                this.checkIfCanceled(false);
                                PluginResult.PreParse preParseResult = pluginConfigManager.invokePreParseSearchPlugins(this);
                                if (!preParseResult.continueProcessing()) {
                                    this.setResultCode(preParseResult.getResultCode());
                                    this.appendErrorMessage(preParseResult.getErrorMessage());
                                    this.setMatchedDN(preParseResult.getMatchedDN());
                                    this.setReferralURLs(preParseResult.getReferralURLs());
                                    Object var9_6 = null;
                                    break block39;
                                }
                                this.checkIfCanceled(false);
                                DN baseDN = this.getBaseDN();
                                if (baseDN == null) {
                                    break block40;
                                }
                                NetworkGroup ng = this.getClientConnection().getNetworkGroup();
                                Workflow workflow = ng.getWorkflowCandidate(baseDN);
                                if (workflow == null) {
                                    this.updateOperationErrMsgAndResCode();
                                    break block41;
                                }
                                workflow.execute(this);
                                break block42;
                            }
                            catch (CanceledOperationException coe) {
                                if (DebugLogger.debugEnabled()) {
                                    TRACER.debugCaught(DebugLogLevel.ERROR, coe);
                                }
                                this.setResultCode(ResultCode.CANCELED);
                                this.cancelResult = new CancelResult(ResultCode.CANCELED, null);
                                this.appendErrorMessage(coe.getCancelRequest().getCancelReason());
                                Object var9_10 = null;
                                this.setProcessingStopTime();
                                if (this.cancelRequest == null || this.cancelResult == null || this.cancelResult.getResultCode() != ResultCode.CANCELED) {
                                    if (this.isSendResponse()) {
                                        this.sendSearchResultDone();
                                    } else {
                                        this.setSizeLimit(0);
                                        this.setTimeLimit(0);
                                    }
                                } else if (this.cancelRequest.notifyOriginalRequestor() || DirectoryServer.notifyAbandonedOperations()) {
                                    this.sendSearchResultDone();
                                }
                                if (this.cancelResult != null) return;
                                this.cancelResult = new CancelResult(ResultCode.TOO_LATE, null);
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var9_11 = null;
                            this.setProcessingStopTime();
                            if (this.cancelRequest == null || this.cancelResult == null || this.cancelResult.getResultCode() != ResultCode.CANCELED) {
                                if (this.isSendResponse()) {
                                    this.sendSearchResultDone();
                                } else {
                                    this.setSizeLimit(0);
                                    this.setTimeLimit(0);
                                }
                            } else if (this.cancelRequest.notifyOriginalRequestor() || DirectoryServer.notifyAbandonedOperations()) {
                                this.sendSearchResultDone();
                            }
                            if (this.cancelResult != null) throw throwable;
                            this.cancelResult = new CancelResult(ResultCode.TOO_LATE, null);
                            throw throwable;
                        }
                    }
                    this.setProcessingStopTime();
                    if (this.cancelRequest == null || this.cancelResult == null || this.cancelResult.getResultCode() != ResultCode.CANCELED) {
                        if (this.isSendResponse()) {
                            this.sendSearchResultDone();
                        } else {
                            this.setSizeLimit(0);
                            this.setTimeLimit(0);
                        }
                    } else if (this.cancelRequest.notifyOriginalRequestor() || DirectoryServer.notifyAbandonedOperations()) {
                        this.sendSearchResultDone();
                    }
                    if (this.cancelResult != null) return;
                    this.cancelResult = new CancelResult(ResultCode.TOO_LATE, null);
                    return;
                }
                Object var9_7 = null;
                this.setProcessingStopTime();
                if (this.cancelRequest == null || this.cancelResult == null || this.cancelResult.getResultCode() != ResultCode.CANCELED) {
                    if (this.isSendResponse()) {
                        this.sendSearchResultDone();
                    } else {
                        this.setSizeLimit(0);
                        this.setTimeLimit(0);
                    }
                } else if (this.cancelRequest.notifyOriginalRequestor() || DirectoryServer.notifyAbandonedOperations()) {
                    this.sendSearchResultDone();
                }
                if (this.cancelResult != null) return;
                this.cancelResult = new CancelResult(ResultCode.TOO_LATE, null);
                return;
            }
            Object var9_8 = null;
            this.setProcessingStopTime();
            if (this.cancelRequest == null || this.cancelResult == null || this.cancelResult.getResultCode() != ResultCode.CANCELED) {
                if (this.isSendResponse()) {
                    this.sendSearchResultDone();
                } else {
                    this.setSizeLimit(0);
                    this.setTimeLimit(0);
                }
            } else if (this.cancelRequest.notifyOriginalRequestor() || DirectoryServer.notifyAbandonedOperations()) {
                this.sendSearchResultDone();
            }
            if (this.cancelResult != null) return;
            this.cancelResult = new CancelResult(ResultCode.TOO_LATE, null);
            return;
        }
        Object var9_9 = null;
        this.setProcessingStopTime();
        if (this.cancelRequest == null || this.cancelResult == null || this.cancelResult.getResultCode() != ResultCode.CANCELED) {
            if (this.isSendResponse()) {
                this.sendSearchResultDone();
            } else {
                this.setSizeLimit(0);
                this.setTimeLimit(0);
            }
        } else if (this.cancelRequest.notifyOriginalRequestor() || DirectoryServer.notifyAbandonedOperations()) {
            this.sendSearchResultDone();
        }
        if (this.cancelResult != null) return;
        this.cancelResult = new CancelResult(ResultCode.TOO_LATE, null);
    }

    private void invokePostResponsePlugins() {
        PluginConfigManager pluginConfigManager = DirectoryServer.getPluginConfigManager();
        pluginConfigManager.invokePostResponseSearchPlugins(this);
    }

    private void updateOperationErrMsgAndResCode() {
        this.setResultCode(ResultCode.NO_SUCH_OBJECT);
        Message message = CoreMessages.ERR_SEARCH_BASE_DOESNT_EXIST.get(String.valueOf(this.getBaseDN()));
        this.appendErrorMessage(message);
    }
}

