/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.SortedSet;
import org.opends.messages.Message;
import org.opends.messages.MessageDescriptor;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.types.Attribute;
import org.opends.server.types.Attributes;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryCacheCommon {
    public static HashSet<SearchFilter> getFilters(SortedSet<String> filters, MessageDescriptor.Arg3<CharSequence, CharSequence, CharSequence> decodeErrorMsg, ConfigErrorHandler errorHandler, DN configEntryDN) {
        HashSet<SearchFilter> searchFilters = new HashSet<SearchFilter>();
        if (filters != null && !filters.isEmpty()) {
            for (String curFilter : filters) {
                try {
                    searchFilters.add(SearchFilter.createFilterFromString(curFilter));
                }
                catch (DirectoryException de) {
                    Message message = decodeErrorMsg.get(String.valueOf(configEntryDN), curFilter, de.getMessage() != null ? de.getMessage() : StaticUtils.stackTraceToSingleLineString(de));
                    errorHandler.reportError(message, false, ResultCode.INVALID_ATTRIBUTE_SYNTAX);
                }
            }
        }
        return searchFilters;
    }

    public static ConfigErrorHandler getConfigErrorHandler(ConfigPhase configPhase, List<Message> unacceptableReasons, ArrayList<Message> errorMessages) {
        EntryCacheCommon ec;
        ConfigErrorHandler errorHandler = null;
        EntryCacheCommon entryCacheCommon = ec = new EntryCacheCommon();
        entryCacheCommon.getClass();
        errorHandler = entryCacheCommon.new ConfigErrorHandler(configPhase, unacceptableReasons, errorMessages);
        return errorHandler;
    }

    public static ArrayList<Attribute> getGenericMonitorData(Long cacheHits, Long cacheMisses, Long cacheSize, Long maxCacheSize, Long cacheCount, Long maxCacheCount) {
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        if (cacheHits != null) {
            attrs.add(Attributes.create("entryCacheHits", cacheHits.toString()));
            if (cacheMisses != null) {
                Long cacheTries = cacheHits + cacheMisses;
                attrs.add(Attributes.create("entryCacheTries", cacheTries.toString()));
                Double hitRatioRaw = cacheTries > 0L ? cacheHits.doubleValue() / cacheTries.doubleValue() : cacheHits.doubleValue() / 1.0;
                Double hitRatio = hitRatioRaw * 100.0;
                attrs.add(Attributes.create("entryCacheHitRatio", Long.toString(hitRatio.longValue())));
            }
        }
        if (cacheSize != null) {
            attrs.add(Attributes.create("currentEntryCacheSize", cacheSize.toString()));
        }
        if (maxCacheSize != null) {
            attrs.add(Attributes.create("maxEntryCacheSize", maxCacheSize.toString()));
        }
        if (cacheCount != null) {
            attrs.add(Attributes.create("currentEntryCacheCount", cacheCount.toString()));
        }
        if (maxCacheCount != null) {
            attrs.add(Attributes.create("maxEntryCacheCount", maxCacheCount.toString()));
        }
        return attrs;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ConfigErrorHandler {
        private ConfigPhase _configPhase;
        private List<Message> _unacceptableReasons;
        private ArrayList<Message> _errorMessages;
        private ResultCode _resultCode;
        private boolean _isAcceptable;
        private boolean _isAdminActionRequired;

        public ConfigErrorHandler(ConfigPhase configPhase, List<Message> unacceptableReasons, ArrayList<Message> errorMessages) {
            this._configPhase = configPhase;
            this._unacceptableReasons = unacceptableReasons;
            this._errorMessages = errorMessages;
            this._resultCode = ResultCode.SUCCESS;
            this._isAcceptable = true;
            this._isAdminActionRequired = false;
        }

        public void reportError(Message error, boolean isAcceptable, ResultCode resultCode) {
            switch (this._configPhase) {
                case PHASE_INIT: {
                    this._errorMessages.add(error);
                    this._isAcceptable = isAcceptable;
                    break;
                }
                case PHASE_ACCEPTABLE: {
                    this._unacceptableReasons.add(error);
                    this._isAcceptable = isAcceptable;
                    break;
                }
                case PHASE_APPLY: {
                    this._errorMessages.add(error);
                    this._isAcceptable = isAcceptable;
                    if (this._resultCode != ResultCode.SUCCESS) break;
                    this._resultCode = resultCode;
                }
            }
        }

        public void reportError(Message error, boolean isAcceptable, ResultCode resultCode, boolean isAdminActionRequired) {
            switch (this._configPhase) {
                case PHASE_INIT: {
                    ErrorLogger.logError(error);
                    break;
                }
                case PHASE_ACCEPTABLE: {
                    this._unacceptableReasons.add(error);
                    this._isAcceptable = isAcceptable;
                    break;
                }
                case PHASE_APPLY: {
                    this._errorMessages.add(error);
                    this._isAcceptable = isAcceptable;
                    if (this._resultCode == ResultCode.SUCCESS) {
                        this._resultCode = resultCode;
                    }
                    this._isAdminActionRequired = isAdminActionRequired;
                }
            }
        }

        public ResultCode getResultCode() {
            return this._resultCode;
        }

        public boolean getIsAcceptable() {
            return this._isAcceptable;
        }

        public List<Message> getUnacceptableReasons() {
            return this._unacceptableReasons;
        }

        public ArrayList<Message> getErrorMessages() {
            return this._errorMessages;
        }

        public ConfigPhase getConfigPhase() {
            return this._configPhase;
        }

        public boolean getIsAdminActionRequired() {
            return this._isAdminActionRequired;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConfigPhase {
        PHASE_INIT,
        PHASE_ACCEPTABLE,
        PHASE_APPLY;

    }
}

