/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.ArrayList;
import java.util.List;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.AlertHandlerCfg;
import org.opends.server.admin.std.server.SMTPAlertHandlerCfg;
import org.opends.server.api.AlertGenerator;
import org.opends.server.api.AlertHandler;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.EMailMessage;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMTPAlertHandler
implements AlertHandler<SMTPAlertHandlerCfg>,
ConfigurationChangeListener<SMTPAlertHandlerCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private SMTPAlertHandlerCfg currentConfig;

    @Override
    public void initializeAlertHandler(SMTPAlertHandlerCfg configuration) throws ConfigException, InitializationException {
        if (DirectoryServer.getMailServerPropertySets() == null || DirectoryServer.getMailServerPropertySets().isEmpty()) {
            Message message = ExtensionMessages.ERR_SMTPALERTHANDLER_NO_SMTP_SERVERS.get();
            throw new ConfigException(message);
        }
        configuration.addSMTPChangeListener(this);
        this.currentConfig = configuration;
    }

    @Override
    public AlertHandlerCfg getAlertHandlerConfiguration() {
        return this.currentConfig;
    }

    @Override
    public boolean isConfigurationAcceptable(AlertHandlerCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public void finalizeAlertHandler() {
    }

    @Override
    public void sendAlertNotification(AlertGenerator generator, String alertType, Message alertMessage) {
        String alertMessageStr;
        String alertIDStr;
        SMTPAlertHandlerCfg cfg = this.currentConfig;
        ArrayList<String> recipients = new ArrayList<String>(cfg.getRecipientAddress());
        if (alertMessage != null) {
            alertIDStr = String.valueOf(alertMessage.getDescriptor().getId());
            alertMessageStr = alertMessage.toString();
        } else {
            alertIDStr = String.valueOf(-1);
            alertMessageStr = "none";
        }
        String subject = this.replaceTokens(cfg.getMessageSubject(), alertType, alertIDStr, alertMessageStr);
        String body = this.replaceTokens(cfg.getMessageBody(), alertType, alertIDStr, alertMessageStr);
        EMailMessage message = new EMailMessage(cfg.getSenderAddress(), recipients, subject);
        message.setBody(Message.raw(StaticUtils.wrapText(body, 75), new Object[0]));
        try {
            message.send();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message msg = ExtensionMessages.WARN_SMTPALERTHANDLER_ERROR_SENDING_MESSAGE.get(alertType, alertMessage, e.getLocalizedMessage());
            ErrorLogger.logError(msg);
        }
    }

    private String replaceTokens(String s, String alertType, String alertID, String alertMessage) {
        return s.replace("%%alert-type%%", alertType).replace("%%alert-id%%", alertID).replace("%%alert-message%%", alertMessage).replace("\\n", "\r\n");
    }

    @Override
    public boolean isConfigurationChangeAcceptable(SMTPAlertHandlerCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(SMTPAlertHandlerCfg configuration) {
        this.currentConfig = configuration;
        return new ConfigChangeResult(ResultCode.SUCCESS, false);
    }
}

