/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.security.cert.Certificate;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedSet;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.opends.server.admin.std.server.LDAPConnectionHandlerCfg;
import org.opends.server.api.ClientConnection;
import org.opends.server.extensions.ConnectionSecurityProvider;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.util.StaticUtils;

public class TLSByteChannel
implements ByteChannel,
ConnectionSecurityProvider {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ClientConnection connection;
    private SocketChannel socketChannel;
    private SSLEngine sslEngine;
    private ByteBuffer appData;
    private ByteBuffer appNetData;
    private ByteBuffer netData;
    private ByteBuffer tempData;
    private int sslBufferSize;
    private int appBufSize;
    private boolean reading = false;
    private static final Map<String, Integer> cipherMap = new LinkedHashMap<String, Integer>();

    private TLSByteChannel(LDAPConnectionHandlerCfg config, ClientConnection c, SocketChannel socketChannel, SSLContext sslContext) {
        SortedSet<String> ciphers;
        this.socketChannel = socketChannel;
        this.connection = c;
        String hostName = socketChannel.socket().getInetAddress().getHostName();
        int port = socketChannel.socket().getPort();
        this.sslEngine = sslContext.createSSLEngine(hostName, port);
        this.sslEngine.setUseClientMode(false);
        SortedSet<String> protocols = config.getSSLProtocol();
        if (!protocols.isEmpty()) {
            this.sslEngine.setEnabledProtocols(protocols.toArray(new String[0]));
        }
        if (!(ciphers = config.getSSLCipherSuite()).isEmpty()) {
            this.sslEngine.setEnabledCipherSuites(ciphers.toArray(new String[0]));
        }
        switch (config.getSSLClientAuthPolicy()) {
            case DISABLED: {
                this.sslEngine.setNeedClientAuth(false);
                this.sslEngine.setWantClientAuth(false);
                break;
            }
            case REQUIRED: {
                this.sslEngine.setWantClientAuth(true);
                this.sslEngine.setNeedClientAuth(true);
                break;
            }
            default: {
                this.sslEngine.setNeedClientAuth(false);
                this.sslEngine.setWantClientAuth(true);
            }
        }
        SSLSession sslSession = this.sslEngine.getSession();
        this.sslBufferSize = sslSession.getPacketBufferSize();
        this.appBufSize = sslSession.getApplicationBufferSize();
        this.appNetData = ByteBuffer.allocate(this.sslBufferSize);
        this.netData = ByteBuffer.allocate(this.sslBufferSize);
        this.appData = ByteBuffer.allocate(sslSession.getApplicationBufferSize());
        this.tempData = ByteBuffer.allocate(sslSession.getApplicationBufferSize());
    }

    public int getAppBufSize() {
        return this.appBufSize;
    }

    public static TLSByteChannel getTLSByteChannel(LDAPConnectionHandlerCfg config, ClientConnection c, SSLContext sslContext, SocketChannel socketChannel) {
        return new TLSByteChannel(config, c, socketChannel, sslContext);
    }

    private SSLEngineResult.HandshakeStatus doTasks() {
        Runnable task;
        while ((task = this.sslEngine.getDelegatedTask()) != null) {
            task.run();
        }
        return this.sslEngine.getHandshakeStatus();
    }

    private void doHandshakeRead(SSLEngineResult.HandshakeStatus hsStatus) throws IOException {
        do {
            this.doHandshakeOp(hsStatus);
        } while ((hsStatus = this.sslEngine.getHandshakeStatus()) == SSLEngineResult.HandshakeStatus.NEED_WRAP || hsStatus == SSLEngineResult.HandshakeStatus.NEED_TASK);
    }

    private void doHandshakeOp(SSLEngineResult.HandshakeStatus hsStatus) throws IOException {
        switch (hsStatus) {
            case NEED_TASK: {
                hsStatus = this.doTasks();
                break;
            }
            case NEED_WRAP: {
                this.tempData.clear();
                this.netData.clear();
                SSLEngineResult res = this.sslEngine.wrap(this.tempData, this.netData);
                hsStatus = res.getHandshakeStatus();
                this.netData.flip();
                while (this.netData.hasRemaining()) {
                    this.socketChannel.write(this.netData);
                }
                hsStatus = this.sslEngine.getHandshakeStatus();
                return;
            }
            default: {
                return;
            }
        }
    }

    public int read(ByteBuffer clearBuffer) throws IOException {
        SSLEngineResult.HandshakeStatus hsStatus;
        if (!this.reading) {
            this.appNetData.clear();
        } else {
            this.reading = false;
        }
        if (!this.socketChannel.isOpen()) {
            return -1;
        }
        if (this.sslEngine.isInboundDone()) {
            return -1;
        }
        block0: do {
            int wrappedBytes = this.socketChannel.read(this.appNetData);
            this.appNetData.flip();
            if (wrappedBytes == -1) {
                return -1;
            }
            hsStatus = this.sslEngine.getHandshakeStatus();
            if (hsStatus == SSLEngineResult.HandshakeStatus.NEED_TASK || hsStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                this.doHandshakeRead(hsStatus);
            }
            if (wrappedBytes == 0) {
                return 0;
            }
            while (this.appNetData.hasRemaining()) {
                this.appData.clear();
                SSLEngineResult res = this.sslEngine.unwrap(this.appNetData, this.appData);
                this.appData.flip();
                if (res.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                    this.appNetData.compact();
                    this.reading = true;
                    continue block0;
                }
                if (res.getStatus() != SSLEngineResult.Status.OK) {
                    return -1;
                }
                hsStatus = this.sslEngine.getHandshakeStatus();
                if (hsStatus == SSLEngineResult.HandshakeStatus.NEED_TASK || hsStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                    this.doHandshakeOp(hsStatus);
                }
                clearBuffer.put(this.appData);
            }
        } while ((hsStatus = this.sslEngine.getHandshakeStatus()) == SSLEngineResult.HandshakeStatus.NEED_TASK || hsStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP);
        return clearBuffer.position();
    }

    public void close() throws IOException {
        this.sslEngine.closeInbound();
        this.sslEngine.closeOutbound();
        SSLEngineResult.HandshakeStatus hsStatus = this.sslEngine.getHandshakeStatus();
        if (hsStatus != SSLEngineResult.HandshakeStatus.FINISHED && hsStatus != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            this.doHandshakeWrite(hsStatus);
        }
    }

    public boolean isOpen() {
        return !this.sslEngine.isInboundDone() && !this.sslEngine.isOutboundDone();
    }

    public int getSSF() {
        int cipherKeySSF = 0;
        String cipherString = this.sslEngine.getSession().getCipherSuite();
        for (Map.Entry<String, Integer> mapEntry : cipherMap.entrySet()) {
            if (cipherString.indexOf(mapEntry.getKey()) < 0) continue;
            cipherKeySSF = mapEntry.getValue();
            break;
        }
        return cipherKeySSF;
    }

    public Certificate[] getClientCertificateChain() {
        try {
            return this.sslEngine.getSession().getPeerCertificates();
        }
        catch (SSLPeerUnverifiedException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return new Certificate[0];
        }
    }

    private void doHandshakeUnwrap() throws IOException {
        this.netData.clear();
        this.tempData.clear();
        int bytesRead = this.socketChannel.read(this.netData);
        if (bytesRead <= 0) {
            throw new ClosedChannelException();
        }
        this.sslEngine.unwrap(this.netData, this.tempData);
    }

    private void doHandshakeWrite(SSLEngineResult.HandshakeStatus hsStatus) throws IOException {
        do {
            if (hsStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                this.doHandshakeUnwrap();
                continue;
            }
            this.doHandshakeOp(hsStatus);
        } while ((hsStatus = this.sslEngine.getHandshakeStatus()) == SSLEngineResult.HandshakeStatus.NEED_WRAP || hsStatus == SSLEngineResult.HandshakeStatus.NEED_TASK || hsStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP);
    }

    public int write(ByteBuffer clearData) throws IOException {
        if (!this.socketChannel.isOpen() || this.sslEngine.isOutboundDone()) {
            throw new ClosedChannelException();
        }
        int originalPosition = clearData.position();
        int originalLimit = clearData.limit();
        int length = originalLimit - originalPosition;
        if (length > this.sslBufferSize) {
            int pos = originalPosition;
            int lim = originalPosition + this.sslBufferSize;
            while (pos < originalLimit) {
                clearData.position(pos);
                clearData.limit(lim);
                this.writeInternal(clearData);
                pos = lim;
                lim = Math.min(originalLimit, pos + this.sslBufferSize);
            }
            return length;
        }
        return this.writeInternal(clearData);
    }

    private int writeInternal(ByteBuffer clearData) throws IOException {
        int totBytesSent = 0;
        SSLEngineResult.HandshakeStatus hsStatus = this.sslEngine.getHandshakeStatus();
        if (hsStatus == SSLEngineResult.HandshakeStatus.NEED_TASK || hsStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP || hsStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
            this.doHandshakeWrite(hsStatus);
        }
        while (clearData.hasRemaining()) {
            this.netData.clear();
            SSLEngineResult res = this.sslEngine.wrap(clearData, this.netData);
            this.netData.flip();
            if (res.getStatus() != SSLEngineResult.Status.OK) {
                throw new ClosedChannelException();
            }
            if (hsStatus == SSLEngineResult.HandshakeStatus.NEED_TASK || hsStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP || hsStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                this.doHandshakeWrite(hsStatus);
            }
            while (this.netData.hasRemaining()) {
                int bytesWritten = this.socketChannel.write(this.netData);
                if (bytesWritten < 0) {
                    throw new ClosedChannelException();
                }
                if (bytesWritten == 0) {
                    int bytesSent = this.netData.remaining();
                    if (!StaticUtils.writeWithTimeout(this.connection, this.netData)) {
                        throw new ClosedChannelException();
                    }
                    totBytesSent += bytesSent;
                    continue;
                }
                totBytesSent += bytesWritten;
            }
        }
        return totBytesSent;
    }

    public ByteChannel wrapChannel(ByteChannel channel) {
        return this;
    }

    public String getName() {
        return "TLS";
    }

    public boolean isSecure() {
        return true;
    }

    static {
        cipherMap.put("_WITH_AES_256_CBC_", new Integer(256));
        cipherMap.put("_WITH_CAMELLIA_256_CBC_", new Integer(256));
        cipherMap.put("_WITH_AES_256_GCM_", new Integer(256));
        cipherMap.put("_WITH_3DES_EDE_CBC_", new Integer(112));
        cipherMap.put("_WITH_AES_128_GCM_", new Integer(128));
        cipherMap.put("_WITH_SEED_CBC_", new Integer(128));
        cipherMap.put("_WITH_CAMELLIA_128_CBC_", new Integer(128));
        cipherMap.put("_WITH_AES_128_CBC_", new Integer(128));
        cipherMap.put("_WITH_IDEA_CBC_", new Integer(128));
        cipherMap.put("_WITH_DES_CBC_", new Integer(56));
        cipherMap.put("_WITH_RC2_CBC_40_", new Integer(40));
        cipherMap.put("_WITH_RC4_40_", new Integer(40));
        cipherMap.put("_WITH_DES40_CBC_", new Integer(40));
        cipherMap.put("_WITH_NULL_", new Integer(0));
    }
}

