/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.opends.messages.ConfigMessages;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.TraditionalWorkQueueCfg;
import org.opends.server.api.WorkQueue;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.extensions.TraditionalWorkerThread;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.monitors.TraditionalWorkQueueMonitor;
import org.opends.server.types.AbstractOperation;
import org.opends.server.types.CancelRequest;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.Operation;
import org.opends.server.types.ResultCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraditionalWorkQueue
extends WorkQueue<TraditionalWorkQueueCfg>
implements ConfigurationChangeListener<TraditionalWorkQueueCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final int MAX_RETRY_COUNT = 5;
    private ArrayList<TraditionalWorkerThread> workerThreads;
    private AtomicLong opsSubmitted;
    private AtomicLong queueFullRejects;
    private boolean killThreads;
    private boolean shutdownRequested;
    private int lastThreadNumber;
    private int maxCapacity;
    private int numWorkerThreads;
    private LinkedBlockingQueue<AbstractOperation> opQueue;
    private Object queueLock;

    @Override
    public void initializeWorkQueue(TraditionalWorkQueueCfg configuration) throws ConfigException, InitializationException {
        this.shutdownRequested = false;
        this.killThreads = false;
        this.opsSubmitted = new AtomicLong(0L);
        this.queueFullRejects = new AtomicLong(0L);
        this.queueLock = new Object();
        configuration.addTraditionalChangeListener(this);
        this.numWorkerThreads = this.getNumWorkerThreads(configuration);
        this.maxCapacity = configuration.getMaxWorkQueueCapacity();
        this.opQueue = this.maxCapacity > 0 ? new LinkedBlockingQueue(this.maxCapacity) : new LinkedBlockingQueue();
        this.workerThreads = new ArrayList(this.numWorkerThreads);
        this.lastThreadNumber = 0;
        while (this.lastThreadNumber < this.numWorkerThreads) {
            TraditionalWorkerThread t = new TraditionalWorkerThread(this, this.lastThreadNumber);
            t.start();
            this.workerThreads.add(t);
            ++this.lastThreadNumber;
        }
        try {
            TraditionalWorkQueueMonitor monitor = new TraditionalWorkQueueMonitor(this);
            monitor.initializeMonitorProvider(null);
            monitor.start();
            DirectoryServer.registerMonitorProvider(monitor);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ConfigMessages.ERR_CONFIG_WORK_QUEUE_CANNOT_CREATE_MONITOR.get(String.valueOf(TraditionalWorkQueueMonitor.class), String.valueOf(e));
            ErrorLogger.logError(message);
        }
    }

    @Override
    public void finalizeWorkQueue(Message reason) {
        this.shutdownRequested = true;
        CancelRequest cancelRequest = new CancelRequest(true, reason);
        ArrayList pendingOperations = new ArrayList();
        this.opQueue.removeAll(pendingOperations);
        for (Operation o : pendingOperations) {
            try {
                if (o.getCancelResult() != null) continue;
                o.abort(cancelRequest);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                ErrorLogger.logError(CoreMessages.WARN_QUEUE_UNABLE_TO_CANCEL.get(String.valueOf(o), String.valueOf(e)));
            }
        }
        for (TraditionalWorkerThread t : this.workerThreads) {
            try {
                t.shutDown();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                ErrorLogger.logError(CoreMessages.WARN_QUEUE_UNABLE_TO_NOTIFY_THREAD.get(t.getName(), String.valueOf(e)));
            }
        }
    }

    public boolean shutdownRequested() {
        return this.shutdownRequested;
    }

    @Override
    public void submitOperation(AbstractOperation operation) throws DirectoryException {
        if (this.shutdownRequested) {
            Message message = CoreMessages.WARN_OP_REJECTED_BY_SHUTDOWN.get();
            throw new DirectoryException(ResultCode.UNAVAILABLE, message);
        }
        if (!this.opQueue.offer(operation)) {
            this.queueFullRejects.incrementAndGet();
            Message message = CoreMessages.WARN_OP_REJECTED_BY_QUEUE_FULL.get(this.maxCapacity);
            throw new DirectoryException(ResultCode.UNAVAILABLE, message);
        }
        this.opsSubmitted.incrementAndGet();
    }

    public AbstractOperation nextOperation(TraditionalWorkerThread workerThread) {
        return this.retryNextOperation(workerThread, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AbstractOperation retryNextOperation(TraditionalWorkerThread workerThread, int numFailures) {
        block25: {
            if (this.killThreads) {
                Object object = this.queueLock;
                synchronized (object) {
                    try {
                        int currentThreads = this.workerThreads.size();
                        if (currentThreads > this.numWorkerThreads) {
                            if (this.workerThreads.remove(Thread.currentThread())) {
                                --currentThreads;
                            }
                            if (currentThreads <= this.numWorkerThreads) {
                                this.killThreads = false;
                            }
                            workerThread.setStoppedByReducedThreadNumber();
                            return null;
                        }
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) break block25;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
            }
        }
        if (this.shutdownRequested || numFailures > 5) {
            if (numFailures > 5) {
                Message message = ConfigMessages.ERR_CONFIG_WORK_QUEUE_TOO_MANY_FAILURES.get(Thread.currentThread().getName(), numFailures, 5);
                ErrorLogger.logError(message);
            }
            return null;
        }
        try {
            while (true) {
                block26: {
                    AbstractOperation nextOperation;
                    if ((nextOperation = this.opQueue.poll(5L, TimeUnit.SECONDS)) != null) {
                        return nextOperation;
                    }
                    if (this.shutdownRequested) {
                        return null;
                    }
                    if (!this.killThreads) continue;
                    Object object = this.queueLock;
                    synchronized (object) {
                        try {
                            int currentThreads = this.workerThreads.size();
                            if (currentThreads > this.numWorkerThreads) {
                                if (this.workerThreads.remove(Thread.currentThread())) {
                                    --currentThreads;
                                }
                                if (currentThreads <= this.numWorkerThreads) {
                                    this.killThreads = false;
                                }
                                workerThread.setStoppedByReducedThreadNumber();
                                return null;
                            }
                        }
                        catch (Exception e) {
                            if (!DebugLogger.debugEnabled()) break block26;
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                    }
                }
            }
        }
        catch (InterruptedException ie) {
            if (this.shutdownRequested) {
                return null;
            }
            ErrorLogger.logError(CoreMessages.WARN_WORKER_INTERRUPTED_WITHOUT_SHUTDOWN.get(Thread.currentThread().getName(), String.valueOf(ie)));
            return this.retryNextOperation(workerThread, numFailures + 1);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            ErrorLogger.logError(CoreMessages.WARN_WORKER_WAITING_UNCAUGHT_EXCEPTION.get(Thread.currentThread().getName(), String.valueOf(e)));
            return this.retryNextOperation(workerThread, numFailures + 1);
        }
    }

    public boolean removeOperation(AbstractOperation operation) {
        return this.opQueue.remove(operation);
    }

    public long getOpsSubmitted() {
        return this.opsSubmitted.longValue();
    }

    public long getOpsRejectedDueToQueueFull() {
        return this.queueFullRejects.longValue();
    }

    public int size() {
        return this.opQueue.size();
    }

    @Override
    public boolean isConfigurationChangeAcceptable(TraditionalWorkQueueCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigChangeResult applyConfigurationChange(TraditionalWorkQueueCfg configuration) {
        Object object;
        ArrayList<Message> resultMessages = new ArrayList<Message>();
        int newNumThreads = configuration.getNumWorkerThreads();
        int newMaxCapacity = configuration.getMaxWorkQueueCapacity();
        int currentThreads = this.workerThreads.size();
        if (newNumThreads != currentThreads) {
            object = this.queueLock;
            synchronized (object) {
                block19: {
                    try {
                        int threadsToAdd = newNumThreads - currentThreads;
                        if (threadsToAdd > 0) {
                            for (int i = 0; i < threadsToAdd; ++i) {
                                TraditionalWorkerThread t = new TraditionalWorkerThread(this, this.lastThreadNumber++);
                                this.workerThreads.add(t);
                                t.start();
                            }
                            this.killThreads = false;
                        } else {
                            this.killThreads = true;
                        }
                        this.numWorkerThreads = newNumThreads;
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) break block19;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
            }
        }
        if (newMaxCapacity != this.maxCapacity) {
            object = this.queueLock;
            synchronized (object) {
                block20: {
                    try {
                        LinkedBlockingQueue<AbstractOperation> newOpQueue = newMaxCapacity > 0 ? new LinkedBlockingQueue(newMaxCapacity) : new LinkedBlockingQueue<AbstractOperation>();
                        LinkedBlockingQueue<AbstractOperation> oldOpQueue = this.opQueue;
                        this.opQueue = newOpQueue;
                        LinkedList pendingOps = new LinkedList();
                        oldOpQueue.drainTo(pendingOps);
                        while (!pendingOps.isEmpty()) {
                            Iterator iterator = pendingOps.iterator();
                            while (iterator.hasNext()) {
                                AbstractOperation o = (AbstractOperation)iterator.next();
                                try {
                                    if (!newOpQueue.offer(o, 1000L, TimeUnit.MILLISECONDS)) continue;
                                    iterator.remove();
                                }
                                catch (InterruptedException ie) {
                                    if (!DebugLogger.debugEnabled()) continue;
                                    TRACER.debugCaught(DebugLogLevel.ERROR, ie);
                                }
                            }
                        }
                        this.maxCapacity = newMaxCapacity;
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) break block20;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
            }
        }
        return new ConfigChangeResult(ResultCode.SUCCESS, false, resultMessages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isIdle() {
        if (this.opQueue.size() > 0) {
            return false;
        }
        Object object = this.queueLock;
        synchronized (object) {
            for (TraditionalWorkerThread t : this.workerThreads) {
                if (!t.isActive()) continue;
                return false;
            }
            return true;
        }
    }

    private int getNumWorkerThreads(TraditionalWorkQueueCfg configuration) {
        if (configuration.getNumWorkerThreads() == null) {
            int cpus = Runtime.getRuntime().availableProcessors();
            int value = Math.max(24, cpus * 2);
            Message message = CoreMessages.INFO_ERGONOMIC_SIZING_OF_WORKER_THREAD_POOL.get(value);
            ErrorLogger.logError(message);
            return value;
        }
        return configuration.getNumWorkerThreads();
    }
}

