/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.opends.messages.LoggerMessages;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.FreeDiskSpaceLogRetentionPolicyCfg;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.FileComparator;
import org.opends.server.loggers.FileNamingPolicy;
import org.opends.server.loggers.RetentionPolicy;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreeDiskSpaceRetentionPolicy
implements RetentionPolicy<FreeDiskSpaceLogRetentionPolicyCfg>,
ConfigurationChangeListener<FreeDiskSpaceLogRetentionPolicyCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private long freeDiskSpace = 0L;
    private FreeDiskSpaceLogRetentionPolicyCfg config;

    @Override
    public void initializeLogRetentionPolicy(FreeDiskSpaceLogRetentionPolicyCfg config) {
        this.freeDiskSpace = config.getFreeDiskSpace();
        this.config = config;
        config.addFreeDiskSpaceChangeListener(this);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(FreeDiskSpaceLogRetentionPolicyCfg config, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(FreeDiskSpaceLogRetentionPolicyCfg config) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        this.freeDiskSpace = config.getFreeDiskSpace();
        this.config = config;
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public File[] deleteFiles(FileNamingPolicy fileNamingPolicy) throws DirectoryException {
        File[] files = fileNamingPolicy.listFiles();
        if (files == null) {
            Message message = LoggerMessages.ERR_LOGGER_ERROR_LISTING_FILES.get(fileNamingPolicy.getInitialName().toString());
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        ArrayList<File> filesToDelete = new ArrayList<File>();
        if (files.length <= 0) {
            return new File[0];
        }
        long freeSpace = 0L;
        try {
            Method meth = File.class.getMethod("getFreeSpace", new Class[0]);
            Object value = meth.invoke((Object)files[0], new Object[0]);
            freeSpace = (Long)value;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = LoggerMessages.ERR_LOGGER_ERROR_OBTAINING_FREE_SPACE.get(files[0].toString(), StaticUtils.stackTraceToSingleLineString(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Current free disk space: %d, Required: %d", freeSpace, this.freeDiskSpace);
        }
        if (freeSpace > this.freeDiskSpace) {
            return new File[0];
        }
        long freeSpaceNeeded = this.freeDiskSpace - freeSpace;
        Arrays.sort(files, new FileComparator());
        long freedSpace = 0L;
        for (int j = files.length - 1; j < 1; --j) {
            filesToDelete.add(files[j]);
            if ((freedSpace += files[j].length()) >= freeSpaceNeeded) break;
        }
        return filesToDelete.toArray(new File[0]);
    }

    public String toString() {
        return "Free Disk Retention Policy " + this.config.dn().toString();
    }
}

