/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers.debug;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.annotation.SuppressAjWarnings;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;

@Aspect
public class DebugAspect {
    @Pointcut(value="!this(Object)")
    private void staticContext() {
    }

    @Pointcut(value="this(obj)")
    private void nonStaticContext(Object obj) {
    }

    @Pointcut(value="execution(* *..toString(..))")
    private void toStringMethod() {
    }

    @Pointcut(value="execution(String org.opends.server.messages.MessageHandler.getMessage(..))")
    private void getMessageMethod() {
    }

    @Pointcut(value="execution(* *..getDebugProperties(..))")
    private void getDebugPropertiesMethod() {
    }

    @Pointcut(value="within(org.opends.server.loggers.*+ || org.opends.server.loggers.debug..*+ || org.opends.server.types.DebugLogLevel+ || org.opends.server.types.DebugLogCategory+ || org.opends.server.api.DebugLogPublisher+ || org.opends.server.util.TimeThread+ ||org.opends.server.util.MultiOutputStream+)")
    private void debugRelatedClasses() {
    }

    @Pointcut(value="toStringMethod() || getMessageMethod() || getDebugPropertiesMethod() || debugRelatedClasses()")
    private void excluded() {
    }

    @Pointcut(value="execution(!@(DebugLogger.NoDebugTracing || DebugLogger.NoEntryDebugTracing) public * *(..)) && !excluded()")
    void tracedEntryMethod() {
    }

    @Pointcut(value="execution(!@(DebugLogger.NoDebugTracing || DebugLogger.NoExitDebugTracing) public * *(..)) && !excluded()")
    void tracedExitMethod() {
    }

    @Pointcut(value="execution(@DebugLogger.TraceThrown public * *(..)) && !excluded()")
    void tracedThrownMethod() {
    }

    @Pointcut(value="execution(!@(DebugLogger.NoDebugTracing || DebugLogger.NoEntryDebugTracing) public new(..)) && !excluded()")
    void tracedEntryConstructor() {
    }

    @Pointcut(value="execution(!@(DebugLogger.NoDebugTracing || DebugLogger.NoExitDebugTracing) public new(..)) && !excluded()")
    void tracedExitConstructor() {
    }

    @Pointcut(value="if()")
    public static boolean shouldTrace() {
        return DebugLogger.enabled;
    }

    @Before(value="shouldTrace() && tracedEntryConstructor()")
    public void traceConstructor(JoinPoint thisJoinPoint) {
        String signature = thisJoinPoint.getSignature().getDeclaringTypeName();
        Object[] args = thisJoinPoint.getArgs();
        DebugTracer tracer = DebugLogger.getTracer(signature);
        if (tracer != null) {
            tracer.debugConstructor(DebugLogger.DEFAULT_CONSTRUCTOR_LEVEL, args);
        }
    }

    @Before(value="shouldTrace() && tracedEntryMethod() && nonStaticContext(obj)")
    public void traceNonStaticMethodEntry(JoinPoint thisJoinPoint, Object obj) {
        String signature = thisJoinPoint.getSignature().getDeclaringTypeName();
        Object[] args = thisJoinPoint.getArgs();
        Object callerInstance = thisJoinPoint.getThis();
        DebugTracer tracer = DebugLogger.getTracer(signature);
        if (tracer != null) {
            tracer.debugMethodEntry(DebugLogger.DEFAULT_ENTRY_EXIT_LEVEL, callerInstance, args);
        }
    }

    @Before(value="shouldTrace() && tracedEntryMethod() && staticContext()")
    public void traceStaticMethodEntry(JoinPoint thisJoinPoint) {
        String signature = thisJoinPoint.getSignature().getDeclaringTypeName();
        Object[] args = thisJoinPoint.getArgs();
        DebugTracer tracer = DebugLogger.getTracer(signature);
        if (tracer != null) {
            tracer.debugStaticMethodEntry(DebugLogger.DEFAULT_ENTRY_EXIT_LEVEL, args);
        }
    }

    @AfterReturning(pointcut="shouldTrace() && (tracedExitMethod() || tracedExitConstructor())", returning="ret")
    public void traceReturn(JoinPoint.StaticPart thisJoinPointStaticPart, Object ret) {
        String signature = thisJoinPointStaticPart.getSignature().getDeclaringTypeName();
        DebugTracer tracer = DebugLogger.getTracer(signature);
        if (tracer != null) {
            tracer.debugReturn(DebugLogger.DEFAULT_ENTRY_EXIT_LEVEL, ret);
        }
    }

    @SuppressAjWarnings(value={"adviceDidNotMatch"})
    @AfterThrowing(pointcut="shouldTrace() && tracedThrownMethod()", throwing="ex")
    public void traceThrown(JoinPoint.StaticPart thisJoinPointStaticPart, Throwable ex) {
        String signature = thisJoinPointStaticPart.getSignature().getDeclaringTypeName();
        DebugTracer tracer = DebugLogger.getTracer(signature);
        if (tracer != null) {
            tracer.debugThrown(DebugLogger.DEFAULT_THROWN_LEVEL, ex);
        }
    }
}

