/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.monitors;

import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.opends.server.admin.std.server.StackTraceMonitorProviderCfg;
import org.opends.server.api.MonitorProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.InitializationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackTraceMonitorProvider
extends MonitorProvider<StackTraceMonitorProviderCfg> {
    public StackTraceMonitorProvider() {
        super("Stack Trace Monitor Provider");
    }

    @Override
    public void initializeMonitorProvider(StackTraceMonitorProviderCfg configuration) throws ConfigException, InitializationException {
    }

    @Override
    public String getMonitorInstanceName() {
        return "JVM Stack Trace";
    }

    @Override
    public long getUpdateInterval() {
        return 0L;
    }

    @Override
    public void updateMonitorData() {
    }

    public ArrayList<Attribute> getMonitorData() {
        Map<Thread, StackTraceElement[]> threadStacks = Thread.getAllStackTraces();
        TreeMap<Long, Map.Entry<Thread, StackTraceElement[]>> orderedStacks = new TreeMap<Long, Map.Entry<Thread, StackTraceElement[]>>();
        for (Map.Entry<Thread, StackTraceElement[]> e : threadStacks.entrySet()) {
            orderedStacks.put(e.getKey().getId(), e);
        }
        AttributeType attrType = DirectoryServer.getDefaultAttributeType("jvmThread");
        AttributeBuilder builder = new AttributeBuilder(attrType);
        for (Map.Entry e : orderedStacks.values()) {
            Thread t = (Thread)e.getKey();
            StackTraceElement[] stackElements = (StackTraceElement[])e.getValue();
            long id = t.getId();
            StringBuilder buffer = new StringBuilder();
            buffer.append("id=");
            buffer.append(id);
            buffer.append(" ---------- ");
            buffer.append(t.getName());
            buffer.append(" ----------");
            builder.add(AttributeValues.create(attrType, buffer.toString()));
            if (stackElements == null) continue;
            for (int j = 0; j < stackElements.length; ++j) {
                buffer = new StringBuilder();
                buffer.append("id=");
                buffer.append(id);
                buffer.append(" frame[");
                buffer.append(j);
                buffer.append("]=");
                buffer.append(stackElements[j].getClassName());
                buffer.append(".");
                buffer.append(stackElements[j].getMethodName());
                buffer.append("(");
                buffer.append(stackElements[j].getFileName());
                buffer.append(":");
                if (stackElements[j].isNativeMethod()) {
                    buffer.append("native");
                } else {
                    buffer.append(stackElements[j].getLineNumber());
                }
                buffer.append(")");
                builder.add(AttributeValues.create(attrType, buffer.toString()));
            }
        }
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        attrs.add(builder.toAttribute());
        return attrs;
    }
}

