/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.api.DirectoryThread;
import org.opends.server.api.ServerShutdownListener;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.ldap.LDAPClientConnection;
import org.opends.server.protocols.ldap.LDAPConnectionHandler;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.InitializationException;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPRequestHandler
extends DirectoryThread
implements ServerShutdownListener {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    public static final int BUFFER_SIZE = 8192;
    private volatile boolean shutdownRequested;
    private volatile SelectionKey[] keys;
    private List<LDAPClientConnection> pendingConnections;
    private final Object pendingConnectionsLock;
    private final Selector selector;
    private final String handlerName;

    public LDAPRequestHandler(LDAPConnectionHandler connectionHandler, int requestHandlerID) throws InitializationException {
        block5: {
            super("LDAP Request Handler " + requestHandlerID + " for connection handler " + connectionHandler.toString());
            this.shutdownRequested = false;
            this.keys = new SelectionKey[0];
            this.pendingConnections = new LinkedList<LDAPClientConnection>();
            this.pendingConnectionsLock = new Object();
            this.handlerName = this.getName();
            try {
                this.selector = Selector.open();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ProtocolMessages.ERR_LDAP_REQHANDLER_OPEN_SELECTOR_FAILED.get(this.handlerName, String.valueOf(e));
                throw new InitializationException(message, (Throwable)e);
            }
            try {
                this.selector.selectNow();
            }
            catch (IOException ioe) {
                StackTraceElement ste;
                StackTraceElement[] stackElements = ioe.getStackTrace();
                if (stackElements == null || stackElements.length <= 0 || !(ste = stackElements[0]).getClassName().equals("sun.nio.ch.DevPollArrayWrapper") || ste.getMethodName().indexOf("poll") < 0 || !ioe.getMessage().equalsIgnoreCase("Invalid argument")) break block5;
                Message message = ProtocolMessages.ERR_LDAP_REQHANDLER_DETECTED_JVM_ISSUE_CR6322825.get(String.valueOf(ioe));
                throw new InitializationException(message, (Throwable)ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        SelectionKey[] keyArray;
        while (!this.shutdownRequested) {
            Object key;
            int selectedKeys;
            block42: {
                this.keys = this.selector.keys().toArray(new SelectionKey[0]);
                selectedKeys = 0;
                try {
                    selectedKeys = this.selector.select(1000L);
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block42;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            if (this.shutdownRequested) break;
            if (selectedKeys > 0) {
                Iterator<SelectionKey> iterator = this.selector.selectedKeys().iterator();
                while (iterator.hasNext()) {
                    key = iterator.next();
                    try {
                        if (((SelectionKey)key).isReadable()) {
                            LDAPClientConnection clientConnection = null;
                            try {
                                clientConnection = (LDAPClientConnection)((SelectionKey)key).attachment();
                                try {
                                    if (clientConnection.processDataRead()) continue;
                                    ((SelectionKey)key).cancel();
                                }
                                catch (Exception e) {
                                    if (DebugLogger.debugEnabled()) {
                                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                                    }
                                    ((SelectionKey)key).cancel();
                                    clientConnection.disconnect(DisconnectReason.SERVER_ERROR, false, null);
                                }
                            }
                            catch (Exception e) {
                                if (DebugLogger.debugEnabled()) {
                                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                                }
                                ((SelectionKey)key).cancel();
                                if (clientConnection == null) continue;
                                clientConnection.disconnect(DisconnectReason.SERVER_ERROR, false, null);
                            }
                            continue;
                        }
                        if (((SelectionKey)key).isValid()) continue;
                        ((SelectionKey)key).cancel();
                    }
                    catch (CancelledKeyException cke) {
                        if (!DebugLogger.debugEnabled()) continue;
                        TRACER.debugCaught(DebugLogLevel.ERROR, cke);
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        Message message = ProtocolMessages.ERR_LDAP_REQHANDLER_UNEXPECTED_SELECT_EXCEPTION.get(this.getName(), StaticUtils.getExceptionMessage(e));
                        ErrorLogger.logError(message);
                    }
                    finally {
                        if (!((SelectionKey)key).isValid()) {
                            ((SelectionKey)key).attach(null);
                        }
                        iterator.remove();
                    }
                }
            }
            List<LDAPClientConnection> tmp = null;
            key = this.pendingConnectionsLock;
            synchronized (key) {
                if (!this.pendingConnections.isEmpty()) {
                    tmp = this.pendingConnections;
                    this.pendingConnections = new LinkedList<LDAPClientConnection>();
                }
            }
            if (tmp == null) continue;
            for (LDAPClientConnection c : tmp) {
                try {
                    SocketChannel socketChannel = c.getSocketChannel();
                    socketChannel.configureBlocking(false);
                    socketChannel.register(this.selector, 1, c);
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    c.disconnect(DisconnectReason.SERVER_ERROR, true, ProtocolMessages.ERR_LDAP_REQHANDLER_CANNOT_REGISTER.get(this.handlerName, String.valueOf(e)));
                }
            }
        }
        for (SelectionKey key : keyArray = this.selector.keys().toArray(new SelectionKey[0])) {
            LDAPClientConnection c;
            block44: {
                block43: {
                    c = (LDAPClientConnection)key.attachment();
                    try {
                        key.channel().close();
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) break block43;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
                try {
                    key.cancel();
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block44;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            try {
                c.disconnect(DisconnectReason.SERVER_SHUTDOWN, true, ProtocolMessages.ERR_LDAP_REQHANDLER_DEREGISTER_DUE_TO_SHUTDOWN.get());
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        Object object = this.pendingConnectionsLock;
        synchronized (object) {
            for (LDAPClientConnection c : this.pendingConnections) {
                try {
                    c.disconnect(DisconnectReason.SERVER_SHUTDOWN, true, ProtocolMessages.ERR_LDAP_REQHANDLER_DEREGISTER_DUE_TO_SHUTDOWN.get());
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerClient(LDAPClientConnection clientConnection) {
        if (this.shutdownRequested) {
            clientConnection.disconnect(DisconnectReason.SERVER_SHUTDOWN, true, ProtocolMessages.ERR_LDAP_REQHANDLER_REJECT_DUE_TO_SHUTDOWN.get());
            return false;
        }
        Object object = this.pendingConnectionsLock;
        synchronized (object) {
            this.pendingConnections.add(clientConnection);
        }
        this.selector.wakeup();
        return true;
    }

    public Collection<LDAPClientConnection> getClientConnections() {
        ArrayList<LDAPClientConnection> connList = new ArrayList<LDAPClientConnection>(this.keys.length);
        for (SelectionKey key : this.keys) {
            LDAPClientConnection c = (LDAPClientConnection)key.attachment();
            if (c == null) continue;
            connList.add(c);
        }
        return connList;
    }

    @Override
    public String getShutdownListenerName() {
        return this.handlerName;
    }

    public void registerShutdownListener() {
        DirectoryServer.registerShutdownListener(this);
    }

    @Override
    public void processServerShutdown(Message reason) {
        this.shutdownRequested = true;
        this.selector.wakeup();
    }
}

