/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import org.opends.messages.CoreMessages;
import org.opends.messages.Message;

public class LDAPResultCode {
    public static final int SUCCESS = 0;
    public static final int OPERATIONS_ERROR = 1;
    public static final int PROTOCOL_ERROR = 2;
    public static final int TIME_LIMIT_EXCEEDED = 3;
    public static final int SIZE_LIMIT_EXCEEDED = 4;
    public static final int COMPARE_FALSE = 5;
    public static final int COMPARE_TRUE = 6;
    public static final int AUTH_METHOD_NOT_SUPPORTED = 7;
    public static final int STRONG_AUTH_REQUIRED = 8;
    public static final int REFERRAL = 10;
    public static final int ADMIN_LIMIT_EXCEEDED = 11;
    public static final int UNAVAILABLE_CRITICAL_EXTENSION = 12;
    public static final int CONFIDENTIALITY_REQUIRED = 13;
    public static final int SASL_BIND_IN_PROGRESS = 14;
    public static final int NO_SUCH_ATTRIBUTE = 16;
    public static final int UNDEFINED_ATTRIBUTE_TYPE = 17;
    public static final int INAPPROPRIATE_MATCHING = 18;
    public static final int CONSTRAINT_VIOLATION = 19;
    public static final int ATTRIBUTE_OR_VALUE_EXISTS = 20;
    public static final int INVALID_ATTRIBUTE_SYNTAX = 21;
    public static final int NO_SUCH_OBJECT = 32;
    public static final int ALIAS_PROBLEM = 33;
    public static final int INVALID_DN_SYNTAX = 34;
    public static final int ALIAS_DEREFERENCING_PROBLEM = 36;
    public static final int INAPPROPRIATE_AUTHENTICATION = 48;
    public static final int INVALID_CREDENTIALS = 49;
    public static final int INSUFFICIENT_ACCESS_RIGHTS = 50;
    public static final int BUSY = 51;
    public static final int UNAVAILABLE = 52;
    public static final int UNWILLING_TO_PERFORM = 53;
    public static final int LOOP_DETECT = 54;
    public static final int SORT_CONTROL_MISSING = 60;
    public static final int OFFSET_RANGE_ERROR = 61;
    public static final int NAMING_VIOLATION = 64;
    public static final int OBJECTCLASS_VIOLATION = 65;
    public static final int NOT_ALLOWED_ON_NONLEAF = 66;
    public static final int NOT_ALLOWED_ON_RDN = 67;
    public static final int ENTRY_ALREADY_EXISTS = 68;
    public static final int OBJECTCLASS_MODS_PROHIBITED = 69;
    public static final int AFFECTS_MULTIPLE_DSAS = 71;
    public static final int VIRTUAL_LIST_VIEW_ERROR = 76;
    public static final int OTHER = 80;
    public static final int CLIENT_SIDE_SERVER_DOWN = 81;
    public static final int CLIENT_SIDE_LOCAL_ERROR = 82;
    public static final int CLIENT_SIDE_ENCODING_ERROR = 83;
    public static final int CLIENT_SIDE_DECODING_ERROR = 84;
    public static final int CLIENT_SIDE_TIMEOUT = 85;
    public static final int CLIENT_SIDE_AUTH_UNKNOWN = 86;
    public static final int CLIENT_SIDE_FILTER_ERROR = 87;
    public static final int CLIENT_SIDE_USER_CANCELLED = 88;
    public static final int CLIENT_SIDE_PARAM_ERROR = 89;
    public static final int CLIENT_SIDE_NO_MEMORY = 90;
    public static final int CLIENT_SIDE_CONNECT_ERROR = 91;
    public static final int CLIENT_SIDE_NOT_SUPPORTED = 92;
    public static final int CLIENT_SIDE_CONTROL_NOT_FOUND = 93;
    public static final int CLIENT_SIDE_NO_RESULTS_RETURNED = 94;
    public static final int CLIENT_SIDE_MORE_RESULTS_TO_RETURN = 95;
    public static final int CLIENT_SIDE_CLIENT_LOOP = 96;
    public static final int CLIENT_SIDE_REFERRAL_LIMIT_EXCEEDED = 97;
    public static final int CANCELED = 118;
    public static final int NO_SUCH_OPERATION = 119;
    public static final int TOO_LATE = 120;
    public static final int CANNOT_CANCEL = 121;
    public static final int ASSERTION_FAILED = 122;
    public static final int AUTHORIZATION_DENIED = 123;
    public static final int NO_OPERATION = 16654;

    public static String toString(int resultCode) {
        Message message;
        switch (resultCode) {
            case 0: {
                message = CoreMessages.INFO_RESULT_SUCCESS.get();
                break;
            }
            case 1: {
                message = CoreMessages.INFO_RESULT_OPERATIONS_ERROR.get();
                break;
            }
            case 2: {
                message = CoreMessages.INFO_RESULT_PROTOCOL_ERROR.get();
                break;
            }
            case 3: {
                message = CoreMessages.INFO_RESULT_TIME_LIMIT_EXCEEDED.get();
                break;
            }
            case 4: {
                message = CoreMessages.INFO_RESULT_SIZE_LIMIT_EXCEEDED.get();
                break;
            }
            case 5: {
                message = CoreMessages.INFO_RESULT_COMPARE_FALSE.get();
                break;
            }
            case 6: {
                message = CoreMessages.INFO_RESULT_COMPARE_TRUE.get();
                break;
            }
            case 7: {
                message = CoreMessages.INFO_RESULT_AUTH_METHOD_NOT_SUPPORTED.get();
                break;
            }
            case 8: {
                message = CoreMessages.INFO_RESULT_STRONG_AUTH_REQUIRED.get();
                break;
            }
            case 10: {
                message = CoreMessages.INFO_RESULT_REFERRAL.get();
                break;
            }
            case 11: {
                message = CoreMessages.INFO_RESULT_ADMIN_LIMIT_EXCEEDED.get();
                break;
            }
            case 12: {
                message = CoreMessages.INFO_RESULT_UNAVAILABLE_CRITICAL_EXTENSION.get();
                break;
            }
            case 13: {
                message = CoreMessages.INFO_RESULT_CONFIDENTIALITY_REQUIRED.get();
                break;
            }
            case 14: {
                message = CoreMessages.INFO_RESULT_SASL_BIND_IN_PROGRESS.get();
                break;
            }
            case 16: {
                message = CoreMessages.INFO_RESULT_NO_SUCH_ATTRIBUTE.get();
                break;
            }
            case 17: {
                message = CoreMessages.INFO_RESULT_UNDEFINED_ATTRIBUTE_TYPE.get();
                break;
            }
            case 18: {
                message = CoreMessages.INFO_RESULT_INAPPROPRIATE_MATCHING.get();
                break;
            }
            case 19: {
                message = CoreMessages.INFO_RESULT_CONSTRAINT_VIOLATION.get();
                break;
            }
            case 20: {
                message = CoreMessages.INFO_RESULT_ATTRIBUTE_OR_VALUE_EXISTS.get();
                break;
            }
            case 21: {
                message = CoreMessages.INFO_RESULT_INVALID_ATTRIBUTE_SYNTAX.get();
                break;
            }
            case 32: {
                message = CoreMessages.INFO_RESULT_NO_SUCH_OBJECT.get();
                break;
            }
            case 33: {
                message = CoreMessages.INFO_RESULT_ALIAS_PROBLEM.get();
                break;
            }
            case 34: {
                message = CoreMessages.INFO_RESULT_INVALID_DN_SYNTAX.get();
                break;
            }
            case 36: {
                message = CoreMessages.INFO_RESULT_ALIAS_DEREFERENCING_PROBLEM.get();
                break;
            }
            case 48: {
                message = CoreMessages.INFO_RESULT_INAPPROPRIATE_AUTHENTICATION.get();
                break;
            }
            case 49: {
                message = CoreMessages.INFO_RESULT_INVALID_CREDENTIALS.get();
                break;
            }
            case 50: {
                message = CoreMessages.INFO_RESULT_INSUFFICIENT_ACCESS_RIGHTS.get();
                break;
            }
            case 51: {
                message = CoreMessages.INFO_RESULT_BUSY.get();
                break;
            }
            case 52: {
                message = CoreMessages.INFO_RESULT_UNAVAILABLE.get();
                break;
            }
            case 53: {
                message = CoreMessages.INFO_RESULT_UNWILLING_TO_PERFORM.get();
                break;
            }
            case 54: {
                message = CoreMessages.INFO_RESULT_LOOP_DETECT.get();
                break;
            }
            case 60: {
                message = CoreMessages.INFO_RESULT_SORT_CONTROL_MISSING.get();
                break;
            }
            case 61: {
                message = CoreMessages.INFO_RESULT_OFFSET_RANGE_ERROR.get();
                break;
            }
            case 64: {
                message = CoreMessages.INFO_RESULT_NAMING_VIOLATION.get();
                break;
            }
            case 65: {
                message = CoreMessages.INFO_RESULT_OBJECTCLASS_VIOLATION.get();
                break;
            }
            case 66: {
                message = CoreMessages.INFO_RESULT_NOT_ALLOWED_ON_NONLEAF.get();
                break;
            }
            case 67: {
                message = CoreMessages.INFO_RESULT_NOT_ALLOWED_ON_RDN.get();
                break;
            }
            case 68: {
                message = CoreMessages.INFO_RESULT_ENTRY_ALREADY_EXISTS.get();
                break;
            }
            case 69: {
                message = CoreMessages.INFO_RESULT_OBJECTCLASS_MODS_PROHIBITED.get();
                break;
            }
            case 71: {
                message = CoreMessages.INFO_RESULT_AFFECTS_MULTIPLE_DSAS.get();
                break;
            }
            case 76: {
                message = CoreMessages.INFO_RESULT_VIRTUAL_LIST_VIEW_ERROR.get();
                break;
            }
            case 81: {
                message = CoreMessages.INFO_RESULT_CLIENT_SIDE_SERVER_DOWN.get();
                break;
            }
            case 82: {
                message = CoreMessages.INFO_RESULT_CLIENT_SIDE_LOCAL_ERROR.get();
                break;
            }
            case 83: {
                message = CoreMessages.INFO_RESULT_CLIENT_SIDE_ENCODING_ERROR.get();
                break;
            }
            case 84: {
                message = CoreMessages.INFO_RESULT_CLIENT_SIDE_DECODING_ERROR.get();
                break;
            }
            case 85: {
                message = CoreMessages.INFO_RESULT_CLIENT_SIDE_TIMEOUT.get();
                break;
            }
            case 86: {
                message = CoreMessages.INFO_RESULT_CLIENT_SIDE_AUTH_UNKNOWN.get();
                break;
            }
            case 87: {
                message = CoreMessages.INFO_RESULT_CLIENT_SIDE_FILTER_ERROR.get();
                break;
            }
            case 88: {
                message = CoreMessages.INFO_RESULT_CLIENT_SIDE_USER_CANCELLED.get();
                break;
            }
            case 89: {
                message = CoreMessages.INFO_RESULT_CLIENT_SIDE_PARAM_ERROR.get();
                break;
            }
            case 90: {
                message = CoreMessages.INFO_RESULT_CLIENT_SIDE_NO_MEMORY.get();
                break;
            }
            case 91: {
                message = CoreMessages.INFO_RESULT_CLIENT_SIDE_CONNECT_ERROR.get();
                break;
            }
            case 92: {
                message = CoreMessages.INFO_RESULT_CLIENT_SIDE_NOT_SUPPORTED.get();
                break;
            }
            case 93: {
                message = CoreMessages.INFO_RESULT_CLIENT_SIDE_CONTROL_NOT_FOUND.get();
                break;
            }
            case 94: {
                message = CoreMessages.INFO_RESULT_CLIENT_SIDE_NO_RESULTS_RETURNED.get();
                break;
            }
            case 95: {
                message = CoreMessages.INFO_RESULT_CLIENT_SIDE_MORE_RESULTS_TO_RETURN.get();
                break;
            }
            case 96: {
                message = CoreMessages.INFO_RESULT_CLIENT_SIDE_CLIENT_LOOP.get();
                break;
            }
            case 97: {
                message = CoreMessages.INFO_RESULT_CLIENT_SIDE_REFERRAL_LIMIT_EXCEEDED.get();
                break;
            }
            case 118: {
                message = CoreMessages.INFO_RESULT_CANCELED.get();
                break;
            }
            case 119: {
                message = CoreMessages.INFO_RESULT_NO_SUCH_OPERATION.get();
                break;
            }
            case 120: {
                message = CoreMessages.INFO_RESULT_TOO_LATE.get();
                break;
            }
            case 121: {
                message = CoreMessages.INFO_RESULT_CANNOT_CANCEL.get();
                break;
            }
            case 122: {
                message = CoreMessages.INFO_RESULT_ASSERTION_FAILED.get();
                break;
            }
            case 123: {
                message = CoreMessages.INFO_RESULT_AUTHORIZATION_DENIED.get();
                break;
            }
            case 16654: {
                message = CoreMessages.INFO_RESULT_NO_OPERATION.get();
                break;
            }
            default: {
                message = CoreMessages.INFO_RESULT_OTHER.get();
            }
        }
        return message.toString();
    }
}

