/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.io.IOException;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.types.ByteString;
import org.opends.server.util.ServerConstants;

public class ModifyDNRequestProtocolOp
extends ProtocolOp {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ByteString entryDN;
    private ByteString newRDN;
    private ByteString newSuperior;
    private boolean deleteOldRDN;

    public ModifyDNRequestProtocolOp(ByteString entryDN, ByteString newRDN, boolean deleteOldRDN) {
        this.entryDN = entryDN;
        this.newRDN = newRDN;
        this.deleteOldRDN = deleteOldRDN;
        this.newSuperior = null;
    }

    public ModifyDNRequestProtocolOp(ByteString entryDN, ByteString newRDN, boolean deleteOldRDN, ByteString newSuperior) {
        this.entryDN = entryDN;
        this.newRDN = newRDN;
        this.deleteOldRDN = deleteOldRDN;
        this.newSuperior = newSuperior;
    }

    public ByteString getEntryDN() {
        return this.entryDN;
    }

    public ByteString getNewRDN() {
        return this.newRDN;
    }

    public boolean deleteOldRDN() {
        return this.deleteOldRDN;
    }

    public ByteString getNewSuperior() {
        return this.newSuperior;
    }

    public byte getType() {
        return 108;
    }

    public String getProtocolOpName() {
        return "Modify DN Request";
    }

    public void write(ASN1Writer stream) throws IOException {
        stream.writeStartSequence((byte)108);
        stream.writeOctetString(this.entryDN);
        stream.writeOctetString(this.newRDN);
        stream.writeBoolean(this.deleteOldRDN);
        if (this.newSuperior != null) {
            stream.writeOctetString((byte)-128, this.newSuperior);
        }
        stream.writeEndSequence();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("ModifyDNRequest(dn=");
        buffer.append(this.entryDN.toString());
        buffer.append(", newRDN=");
        buffer.append(this.newRDN.toString());
        buffer.append(", deleteOldRDN=");
        buffer.append(this.deleteOldRDN);
        if (this.newSuperior != null) {
            buffer.append(", newSuperior=");
            buffer.append(this.newSuperior.toString());
        }
        buffer.append(")");
    }

    public void toString(StringBuilder buffer, int indent) {
        StringBuilder indentBuf = new StringBuilder(indent);
        for (int i = 0; i < indent; ++i) {
            indentBuf.append(' ');
        }
        buffer.append((CharSequence)indentBuf);
        buffer.append("Modify DN Request");
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  Entry DN:  ");
        buffer.append(this.entryDN.toString());
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  New RDN:  ");
        buffer.append(this.newRDN.toString());
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  Delete Old RDN:  ");
        buffer.append(this.deleteOldRDN);
        buffer.append(ServerConstants.EOL);
        if (this.newSuperior != null) {
            buffer.append((CharSequence)indentBuf);
            buffer.append("  New Superior:  ");
            buffer.append(this.newSuperior.toString());
            buffer.append(ServerConstants.EOL);
        }
    }
}

