/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.types.ByteString;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.RawFilter;
import org.opends.server.types.SearchScope;
import org.opends.server.util.ServerConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchRequestProtocolOp
extends ProtocolOp {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private boolean typesOnly;
    private DereferencePolicy dereferencePolicy;
    private ByteString baseDN;
    private int sizeLimit;
    private int timeLimit;
    private RawFilter filter;
    private LinkedHashSet<String> attributes;
    private SearchScope scope;

    public SearchRequestProtocolOp(ByteString baseDN, SearchScope scope, DereferencePolicy dereferencePolicy, int sizeLimit, int timeLimit, boolean typesOnly, RawFilter filter, LinkedHashSet<String> attributes) {
        this.baseDN = baseDN;
        this.scope = scope;
        this.dereferencePolicy = dereferencePolicy;
        this.sizeLimit = sizeLimit;
        this.timeLimit = timeLimit;
        this.typesOnly = typesOnly;
        this.filter = filter;
        this.attributes = attributes == null ? new LinkedHashSet(0) : attributes;
    }

    public ByteString getBaseDN() {
        return this.baseDN;
    }

    public SearchScope getScope() {
        return this.scope;
    }

    public DereferencePolicy getDereferencePolicy() {
        return this.dereferencePolicy;
    }

    public int getSizeLimit() {
        return this.sizeLimit;
    }

    public int getTimeLimit() {
        return this.timeLimit;
    }

    public boolean getTypesOnly() {
        return this.typesOnly;
    }

    public RawFilter getFilter() {
        return this.filter;
    }

    public LinkedHashSet<String> getAttributes() {
        return this.attributes;
    }

    @Override
    public byte getType() {
        return 99;
    }

    @Override
    public String getProtocolOpName() {
        return "Search Request";
    }

    @Override
    public void write(ASN1Writer stream) throws IOException {
        stream.writeStartSequence((byte)99);
        stream.writeOctetString(this.baseDN);
        stream.writeEnumerated(this.scope.intValue());
        stream.writeEnumerated(this.dereferencePolicy.intValue());
        stream.writeInteger(this.sizeLimit);
        stream.writeInteger(this.timeLimit);
        stream.writeBoolean(this.typesOnly);
        this.filter.write(stream);
        stream.writeStartSequence();
        for (String attribute : this.attributes) {
            stream.writeOctetString(attribute);
        }
        stream.writeEndSequence();
        stream.writeEndSequence();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("SearchRequest(baseDN=");
        buffer.append(this.baseDN.toString());
        buffer.append(", scope=");
        buffer.append(String.valueOf((Object)this.scope));
        buffer.append(", derefPolicy=");
        buffer.append(String.valueOf((Object)this.dereferencePolicy));
        buffer.append(", sizeLimit=");
        buffer.append(this.sizeLimit);
        buffer.append(", timeLimit=");
        buffer.append(this.timeLimit);
        buffer.append(", typesOnly=");
        buffer.append(this.typesOnly);
        buffer.append(", filter=");
        this.filter.toString(buffer);
        buffer.append(", attributes={");
        if (this.attributes != null && !this.attributes.isEmpty()) {
            Iterator iterator = this.attributes.iterator();
            buffer.append((String)iterator.next());
            while (iterator.hasNext()) {
                buffer.append(", ");
                buffer.append((String)iterator.next());
            }
        }
        buffer.append("})");
    }

    @Override
    public void toString(StringBuilder buffer, int indent) {
        StringBuilder indentBuf = new StringBuilder(indent);
        for (int i = 0; i < indent; ++i) {
            indentBuf.append(' ');
        }
        buffer.append((CharSequence)indentBuf);
        buffer.append("Search Request");
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  Base DN:  ");
        buffer.append(this.baseDN.toString());
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  Scope:  ");
        buffer.append(String.valueOf((Object)this.scope));
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  Dereference Policy:  ");
        buffer.append(String.valueOf((Object)this.dereferencePolicy));
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  Size Limit:  ");
        buffer.append(this.sizeLimit);
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  Time Limit:  ");
        buffer.append(this.timeLimit);
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  Types Only:  ");
        buffer.append(this.typesOnly);
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  Filter:  ");
        this.filter.toString(buffer);
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  Attributes:");
        buffer.append(ServerConstants.EOL);
        if (this.attributes != null) {
            for (String attribute : this.attributes) {
                buffer.append((CharSequence)indentBuf);
                buffer.append("    ");
                buffer.append(attribute);
                buffer.append(ServerConstants.EOL);
            }
        }
    }
}

