/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.opends.server.core.DirectoryServer;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.LDAPException;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.util.Base64;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchResultEntryProtocolOp
extends ProtocolOp {
    private LinkedList<LDAPAttribute> attributes;
    private final DN dn;
    private SearchResultEntry entry;
    private final int ldapVersion;

    public SearchResultEntryProtocolOp(DN dn) {
        this(dn, null, null, 3);
    }

    public SearchResultEntryProtocolOp(DN dn, LinkedList<LDAPAttribute> attributes) {
        this(dn, attributes, null, 3);
    }

    public SearchResultEntryProtocolOp(SearchResultEntry searchEntry) {
        this(searchEntry.getDN(), null, searchEntry, 3);
    }

    public SearchResultEntryProtocolOp(SearchResultEntry searchEntry, int ldapVersion) {
        this(searchEntry.getDN(), null, searchEntry, ldapVersion);
    }

    private SearchResultEntryProtocolOp(DN dn, LinkedList<LDAPAttribute> attributes, SearchResultEntry searchEntry, int ldapVersion) {
        this.dn = dn;
        this.attributes = attributes;
        this.entry = searchEntry;
        this.ldapVersion = ldapVersion;
    }

    public DN getDN() {
        return this.dn;
    }

    public LinkedList<LDAPAttribute> getAttributes() {
        LinkedList<LDAPAttribute> tmp = this.attributes;
        if (tmp == null) {
            tmp = new LinkedList();
            if (this.entry != null) {
                if (this.ldapVersion == 2) {
                    AttributeBuilder builder;
                    Attribute a;
                    boolean needsMerge;
                    Map<AttributeType, List<Attribute>> attrs = this.entry.getUserAttributes();
                    for (Map.Entry<AttributeType, List<Attribute>> attrList : attrs.entrySet()) {
                        needsMerge = true;
                        if (attrList != null && attrList.getValue().size() == 1 && !(a = attrList.getValue().get(0)).hasOptions()) {
                            needsMerge = false;
                            tmp.add(new LDAPAttribute(a));
                        }
                        if (!needsMerge) continue;
                        builder = new AttributeBuilder(attrList.getKey());
                        for (Attribute a2 : attrList.getValue()) {
                            builder.addAll(a2);
                        }
                        tmp.add(new LDAPAttribute(builder.toAttribute()));
                    }
                    attrs = this.entry.getOperationalAttributes();
                    for (Map.Entry<AttributeType, List<Attribute>> attrList : attrs.entrySet()) {
                        needsMerge = true;
                        if (attrList != null && attrList.getValue().size() == 1 && !(a = attrList.getValue().get(0)).hasOptions()) {
                            needsMerge = false;
                            tmp.add(new LDAPAttribute(a));
                        }
                        if (!needsMerge) continue;
                        builder = new AttributeBuilder(attrList.getKey());
                        for (Attribute a2 : attrList.getValue()) {
                            builder.addAll(a2);
                        }
                        tmp.add(new LDAPAttribute(builder.toAttribute()));
                    }
                } else {
                    for (List<Attribute> attrList : this.entry.getUserAttributes().values()) {
                        for (Attribute a : attrList) {
                            tmp.add(new LDAPAttribute(a));
                        }
                    }
                    for (List<Attribute> attrList : this.entry.getOperationalAttributes().values()) {
                        for (Attribute a : attrList) {
                            tmp.add(new LDAPAttribute(a));
                        }
                    }
                }
            }
            this.attributes = tmp;
            this.entry = null;
        }
        return this.attributes;
    }

    @Override
    public byte getType() {
        return 100;
    }

    @Override
    public String getProtocolOpName() {
        return "Search Result Entry";
    }

    @Override
    public void write(ASN1Writer stream) throws IOException {
        stream.writeStartSequence((byte)100);
        stream.writeOctetString(this.dn.toString());
        stream.writeStartSequence();
        SearchResultEntry tmp = this.entry;
        if (this.ldapVersion == 3 && tmp != null) {
            for (List<Attribute> attrList : tmp.getUserAttributes().values()) {
                for (Attribute a : attrList) {
                    this.writeAttribute(stream, a);
                }
            }
            for (List<Attribute> attrList : tmp.getOperationalAttributes().values()) {
                for (Attribute a : attrList) {
                    this.writeAttribute(stream, a);
                }
            }
        } else {
            for (LDAPAttribute attr : this.getAttributes()) {
                attr.write(stream);
            }
        }
        stream.writeEndSequence();
        stream.writeEndSequence();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("SearchResultEntry(dn=");
        this.dn.toString(buffer);
        buffer.append(", attrs={");
        LinkedList<LDAPAttribute> tmp = this.getAttributes();
        if (!tmp.isEmpty()) {
            Iterator iterator = tmp.iterator();
            ((LDAPAttribute)iterator.next()).toString(buffer);
            while (iterator.hasNext()) {
                buffer.append(", ");
                ((LDAPAttribute)iterator.next()).toString(buffer);
            }
        }
        buffer.append("})");
    }

    @Override
    public void toString(StringBuilder buffer, int indent) {
        StringBuilder indentBuf = new StringBuilder(indent);
        for (int i = 0; i < indent; ++i) {
            indentBuf.append(' ');
        }
        buffer.append((CharSequence)indentBuf);
        buffer.append("Search Result Entry");
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  DN:  ");
        this.dn.toString(buffer);
        buffer.append(ServerConstants.EOL);
        buffer.append("  Attributes:");
        buffer.append(ServerConstants.EOL);
        for (LDAPAttribute attribute : this.getAttributes()) {
            attribute.toString(buffer, indent + 4);
        }
    }

    public void toLDIF(StringBuilder buffer, int wrapColumn) {
        int colsRemaining;
        String dnString = this.dn.toString();
        if (StaticUtils.needsBase64Encoding(dnString)) {
            dnString = Base64.encode(StaticUtils.getBytes(dnString));
            buffer.append("dn:: ");
            colsRemaining = wrapColumn - 5;
        } else {
            buffer.append("dn: ");
            colsRemaining = wrapColumn - 4;
        }
        int dnLength = dnString.length();
        if (dnLength <= colsRemaining || colsRemaining <= 0) {
            buffer.append(dnString);
            buffer.append(ServerConstants.EOL);
        } else {
            buffer.append(dnString.substring(0, colsRemaining));
            buffer.append(ServerConstants.EOL);
            int startPos = colsRemaining;
            while (dnLength - startPos > wrapColumn - 1) {
                buffer.append(" ");
                buffer.append(dnString.substring(startPos, startPos + wrapColumn - 1));
                buffer.append(ServerConstants.EOL);
                startPos += wrapColumn - 1;
            }
            if (startPos < dnLength) {
                buffer.append(" ");
                buffer.append(dnString.substring(startPos));
                buffer.append(ServerConstants.EOL);
            }
        }
        for (LDAPAttribute a : this.getAttributes()) {
            String name = a.getAttributeType();
            int nameLength = name.length();
            for (ByteString v : a.getValues()) {
                String valueString;
                if (StaticUtils.needsBase64Encoding(v)) {
                    valueString = Base64.encode(v);
                    buffer.append(name);
                    buffer.append(":: ");
                    colsRemaining = wrapColumn - nameLength - 3;
                } else {
                    valueString = v.toString();
                    buffer.append(name);
                    buffer.append(": ");
                    colsRemaining = wrapColumn - nameLength - 2;
                }
                int valueLength = valueString.length();
                if (valueLength <= colsRemaining || colsRemaining <= 0) {
                    buffer.append(valueString);
                    buffer.append(ServerConstants.EOL);
                    continue;
                }
                buffer.append(valueString.substring(0, colsRemaining));
                buffer.append(ServerConstants.EOL);
                int startPos = colsRemaining;
                while (valueLength - startPos > wrapColumn - 1) {
                    buffer.append(" ");
                    buffer.append(valueString.substring(startPos, startPos + wrapColumn - 1));
                    buffer.append(ServerConstants.EOL);
                    startPos += wrapColumn - 1;
                }
                if (startPos >= valueLength) continue;
                buffer.append(" ");
                buffer.append(valueString.substring(startPos));
                buffer.append(ServerConstants.EOL);
            }
        }
        buffer.append(ServerConstants.EOL);
    }

    public SearchResultEntry toSearchResultEntry() throws LDAPException {
        if (this.entry != null) {
            return this.entry;
        }
        HashMap<ObjectClass, String> objectClasses = new HashMap<ObjectClass, String>();
        HashMap<AttributeType, List<Attribute>> userAttributes = new HashMap<AttributeType, List<Attribute>>();
        HashMap<AttributeType, List<Attribute>> operationalAttributes = new HashMap<AttributeType, List<Attribute>>();
        for (LDAPAttribute a : this.getAttributes()) {
            List<Attribute> attrs;
            Attribute attr = a.toAttribute();
            AttributeType attrType = attr.getAttributeType();
            if (attrType.isObjectClassType()) {
                for (ByteString os : a.getValues()) {
                    String ocName = os.toString();
                    ObjectClass oc = DirectoryServer.getObjectClass(StaticUtils.toLowerCase(ocName));
                    if (oc == null) {
                        oc = DirectoryServer.getDefaultObjectClass(ocName);
                    }
                    objectClasses.put(oc, ocName);
                }
                continue;
            }
            if (attrType.isOperational()) {
                attrs = operationalAttributes.get(attrType);
                if (attrs == null) {
                    attrs = new ArrayList<Attribute>(1);
                    attrs.add(attr);
                    operationalAttributes.put(attrType, attrs);
                    continue;
                }
                attrs.add(attr);
                continue;
            }
            attrs = userAttributes.get(attrType);
            if (attrs == null) {
                attrs = new ArrayList<Attribute>(1);
                attrs.add(attr);
                userAttributes.put(attrType, attrs);
                continue;
            }
            boolean attributeSeen = false;
            for (int i = 0; i < attrs.size(); ++i) {
                Attribute ea = attrs.get(i);
                if (!ea.optionsEqual(attr.getOptions())) continue;
                AttributeBuilder builder = new AttributeBuilder(ea);
                builder.addAll(attr);
                attrs.set(i, builder.toAttribute());
                attributeSeen = true;
            }
            if (attributeSeen) continue;
            attrs.add(attr);
        }
        Entry entry = new Entry(this.dn, objectClasses, userAttributes, operationalAttributes);
        return new SearchResultEntry(entry);
    }

    private void writeAttribute(ASN1Writer stream, Attribute a) throws IOException {
        stream.writeStartSequence();
        stream.writeOctetString(a.getNameWithOptions());
        stream.writeStartSet();
        for (AttributeValue value : a) {
            stream.writeOctetString(value.getValue());
        }
        stream.writeEndSequence();
        stream.writeEndSequence();
    }
}

