/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.common;

import org.opends.server.replication.common.ServerStatus;
import org.opends.server.replication.common.StatusMachineEvent;

public class StatusMachine {
    public static boolean isValidInitialStatus(ServerStatus initStatus) {
        switch (initStatus) {
            case NORMAL_STATUS: 
            case DEGRADED_STATUS: 
            case BAD_GEN_ID_STATUS: {
                return true;
            }
        }
        return false;
    }

    public static ServerStatus computeNewStatus(ServerStatus curStatus, StatusMachineEvent event) {
        switch (curStatus) {
            case NOT_CONNECTED_STATUS: {
                switch (event) {
                    case TO_NOT_CONNECTED_STATUS_EVENT: {
                        return ServerStatus.NOT_CONNECTED_STATUS;
                    }
                    case TO_NORMAL_STATUS_EVENT: {
                        return ServerStatus.NORMAL_STATUS;
                    }
                    case TO_DEGRADED_STATUS_EVENT: {
                        return ServerStatus.DEGRADED_STATUS;
                    }
                    case TO_BAD_GEN_ID_STATUS_EVENT: {
                        return ServerStatus.BAD_GEN_ID_STATUS;
                    }
                }
                return ServerStatus.INVALID_STATUS;
            }
            case NORMAL_STATUS: {
                switch (event) {
                    case TO_NOT_CONNECTED_STATUS_EVENT: {
                        return ServerStatus.NOT_CONNECTED_STATUS;
                    }
                    case TO_NORMAL_STATUS_EVENT: {
                        return ServerStatus.NORMAL_STATUS;
                    }
                    case TO_DEGRADED_STATUS_EVENT: {
                        return ServerStatus.DEGRADED_STATUS;
                    }
                    case TO_FULL_UPDATE_STATUS_EVENT: {
                        return ServerStatus.FULL_UPDATE_STATUS;
                    }
                    case TO_BAD_GEN_ID_STATUS_EVENT: {
                        return ServerStatus.BAD_GEN_ID_STATUS;
                    }
                }
                return ServerStatus.INVALID_STATUS;
            }
            case DEGRADED_STATUS: {
                switch (event) {
                    case TO_NOT_CONNECTED_STATUS_EVENT: {
                        return ServerStatus.NOT_CONNECTED_STATUS;
                    }
                    case TO_NORMAL_STATUS_EVENT: {
                        return ServerStatus.NORMAL_STATUS;
                    }
                    case TO_DEGRADED_STATUS_EVENT: {
                        return ServerStatus.DEGRADED_STATUS;
                    }
                    case TO_FULL_UPDATE_STATUS_EVENT: {
                        return ServerStatus.FULL_UPDATE_STATUS;
                    }
                    case TO_BAD_GEN_ID_STATUS_EVENT: {
                        return ServerStatus.BAD_GEN_ID_STATUS;
                    }
                }
                return ServerStatus.INVALID_STATUS;
            }
            case FULL_UPDATE_STATUS: {
                switch (event) {
                    case TO_NOT_CONNECTED_STATUS_EVENT: {
                        return ServerStatus.NOT_CONNECTED_STATUS;
                    }
                    case TO_FULL_UPDATE_STATUS_EVENT: {
                        return ServerStatus.FULL_UPDATE_STATUS;
                    }
                }
                return ServerStatus.INVALID_STATUS;
            }
            case BAD_GEN_ID_STATUS: {
                switch (event) {
                    case TO_NOT_CONNECTED_STATUS_EVENT: {
                        return ServerStatus.NOT_CONNECTED_STATUS;
                    }
                    case TO_FULL_UPDATE_STATUS_EVENT: {
                        return ServerStatus.FULL_UPDATE_STATUS;
                    }
                    case TO_BAD_GEN_ID_STATUS_EVENT: {
                        return ServerStatus.BAD_GEN_ID_STATUS;
                    }
                }
                return ServerStatus.INVALID_STATUS;
            }
        }
        return ServerStatus.INVALID_STATUS;
    }
}

