/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.common;

import org.opends.server.replication.common.ServerStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum StatusMachineEvent {
    INVALID_EVENT(-1),
    TO_NOT_CONNECTED_STATUS_EVENT(0),
    TO_NORMAL_STATUS_EVENT(1),
    TO_DEGRADED_STATUS_EVENT(2),
    TO_FULL_UPDATE_STATUS_EVENT(3),
    TO_BAD_GEN_ID_STATUS_EVENT(4);

    private byte value = (byte)-1;

    private StatusMachineEvent(byte value) {
        this.value = value;
    }

    public static StatusMachineEvent valueOf(byte value) throws IllegalArgumentException {
        switch (value) {
            case 0: {
                return TO_NOT_CONNECTED_STATUS_EVENT;
            }
            case 1: {
                return TO_NORMAL_STATUS_EVENT;
            }
            case 2: {
                return TO_DEGRADED_STATUS_EVENT;
            }
            case 3: {
                return TO_FULL_UPDATE_STATUS_EVENT;
            }
            case 4: {
                return TO_BAD_GEN_ID_STATUS_EVENT;
            }
        }
        throw new IllegalArgumentException("Wrong event numeric value: " + value);
    }

    public static StatusMachineEvent statusToEvent(ServerStatus reqStatus) {
        switch (reqStatus) {
            case NOT_CONNECTED_STATUS: {
                return TO_NOT_CONNECTED_STATUS_EVENT;
            }
            case NORMAL_STATUS: {
                return TO_NORMAL_STATUS_EVENT;
            }
            case DEGRADED_STATUS: {
                return TO_DEGRADED_STATUS_EVENT;
            }
            case FULL_UPDATE_STATUS: {
                return TO_FULL_UPDATE_STATUS_EVENT;
            }
            case BAD_GEN_ID_STATUS: {
                return TO_BAD_GEN_ID_STATUS_EVENT;
            }
        }
        return INVALID_EVENT;
    }

    public byte getValue() {
        return this.value;
    }
}

