/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.IOException;
import org.opends.messages.ReplicationMessages;
import org.opends.server.api.DirectoryThread;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.protocol.ProtocolSession;
import org.opends.server.util.StaticUtils;

public class HeartbeatMonitor
extends DirectoryThread {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ProtocolSession session;
    private long heartbeatInterval;
    private boolean shutdown = false;

    public HeartbeatMonitor(String threadName, ProtocolSession session, long heartbeatInterval) {
        super(threadName);
        this.session = session;
        this.heartbeatInterval = heartbeatInterval;
    }

    public void shutdown() {
        this.shutdown = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block14: {
            boolean gotOneFailure = false;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Heartbeat monitor is starting, expected interval is " + this.heartbeatInterval + StaticUtils.stackTraceToSingleLineString(new Exception()));
            }
            block7: while (true) {
                try {
                    while (!this.shutdown) {
                        long lastReceiveTime;
                        long now = System.currentTimeMillis();
                        if (now > (lastReceiveTime = this.session.getLastReceiveTime()) + this.heartbeatInterval) {
                            if (gotOneFailure) {
                                ErrorLogger.logError(ReplicationMessages.NOTE_HEARTBEAT_FAILURE.get(HeartbeatMonitor.currentThread().getName()));
                                this.session.close();
                                break block14;
                            }
                            gotOneFailure = true;
                        } else {
                            gotOneFailure = false;
                        }
                        try {
                            Thread.sleep(this.heartbeatInterval);
                            continue block7;
                        }
                        catch (InterruptedException e) {
                        }
                    }
                    break block14;
                }
                catch (IOException iOException) {
                    break block14;
                }
            }
            finally {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("Heartbeat monitor is exiting." + StaticUtils.stackTraceToSingleLineString(new Exception()));
                }
            }
        }
    }
}

