/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.replication.common.AssuredMode;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.protocol.AddMsg;
import org.opends.server.replication.protocol.DeleteMsg;
import org.opends.server.replication.protocol.ModifyDNMsg;
import org.opends.server.replication.protocol.ModifyMsg;
import org.opends.server.replication.protocol.OperationContext;
import org.opends.server.replication.protocol.ProtocolVersion;
import org.opends.server.replication.protocol.UpdateMsg;
import org.opends.server.types.AbstractOperation;
import org.opends.server.types.LDAPException;
import org.opends.server.types.operation.PostOperationAddOperation;
import org.opends.server.types.operation.PostOperationDeleteOperation;
import org.opends.server.types.operation.PostOperationModifyDNOperation;
import org.opends.server.types.operation.PostOperationModifyOperation;
import org.opends.server.types.operation.PostOperationOperation;

public abstract class LDAPUpdateMsg
extends UpdateMsg {
    protected String dn = null;
    protected String uniqueId;
    protected byte[] bytes = null;

    public LDAPUpdateMsg() {
    }

    public LDAPUpdateMsg(OperationContext ctx, String dn) {
        this.protocolVersion = ProtocolVersion.getCurrentVersion();
        this.changeNumber = ctx.getChangeNumber();
        this.uniqueId = ctx.getEntryUid();
        this.dn = dn;
    }

    public LDAPUpdateMsg(ChangeNumber cn, String entryUUID, String dn) {
        this.protocolVersion = ProtocolVersion.getCurrentVersion();
        this.changeNumber = cn;
        this.uniqueId = entryUUID;
        this.dn = dn;
    }

    public static LDAPUpdateMsg generateMsg(PostOperationOperation op) {
        LDAPUpdateMsg msg = null;
        switch (op.getOperationType()) {
            case MODIFY: {
                msg = new ModifyMsg((PostOperationModifyOperation)op);
                break;
            }
            case ADD: {
                msg = new AddMsg((PostOperationAddOperation)op);
                break;
            }
            case DELETE: {
                msg = new DeleteMsg((PostOperationDeleteOperation)op);
                break;
            }
            case MODIFY_DN: {
                msg = new ModifyDNMsg((PostOperationModifyDNOperation)op);
            }
        }
        return msg;
    }

    public String getDn() {
        return this.dn;
    }

    public void setDn(String dn) {
        this.dn = dn;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public void encode() throws UnsupportedEncodingException {
        this.bytes = this.getBytes();
    }

    public AbstractOperation createOperation(InternalClientConnection conn) throws LDAPException, ASN1Exception, DataFormatException {
        return this.createOperation(conn, this.dn);
    }

    public abstract AbstractOperation createOperation(InternalClientConnection var1, String var2) throws LDAPException, ASN1Exception, DataFormatException;

    public byte[] encodeHeader(byte type, int additionalLength) throws UnsupportedEncodingException {
        byte[] byteDn = this.dn.getBytes("UTF-8");
        byte[] changeNumberByte = this.getChangeNumber().toString().getBytes("UTF-8");
        byte[] byteEntryuuid = this.getUniqueId().getBytes("UTF-8");
        int length = 8 + changeNumberByte.length + byteDn.length + byteEntryuuid.length + additionalLength;
        byte[] encodedMsg = new byte[length];
        encodedMsg[0] = type;
        encodedMsg[1] = (byte)ProtocolVersion.getCurrentVersion();
        int pos = 2;
        pos = LDAPUpdateMsg.addByteArray(changeNumberByte, encodedMsg, pos);
        pos = LDAPUpdateMsg.addByteArray(byteDn, encodedMsg, pos);
        pos = LDAPUpdateMsg.addByteArray(byteEntryuuid, encodedMsg, pos);
        encodedMsg[pos++] = this.assuredFlag ? (byte)1 : 0;
        encodedMsg[pos++] = this.assuredMode.getValue();
        encodedMsg[pos++] = this.safeDataLevel;
        return encodedMsg;
    }

    public byte[] getBytes(short reqProtocolVersion) throws UnsupportedEncodingException {
        if (reqProtocolVersion == ProtocolVersion.getCurrentVersion()) {
            return this.getBytes();
        }
        switch (reqProtocolVersion) {
            case 1: {
                return this.getBytes_V1();
            }
        }
        throw new UnsupportedEncodingException(this.getClass().getSimpleName() + " PDU does not support requested protocol version serialization: " + reqProtocolVersion);
    }

    public abstract byte[] getBytes_V1() throws UnsupportedEncodingException;

    public byte[] encodeHeader_V1(byte type, int additionalLength) throws UnsupportedEncodingException {
        byte[] byteDn = this.dn.getBytes("UTF-8");
        byte[] changeNumberByte = this.getChangeNumber().toString().getBytes("UTF-8");
        byte[] byteEntryuuid = this.getUniqueId().getBytes("UTF-8");
        int length = 5 + changeNumberByte.length + byteDn.length + byteEntryuuid.length + additionalLength;
        byte[] encodedMsg = new byte[length];
        encodedMsg[0] = type;
        int pos = 1;
        pos = LDAPUpdateMsg.addByteArray(changeNumberByte, encodedMsg, pos);
        encodedMsg[pos++] = this.assuredFlag ? (byte)1 : 0;
        pos = LDAPUpdateMsg.addByteArray(byteDn, encodedMsg, pos);
        pos = LDAPUpdateMsg.addByteArray(byteEntryuuid, encodedMsg, pos);
        return encodedMsg;
    }

    public int decodeHeader(byte[] types, byte[] encodedMsg) throws DataFormatException {
        boolean foundMatchingType = false;
        for (int i = 0; i < types.length; ++i) {
            if (types[i] != encodedMsg[0]) continue;
            foundMatchingType = true;
            break;
        }
        if (!foundMatchingType) {
            throw new DataFormatException("byte[] is not a valid update msg: " + encodedMsg[0]);
        }
        if (encodedMsg[0] == 2 || encodedMsg[0] == 3 || encodedMsg[0] == 4 || encodedMsg[0] == 1) {
            return this.decodeHeader_V1(encodedMsg);
        }
        this.protocolVersion = encodedMsg[1];
        try {
            int pos = 2;
            int length = this.getNextLength(encodedMsg, pos);
            String changenumberStr = new String(encodedMsg, pos, length, "UTF-8");
            pos += length + 1;
            this.changeNumber = new ChangeNumber(changenumberStr);
            length = this.getNextLength(encodedMsg, pos);
            this.dn = new String(encodedMsg, pos, length, "UTF-8");
            pos += length + 1;
            length = this.getNextLength(encodedMsg, pos);
            this.uniqueId = new String(encodedMsg, pos, length, "UTF-8");
            pos += length + 1;
            this.assuredFlag = encodedMsg[pos++] == 1;
            this.assuredMode = AssuredMode.valueOf(encodedMsg[pos++]);
            this.safeDataLevel = encodedMsg[pos++];
            return pos;
        }
        catch (UnsupportedEncodingException e) {
            throw new DataFormatException("UTF-8 is not supported by this jvm.");
        }
        catch (IllegalArgumentException e) {
            throw new DataFormatException(e.getMessage());
        }
    }

    public int decodeHeader_V1(byte[] encodedMsg) throws DataFormatException {
        if (encodedMsg[0] != 2 && encodedMsg[0] != 3 && encodedMsg[0] != 4 && encodedMsg[0] != 1) {
            throw new DataFormatException("byte[] is not a valid update msg: expected a V1 PDU, received: " + encodedMsg[0]);
        }
        this.protocolVersion = 1;
        try {
            int pos = 1;
            int length = this.getNextLength(encodedMsg, pos);
            String changenumberStr = new String(encodedMsg, pos, length, "UTF-8");
            pos += length + 1;
            this.changeNumber = new ChangeNumber(changenumberStr);
            this.assuredFlag = encodedMsg[pos++] == 1;
            length = this.getNextLength(encodedMsg, pos);
            this.dn = new String(encodedMsg, pos, length, "UTF-8");
            pos += length + 1;
            length = this.getNextLength(encodedMsg, pos);
            this.uniqueId = new String(encodedMsg, pos, length, "UTF-8");
            return pos += length + 1;
        }
        catch (UnsupportedEncodingException e) {
            throw new DataFormatException("UTF-8 is not supported by this jvm.");
        }
    }

    public abstract int size();
}

