/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import org.opends.server.replication.common.AssuredMode;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.protocol.ProtocolVersion;
import org.opends.server.replication.protocol.ReplicationMsg;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateMsg
extends ReplicationMsg
implements Comparable<UpdateMsg> {
    protected short protocolVersion;
    protected ChangeNumber changeNumber;
    protected boolean assuredFlag = false;
    protected AssuredMode assuredMode = AssuredMode.SAFE_DATA_MODE;
    protected byte safeDataLevel = 1;
    private byte[] payload;

    protected UpdateMsg() {
    }

    UpdateMsg(byte[] bytes) throws DataFormatException {
        int pos = this.decodeHeader((byte)29, bytes);
        int length = bytes.length - pos;
        this.payload = new byte[length];
        try {
            System.arraycopy(bytes, pos, this.payload, 0, length);
        }
        catch (IndexOutOfBoundsException e) {
            throw new DataFormatException(e.getMessage());
        }
        catch (ArrayStoreException e) {
            throw new DataFormatException(e.getMessage());
        }
        catch (NullPointerException e) {
            throw new DataFormatException(e.getMessage());
        }
    }

    public UpdateMsg(ChangeNumber changeNumber, byte[] payload) {
        this.payload = payload;
        this.protocolVersion = ProtocolVersion.getCurrentVersion();
        this.changeNumber = changeNumber;
    }

    public ChangeNumber getChangeNumber() {
        return this.changeNumber;
    }

    public boolean isAssured() {
        return this.assuredFlag;
    }

    public void setAssured(boolean assured) {
        this.assuredFlag = assured;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            return this.changeNumber.equals(((UpdateMsg)obj).changeNumber);
        }
        return false;
    }

    public int hashCode() {
        return this.changeNumber.hashCode();
    }

    @Override
    public int compareTo(UpdateMsg msg) {
        return this.changeNumber.compareTo(msg.getChangeNumber());
    }

    @Override
    public byte[] getBytes(short reqProtocolVersion) throws UnsupportedEncodingException {
        if (reqProtocolVersion == ProtocolVersion.getCurrentVersion()) {
            return this.getBytes();
        }
        throw new UnsupportedEncodingException(this.getClass().getSimpleName() + " PDU does not support requested protocol version serialization: " + reqProtocolVersion);
    }

    public AssuredMode getAssuredMode() {
        return this.assuredMode;
    }

    public byte getSafeDataLevel() {
        return this.safeDataLevel;
    }

    public void setAssuredMode(AssuredMode assuredMode) {
        this.assuredMode = assuredMode;
    }

    public void setSafeDataLevel(byte safeDataLevel) {
        this.safeDataLevel = safeDataLevel;
    }

    public short getVersion() {
        return this.protocolVersion;
    }

    public int size() {
        return 10 + this.payload.length;
    }

    protected byte[] encodeHeader(byte type, int additionalLength) throws UnsupportedEncodingException {
        byte[] changeNumberByte = this.getChangeNumber().toString().getBytes("UTF-8");
        int length = 6 + changeNumberByte.length + additionalLength;
        byte[] encodedMsg = new byte[length];
        encodedMsg[0] = type;
        encodedMsg[1] = (byte)ProtocolVersion.getCurrentVersion();
        int pos = 2;
        pos = UpdateMsg.addByteArray(changeNumberByte, encodedMsg, pos);
        encodedMsg[pos++] = this.assuredFlag ? (byte)1 : 0;
        encodedMsg[pos++] = this.assuredMode.getValue();
        encodedMsg[pos++] = this.safeDataLevel;
        return encodedMsg;
    }

    protected int decodeHeader(byte type, byte[] encodedMsg) throws DataFormatException {
        if (type != encodedMsg[0]) {
            throw new DataFormatException("byte[] is not a valid update msg: " + encodedMsg[0]);
        }
        this.protocolVersion = encodedMsg[1];
        try {
            int pos = 2;
            int length = this.getNextLength(encodedMsg, pos);
            String changenumberStr = new String(encodedMsg, pos, length, "UTF-8");
            pos += length + 1;
            this.changeNumber = new ChangeNumber(changenumberStr);
            this.assuredFlag = encodedMsg[pos++] == 1;
            this.assuredMode = AssuredMode.valueOf(encodedMsg[pos++]);
            this.safeDataLevel = encodedMsg[pos++];
            return pos;
        }
        catch (UnsupportedEncodingException e) {
            throw new DataFormatException("UTF-8 is not supported by this jvm.");
        }
        catch (IllegalArgumentException e) {
            throw new DataFormatException(e.getMessage());
        }
    }

    @Override
    public byte[] getBytes() throws UnsupportedEncodingException {
        byte[] resultByteArray = this.encodeHeader((byte)29, this.payload.length);
        int pos = resultByteArray.length - this.payload.length;
        int i = 0;
        while (i < this.payload.length) {
            resultByteArray[pos] = this.payload[i];
            ++i;
            ++pos;
        }
        return resultByteArray;
    }

    public byte[] getPayload() {
        return this.payload;
    }
}

