/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.nio.CharBuffer;
import java.text.CollationKey;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.opends.messages.ConfigMessages;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.messages.SchemaMessages;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.meta.CollationMatchingRuleCfgDefn;
import org.opends.server.admin.std.server.CollationMatchingRuleCfg;
import org.opends.server.api.AbstractMatchingRule;
import org.opends.server.api.ExtensibleIndexer;
import org.opends.server.api.ExtensibleMatchingRule;
import org.opends.server.api.IndexQueryFactory;
import org.opends.server.api.MatchingRule;
import org.opends.server.api.MatchingRuleFactory;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.backends.jeb.AttributeIndex;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConditionResult;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.IndexConfig;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollationMatchingRuleFactory
extends MatchingRuleFactory<CollationMatchingRuleCfg>
implements ConfigurationChangeListener<CollationMatchingRuleCfg> {
    private boolean equalityMatchingRuleType;
    private boolean lessThanMatchingRuleType;
    private boolean lessThanEqualToMatchingRuleType;
    private boolean greaterThanMatchingRuleType;
    private boolean greaterThanEqualToMatchingRuleType;
    private boolean substringMatchingRuleType;
    private static final Set<Locale> supportedLocales = new HashSet<Locale>();
    private CollationMatchingRuleCfg currentConfig;
    private final Map<String, MatchingRule> matchingRules = new HashMap<String, MatchingRule>();

    @Override
    public final Collection<MatchingRule> getMatchingRules() {
        return Collections.unmodifiableCollection(this.matchingRules.values());
    }

    private final void addMatchingRule(String oid, MatchingRule matchingRule) {
        this.matchingRules.put(oid, matchingRule);
    }

    private final MatchingRule getMatchingRule(String oid) {
        return this.matchingRules.get(oid);
    }

    private void resetRules() {
        this.matchingRules.clear();
    }

    private void initializeMatchingRuleTypes(SortedSet<CollationMatchingRuleCfgDefn.MatchingRuleType> ruleTypes) {
        for (CollationMatchingRuleCfgDefn.MatchingRuleType type : ruleTypes) {
            switch (type) {
                case EQUALITY: {
                    this.equalityMatchingRuleType = true;
                    break;
                }
                case LESS_THAN: {
                    this.lessThanMatchingRuleType = true;
                    break;
                }
                case LESS_THAN_OR_EQUAL_TO: {
                    this.lessThanEqualToMatchingRuleType = true;
                    break;
                }
                case GREATER_THAN: {
                    this.greaterThanMatchingRuleType = true;
                    break;
                }
                case GREATER_THAN_OR_EQUAL_TO: {
                    this.greaterThanEqualToMatchingRuleType = true;
                    break;
                }
                case SUBSTRING: {
                    this.substringMatchingRuleType = true;
                    break;
                }
            }
        }
    }

    private Collator createCollator(Locale locale) {
        Collator collator = Collator.getInstance(locale);
        collator.setStrength(0);
        collator.setDecomposition(2);
        return collator;
    }

    @Override
    public void initializeMatchingRule(CollationMatchingRuleCfg configuration) throws ConfigException, InitializationException {
        this.initializeMatchingRuleTypes(configuration.getMatchingRuleType());
        for (String collation : configuration.getCollation()) {
            CollationMapper mapper = new CollationMapper(collation);
            String nOID = mapper.getNumericOID();
            String languageTag = mapper.getLanguageTag();
            if (nOID == null || languageTag == null) {
                Message msg = SchemaMessages.WARN_ATTR_INVALID_COLLATION_MATCHING_RULE_FORMAT.get(collation);
                ErrorLogger.logError(msg);
                continue;
            }
            Locale locale = this.getLocale(languageTag);
            if (locale != null) {
                this.createLessThanMatchingRule(mapper, locale);
                this.createLessThanOrEqualToMatchingRule(mapper, locale);
                this.createEqualityMatchingRule(mapper, locale);
                this.createGreaterThanOrEqualToMatchingRule(mapper, locale);
                this.createGreaterThanMatchingRule(mapper, locale);
                this.createSubstringMatchingRule(mapper, locale);
                continue;
            }
            Message msg = SchemaMessages.WARN_ATTR_INVALID_COLLATION_MATCHING_RULE_LOCALE.get(collation, configuration.dn().toNormalizedString(), languageTag);
            ErrorLogger.logError(msg);
        }
        this.currentConfig = configuration;
        this.currentConfig.addCollationChangeListener(this);
    }

    @Override
    public void finalizeMatchingRule() {
        this.currentConfig.removeCollationChangeListener(this);
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(CollationMatchingRuleCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        if (!configuration.isEnabled() || this.currentConfig.isEnabled() != configuration.isEnabled()) {
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        for (MatchingRule rule : this.getMatchingRules()) {
            DirectoryServer.deregisterMatchingRule(rule);
        }
        this.resetRules();
        this.initializeMatchingRuleTypes(configuration.getMatchingRuleType());
        for (String collation : configuration.getCollation()) {
            CollationMapper mapper = new CollationMapper(collation);
            String languageTag = mapper.getLanguageTag();
            Locale locale = this.getLocale(languageTag);
            this.createLessThanMatchingRule(mapper, locale);
            this.createLessThanOrEqualToMatchingRule(mapper, locale);
            this.createEqualityMatchingRule(mapper, locale);
            this.createGreaterThanOrEqualToMatchingRule(mapper, locale);
            this.createGreaterThanMatchingRule(mapper, locale);
            this.createSubstringMatchingRule(mapper, locale);
        }
        try {
            for (MatchingRule matchingRule : this.getMatchingRules()) {
                DirectoryServer.registerMatchingRule(matchingRule, false);
            }
        }
        catch (DirectoryException de) {
            Message message = ConfigMessages.WARN_CONFIG_SCHEMA_MR_CONFLICTING_MR.get(String.valueOf(configuration.dn()), de.getMessageObject());
            adminActionRequired = true;
            messages.add(message);
        }
        this.currentConfig = configuration;
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(CollationMatchingRuleCfg configuration, List<Message> unacceptableReasons) {
        boolean configAcceptable = true;
        if (!configuration.isEnabled()) {
            return configAcceptable;
        }
        for (String collation : configuration.getCollation()) {
            CollationMapper mapper = new CollationMapper(collation);
            String nOID = mapper.getNumericOID();
            String languageTag = mapper.getLanguageTag();
            if (nOID == null || languageTag == null) {
                configAcceptable = false;
                Message msg = SchemaMessages.WARN_ATTR_INVALID_COLLATION_MATCHING_RULE_FORMAT.get(collation);
                unacceptableReasons.add(msg);
                continue;
            }
            Locale locale = this.getLocale(languageTag);
            if (locale != null) continue;
            Message msg = SchemaMessages.WARN_ATTR_INVALID_COLLATION_MATCHING_RULE_LOCALE.get(collation, configuration.dn().toNormalizedString(), languageTag);
            unacceptableReasons.add(msg);
            configAcceptable = false;
        }
        return configAcceptable;
    }

    private void createLessThanMatchingRule(CollationMapper mapper, Locale locale) {
        if (!this.lessThanMatchingRuleType) {
            return;
        }
        String oid = mapper.getNumericOID() + ".1";
        String lTag = mapper.getLanguageTag();
        HashSet<String> names = new HashSet<String>();
        MatchingRule matchingRule = this.getMatchingRule(oid);
        if (matchingRule != null) {
            for (String name : matchingRule.getAllNames()) {
                names.add(name);
            }
        }
        names.add(lTag + ".lt");
        names.add(lTag + ".1");
        matchingRule = new CollationLessThanMatchingRule(oid, names, locale);
        this.addMatchingRule(oid, matchingRule);
    }

    private void createLessThanOrEqualToMatchingRule(CollationMapper mapper, Locale locale) {
        if (!this.lessThanEqualToMatchingRuleType) {
            return;
        }
        String oid = mapper.getNumericOID() + ".2";
        String lTag = mapper.getLanguageTag();
        HashSet<String> names = new HashSet<String>();
        MatchingRule matchingRule = this.getMatchingRule(oid);
        if (matchingRule != null) {
            for (String name : matchingRule.getAllNames()) {
                names.add(name);
            }
        }
        names.add(lTag + ".lte");
        names.add(lTag + ".2");
        matchingRule = new CollationLessThanOrEqualToMatchingRule(oid, names, locale);
        this.addMatchingRule(oid, matchingRule);
    }

    private void createEqualityMatchingRule(CollationMapper mapper, Locale locale) {
        if (!this.equalityMatchingRuleType) {
            return;
        }
        String lTag = mapper.getLanguageTag();
        String nOID = mapper.getNumericOID();
        MatchingRule matchingRule = this.getMatchingRule(nOID);
        HashSet<String> names = new HashSet<String>();
        if (matchingRule != null) {
            for (String name : matchingRule.getAllNames()) {
                names.add(name);
            }
        }
        names.add(lTag);
        matchingRule = new CollationEqualityMatchingRule(nOID, Collections.emptySet(), locale);
        this.addMatchingRule(nOID, matchingRule);
        String OID = mapper.getNumericOID() + ".3";
        MatchingRule equalityMatchingRule = this.getMatchingRule(OID);
        if (equalityMatchingRule != null) {
            for (String name : equalityMatchingRule.getAllNames()) {
                names.add(name);
            }
        }
        names.add(lTag + ".eq");
        names.add(lTag + ".3");
        equalityMatchingRule = new CollationEqualityMatchingRule(OID, names, locale);
        this.addMatchingRule(OID, equalityMatchingRule);
    }

    private void createGreaterThanOrEqualToMatchingRule(CollationMapper mapper, Locale locale) {
        if (!this.greaterThanEqualToMatchingRuleType) {
            return;
        }
        String oid = mapper.getNumericOID() + ".4";
        String lTag = mapper.getLanguageTag();
        HashSet<String> names = new HashSet<String>();
        MatchingRule matchingRule = this.getMatchingRule(oid);
        if (matchingRule != null) {
            for (String name : matchingRule.getAllNames()) {
                names.add(name);
            }
        }
        names.add(lTag + ".gte");
        names.add(lTag + ".4");
        matchingRule = new CollationGreaterThanOrEqualToMatchingRule(oid, names, locale);
        this.addMatchingRule(oid, matchingRule);
    }

    private void createGreaterThanMatchingRule(CollationMapper mapper, Locale locale) {
        if (!this.greaterThanMatchingRuleType) {
            return;
        }
        String oid = mapper.getNumericOID() + ".5";
        String lTag = mapper.getLanguageTag();
        HashSet<String> names = new HashSet<String>();
        MatchingRule matchingRule = this.getMatchingRule(oid);
        if (matchingRule != null) {
            for (String name : matchingRule.getAllNames()) {
                names.add(name);
            }
        }
        names.add(lTag + ".gt");
        names.add(lTag + ".5");
        matchingRule = new CollationGreaterThanMatchingRule(oid, names, locale);
        this.addMatchingRule(oid, matchingRule);
    }

    private void createSubstringMatchingRule(CollationMapper mapper, Locale locale) {
        if (!this.substringMatchingRuleType) {
            return;
        }
        String oid = mapper.getNumericOID() + ".6";
        String lTag = mapper.getLanguageTag();
        HashSet<String> names = new HashSet<String>();
        MatchingRule matchingRule = this.getMatchingRule(oid);
        if (matchingRule != null) {
            for (String name : matchingRule.getAllNames()) {
                names.add(name);
            }
        }
        names.add(lTag + ".sub");
        names.add(lTag + ".6");
        matchingRule = new CollationSubstringMatchingRule(oid, names, locale);
        this.addMatchingRule(oid, matchingRule);
    }

    private Locale getLocale(String lTag) {
        Locale locale;
        String lang = null;
        String country = null;
        String variant = null;
        int countryIndex = lTag.indexOf("-");
        int variantIndex = lTag.lastIndexOf("-");
        if (countryIndex > 0) {
            lang = lTag.substring(0, countryIndex);
            if (variantIndex > countryIndex) {
                country = lTag.substring(countryIndex + 1, variantIndex);
                variant = lTag.substring(variantIndex + 1, lTag.length());
                locale = new Locale(lang, country, variant);
            } else {
                country = lTag.substring(countryIndex + 1, lTag.length());
                locale = new Locale(lang, country);
            }
        } else {
            lang = lTag;
            locale = new Locale(lTag);
        }
        if (!supportedLocales.contains(locale)) {
            locale = null;
        }
        return locale;
    }

    static {
        for (Locale l : Locale.getAvailableLocales()) {
            supportedLocales.add(l);
        }
    }

    private final class CollationMapper {
        private String oid;
        private String lTag;

        private CollationMapper(String collation) {
            int index = collation.indexOf(":");
            if (index > 0) {
                this.oid = collation.substring(index + 1, collation.length());
                this.lTag = collation.substring(0, index);
            }
        }

        private String getNumericOID() {
            return this.oid;
        }

        private String getLanguageTag() {
            return this.lTag;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CollationSubstringExtensibleIndexer
    extends ExtensibleIndexer {
        private final CollationSubstringMatchingRule matchingRule;
        private int substringLen;

        private CollationSubstringExtensibleIndexer(CollationSubstringMatchingRule matchingRule, int substringLen) {
            this.matchingRule = matchingRule;
            this.substringLen = substringLen;
        }

        @Override
        public void getKeys(AttributeValue value, Set<byte[]> keys) {
            this.matchingRule.subtringKeys(value.getValue(), keys);
        }

        @Override
        public void getKeys(AttributeValue attValue, Map<byte[], Boolean> modifiedKeys, Boolean insert) {
            this.matchingRule.substringKeys(attValue.getValue(), modifiedKeys, insert);
        }

        @Override
        public String getPreferredIndexName() {
            return this.matchingRule.getIndexName();
        }

        @Override
        public String getExtensibleIndexID() {
            return "substring";
        }

        private int gerSubstringLength() {
            return this.substringLen;
        }

        private void setSubstringLength(int substringLen) {
            this.substringLen = substringLen;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CollationSharedExtensibleIndexer
    extends ExtensibleIndexer {
        private final CollationMatchingRule matchingRule;

        private CollationSharedExtensibleIndexer(CollationMatchingRule matchingRule) {
            this.matchingRule = matchingRule;
        }

        @Override
        public String getExtensibleIndexID() {
            return "shared";
        }

        @Override
        public final void getKeys(AttributeValue value, Set<byte[]> keys) {
            try {
                ByteString key = this.matchingRule.normalizeValue(value.getValue());
                keys.add(key.toByteArray());
            }
            catch (DirectoryException de) {
                // empty catch block
            }
        }

        @Override
        public final void getKeys(AttributeValue value, Map<byte[], Boolean> modifiedKeys, Boolean insert) {
            HashSet<byte[]> keys = new HashSet<byte[]>();
            this.getKeys(value, keys);
            for (byte[] key : keys) {
                Boolean cInsert = modifiedKeys.get(key);
                if (cInsert == null) {
                    modifiedKeys.put(key, insert);
                    continue;
                }
                if (cInsert.equals(insert)) continue;
                modifiedKeys.remove(key);
            }
        }

        @Override
        public String getPreferredIndexName() {
            return this.matchingRule.getIndexName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CollationGreaterThanOrEqualToMatchingRule
    extends CollationOrderingMatchingRule {
        private static final long serialVersionUID = -5212358378014047933L;

        private CollationGreaterThanOrEqualToMatchingRule(String nOID, Collection<String> names, Locale locale) {
            super(nOID, names, locale);
        }

        @Override
        public ConditionResult valuesMatch(ByteSequence attributeValue, ByteSequence assertionValue) {
            int ret = attributeValue.compareTo(assertionValue);
            if (ret >= 0) {
                return ConditionResult.TRUE;
            }
            return ConditionResult.FALSE;
        }

        @Override
        public <T> T createIndexQuery(ByteSequence assertionValue, IndexQueryFactory<T> factory) throws DirectoryException {
            return factory.createRangeMatchQuery(this.indexer.getExtensibleIndexID(), this.normalizeValue(assertionValue), ByteString.empty(), true, false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CollationGreaterThanMatchingRule
    extends CollationOrderingMatchingRule {
        private static final long serialVersionUID = 1204368277332957024L;

        private CollationGreaterThanMatchingRule(String nOID, Collection<String> names, Locale locale) {
            super(nOID, names, locale);
        }

        @Override
        public ConditionResult valuesMatch(ByteSequence attributeValue, ByteSequence assertionValue) {
            int ret = attributeValue.compareTo(assertionValue);
            if (ret > 0) {
                return ConditionResult.TRUE;
            }
            return ConditionResult.FALSE;
        }

        @Override
        public <T> T createIndexQuery(ByteSequence assertionValue, IndexQueryFactory<T> factory) throws DirectoryException {
            return factory.createRangeMatchQuery(this.indexer.getExtensibleIndexID(), this.normalizeValue(assertionValue), ByteString.empty(), false, false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CollationLessThanOrEqualToMatchingRule
    extends CollationOrderingMatchingRule {
        private static final long serialVersionUID = 7222067708233629974L;

        private CollationLessThanOrEqualToMatchingRule(String nOID, Collection<String> names, Locale locale) {
            super(nOID, names, locale);
        }

        @Override
        public ConditionResult valuesMatch(ByteSequence attributeValue, ByteSequence assertionValue) {
            int ret = attributeValue.compareTo(assertionValue);
            if (ret <= 0) {
                return ConditionResult.TRUE;
            }
            return ConditionResult.FALSE;
        }

        @Override
        public <T> T createIndexQuery(ByteSequence assertionValue, IndexQueryFactory<T> factory) throws DirectoryException {
            return factory.createRangeMatchQuery(this.indexer.getExtensibleIndexID(), ByteString.empty(), this.normalizeValue(assertionValue), false, true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CollationLessThanMatchingRule
    extends CollationOrderingMatchingRule {
        private static final long serialVersionUID = -7578406829946732713L;

        private CollationLessThanMatchingRule(String nOID, Collection<String> names, Locale locale) {
            super(nOID, names, locale);
        }

        @Override
        public ConditionResult valuesMatch(ByteSequence attributeValue, ByteSequence assertionValue) {
            int ret = attributeValue.compareTo(assertionValue);
            if (ret < 0) {
                return ConditionResult.TRUE;
            }
            return ConditionResult.FALSE;
        }

        @Override
        public <T> T createIndexQuery(ByteSequence assertionValue, IndexQueryFactory<T> factory) throws DirectoryException {
            return factory.createRangeMatchQuery(this.indexer.getExtensibleIndexID(), ByteString.empty(), this.normalizeValue(assertionValue), false, false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class CollationOrderingMatchingRule
    extends CollationMatchingRule
    implements OrderingMatchingRule {
        private static final long serialVersionUID = 7354051060508436941L;

        private CollationOrderingMatchingRule(String nOID, Collection<String> names, Locale locale) {
            super(nOID, names, locale);
        }

        @Override
        public ByteString normalizeValue(ByteSequence value) throws DirectoryException {
            CollationKey key = this.collator.getCollationKey(((Object)value).toString());
            return ByteString.wrap(key.toByteArray());
        }

        @Override
        public int compare(byte[] arg0, byte[] arg1) {
            return StaticUtils.compare(arg0, arg1);
        }

        @Override
        public int compareValues(ByteSequence value1, ByteSequence value2) {
            return value1.compareTo(value2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CollationSubstringMatchingRule
    extends CollationMatchingRule {
        private CollationSubstringExtensibleIndexer subIndexer;

        private CollationSubstringMatchingRule(String nOID, Collection<String> names, Locale locale) {
            super(nOID, names, locale);
        }

        @Override
        public ByteString normalizeValue(ByteSequence value) throws DirectoryException {
            CollationKey key = this.collator.getCollationKey(((Object)value).toString());
            return ByteString.wrap(key.toByteArray());
        }

        private Assertion parseAssertion(ByteSequence value) throws DirectoryException {
            String subFinal;
            String subInitial;
            String filterString = ((Object)value).toString();
            int endPos = filterString.length();
            boolean hasEscape = false;
            LinkedList<Integer> asteriskPositions = new LinkedList<Integer>();
            for (int i = 0; i < endPos; ++i) {
                if (filterString.charAt(i) == '*') {
                    asteriskPositions.add(i);
                    continue;
                }
                if (filterString.charAt(i) != '\\') continue;
                hasEscape = true;
            }
            if (asteriskPositions.isEmpty()) {
                Message message = CoreMessages.ERR_SEARCH_FILTER_SUBSTRING_NO_ASTERISKS.get(filterString, 0, endPos);
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
            }
            int firstPos = (Integer)asteriskPositions.removeFirst();
            if (firstPos == 0) {
                subInitial = null;
            } else if (hasEscape) {
                CharBuffer buffer = CharBuffer.allocate(firstPos);
                for (int i = 0; i < firstPos; ++i) {
                    if (filterString.charAt(i) == '\\') {
                        char escapeValue = StaticUtils.hexToEscapedChar(filterString, i + 1);
                        i += 2;
                        buffer.put(escapeValue);
                        continue;
                    }
                    buffer.put(filterString.charAt(i));
                }
                char[] subInitialChars = new char[buffer.position()];
                buffer.flip();
                buffer.get(subInitialChars);
                subInitial = new String(subInitialChars);
            } else {
                subInitial = filterString.substring(0, firstPos);
            }
            ArrayList<String> subAny = new ArrayList<String>();
            Iterator i$ = asteriskPositions.iterator();
            while (i$.hasNext()) {
                int asteriskPos = (Integer)i$.next();
                int length = asteriskPos - firstPos - 1;
                if (hasEscape) {
                    CharBuffer buffer = CharBuffer.allocate(length);
                    for (int i = firstPos + 1; i < asteriskPos; ++i) {
                        if (filterString.charAt(i) == '\\') {
                            char escapeValue = StaticUtils.hexToEscapedChar(filterString, i + 1);
                            i += 2;
                            buffer.put(escapeValue);
                            continue;
                        }
                        buffer.put(filterString.charAt(i));
                    }
                    char[] subAnyChars = new char[buffer.position()];
                    buffer.flip();
                    buffer.get(subAnyChars);
                    subAny.add(new String(subAnyChars));
                } else {
                    subAny.add(filterString.substring(firstPos + 1, firstPos + length + 1));
                }
                firstPos = asteriskPos;
            }
            if (firstPos == endPos - 1) {
                subFinal = null;
            } else {
                int length = endPos - firstPos - 1;
                if (hasEscape) {
                    CharBuffer buffer = CharBuffer.allocate(length);
                    for (int i = firstPos + 1; i < endPos; ++i) {
                        if (filterString.charAt(i) == '\\') {
                            char escapeValue = StaticUtils.hexToEscapedChar(filterString, i + 1);
                            i += 2;
                            buffer.put(escapeValue);
                            continue;
                        }
                        buffer.put(filterString.charAt(i));
                    }
                    char[] subFinalChars = new char[buffer.position()];
                    buffer.flip();
                    buffer.get(subFinalChars);
                    subFinal = new String(subFinalChars);
                } else {
                    subFinal = filterString.substring(firstPos + 1, length + firstPos + 1);
                }
            }
            return new Assertion(subInitial, subAny, subFinal);
        }

        @Override
        public ByteString normalizeAssertionValue(ByteSequence value) throws DirectoryException {
            Assertion assertion = this.parseAssertion(value);
            String subInitial = assertion.getInitial();
            CollationKey key = null;
            ArrayList<Integer> normalizedList = new ArrayList<Integer>();
            if (subInitial == null) {
                normalizedList.add(0);
            } else {
                key = this.collator.getCollationKey(subInitial);
                byte[] initialBytes = key.toByteArray();
                int length = initialBytes.length - 4;
                normalizedList.add(length);
                for (int i = 0; i < length; ++i) {
                    normalizedList.add(Integer.valueOf(initialBytes[i]));
                }
            }
            List subAny = assertion.getAny();
            if (subAny.size() == 0) {
                normalizedList.add(0);
            } else {
                normalizedList.add(subAny.size());
                for (String any : subAny) {
                    key = this.collator.getCollationKey(any);
                    byte[] anyBytes = key.toByteArray();
                    int length = anyBytes.length - 4;
                    normalizedList.add(length);
                    for (int i = 0; i < length; ++i) {
                        normalizedList.add(Integer.valueOf(anyBytes[i]));
                    }
                }
            }
            String subFinal = assertion.getFinal();
            if (subFinal == null) {
                normalizedList.add(0);
            } else {
                key = this.collator.getCollationKey(subFinal);
                byte[] subFinalBytes = key.toByteArray();
                int length = subFinalBytes.length - 4;
                normalizedList.add(length);
                for (int i = 0; i < length; ++i) {
                    normalizedList.add(Integer.valueOf(subFinalBytes[i]));
                }
            }
            byte[] normalizedBytes = new byte[normalizedList.size()];
            for (int i = 0; i < normalizedList.size(); ++i) {
                normalizedBytes[i] = ((Integer)normalizedList.get(i)).byteValue();
            }
            return ByteString.wrap(normalizedBytes);
        }

        @Override
        public ConditionResult valuesMatch(ByteSequence attributeValue, ByteSequence assertionValue) {
            int finalLength;
            int anySize;
            int valuePos;
            int valueLength = attributeValue.length() - 4;
            int assertPos = 0;
            int subInitialLength = 0xFF & assertionValue.byteAt(0);
            if (subInitialLength != 0) {
                if (subInitialLength > valueLength) {
                    return ConditionResult.FALSE;
                }
                for (valuePos = 0; valuePos < subInitialLength; ++valuePos) {
                    if (attributeValue.byteAt(valuePos) == assertionValue.byteAt(valuePos + 1)) continue;
                    return ConditionResult.FALSE;
                }
            }
            assertPos = subInitialLength + 1;
            if ((anySize = 0xFF & assertionValue.byteAt(assertPos++)) != 0) {
                while (anySize-- > 0) {
                    int anyLength = 0xFF & assertionValue.byteAt(assertPos++);
                    int end = valueLength - anyLength;
                    boolean match = false;
                    while (valuePos <= end) {
                        if (assertionValue.byteAt(assertPos) == attributeValue.byteAt(valuePos)) {
                            boolean subMatch = true;
                            for (int i = 1; i < anyLength; ++i) {
                                if (assertionValue.byteAt(assertPos + i) == attributeValue.byteAt(valuePos + i)) continue;
                                subMatch = false;
                                break;
                            }
                            if (subMatch) {
                                match = subMatch;
                                break;
                            }
                        }
                        ++valuePos;
                    }
                    if (match) {
                        valuePos += anyLength;
                    } else {
                        return ConditionResult.FALSE;
                    }
                    assertPos += anyLength;
                }
            }
            if ((finalLength = 0xFF & assertionValue.byteAt(assertPos++)) != 0) {
                if (valueLength - finalLength < valuePos) {
                    return ConditionResult.FALSE;
                }
                valuePos = valueLength - finalLength;
                if (finalLength != assertionValue.length() - assertPos) {
                    return ConditionResult.FALSE;
                }
                valuePos = valueLength - finalLength;
                int i = 0;
                while (i < finalLength) {
                    if (assertionValue.byteAt(assertPos + i) != attributeValue.byteAt(valuePos)) {
                        return ConditionResult.FALSE;
                    }
                    ++i;
                    ++valuePos;
                }
            }
            return ConditionResult.TRUE;
        }

        @Override
        public final Collection<ExtensibleIndexer> getIndexers(IndexConfig config) {
            ArrayList<ExtensibleIndexer> indexers = new ArrayList<ExtensibleIndexer>();
            int substrLength = 6;
            if (this.subIndexer == null) {
                if (config != null) {
                    substrLength = config.getSubstringLength();
                }
                this.subIndexer = new CollationSubstringExtensibleIndexer(this, substrLength);
            } else if (config != null && config.getSubstringLength() != this.subIndexer.gerSubstringLength()) {
                this.subIndexer.setSubstringLength(substrLength);
            }
            if (this.indexer == null) {
                this.indexer = new CollationSharedExtensibleIndexer(this);
            }
            indexers.add(this.subIndexer);
            indexers.add(this.indexer);
            return indexers;
        }

        private void subtringKeys(ByteString attValue, Set<byte[]> keys) {
            String value = attValue.toString();
            int keyLength = this.subIndexer.gerSubstringLength();
            int i = 0;
            for (int remain = value.length(); remain > 0; --remain) {
                int len = Math.min(keyLength, remain);
                byte[] keyBytes = this.makeSubstringKey(value, i, len);
                keys.add(keyBytes);
                ++i;
            }
        }

        private void substringKeys(ByteString attValue, Map<byte[], Boolean> modifiedKeys, Boolean insert) {
            String value = attValue.toString();
            int keyLength = this.subIndexer.gerSubstringLength();
            int i = 0;
            for (int remain = value.length(); remain > 0; --remain) {
                int len = Math.min(keyLength, remain);
                byte[] keyBytes = this.makeSubstringKey(value, i, len);
                Boolean cinsert = modifiedKeys.get(keyBytes);
                if (cinsert == null) {
                    modifiedKeys.put(keyBytes, insert);
                } else if (!cinsert.equals(insert)) {
                    modifiedKeys.remove(keyBytes);
                }
                ++i;
            }
        }

        private byte[] makeSubstringKey(String value, int pos, int len) {
            String sub = value.substring(pos, pos + len);
            CollationKey col = this.collator.getCollationKey(sub);
            byte[] origKey = col.toByteArray();
            byte[] newKey = new byte[origKey.length - 4];
            System.arraycopy(origKey, 0, newKey, 0, newKey.length);
            return newKey;
        }

        private <T> T matchInitialSubstring(String value, IndexQueryFactory<T> factory) {
            byte[] lower = this.makeSubstringKey(value, 0, value.length());
            byte[] upper = new byte[lower.length];
            System.arraycopy(lower, 0, upper, 0, lower.length);
            for (int i = upper.length - 1; i >= 0; --i) {
                if (upper[i] != 255) {
                    upper[i] = (byte)(upper[i] + 1);
                    break;
                }
                upper[i] = 0;
            }
            return factory.createRangeMatchQuery(this.indexer.getExtensibleIndexID(), ByteString.wrap(lower), ByteString.wrap(upper), true, false);
        }

        private <T> T matchSubstring(String value, IndexQueryFactory<T> factory) {
            T intersectionQuery = null;
            int substrLength = this.subIndexer.gerSubstringLength();
            if (value.length() < substrLength) {
                byte[] lower = this.makeSubstringKey(value, 0, value.length());
                byte[] upper = this.makeSubstringKey(value, 0, value.length());
                for (int i = upper.length - 1; i >= 0; --i) {
                    if (upper[i] != 255) {
                        upper[i] = (byte)(upper[i] + 1);
                        break;
                    }
                    upper[i] = 0;
                }
                intersectionQuery = factory.createRangeMatchQuery(this.subIndexer.getExtensibleIndexID(), ByteString.wrap(lower), ByteString.wrap(upper), true, false);
            } else {
                ArrayList<T> queryList = new ArrayList<T>();
                TreeSet<byte[]> set = new TreeSet<byte[]>(new AttributeIndex.KeyComparator());
                int first = 0;
                for (int last = substrLength; last <= value.length(); ++last) {
                    byte[] keyBytes = this.makeSubstringKey(value, first, substrLength);
                    set.add(keyBytes);
                    ++first;
                }
                for (byte[] keyBytes : set) {
                    T single = factory.createExactMatchQuery(this.subIndexer.getExtensibleIndexID(), ByteString.wrap(keyBytes));
                    queryList.add(single);
                }
                intersectionQuery = factory.createIntersectionQuery(queryList);
            }
            return intersectionQuery;
        }

        @Override
        public <T> T createIndexQuery(ByteSequence assertionValue, IndexQueryFactory<T> factory) throws DirectoryException {
            Assertion assertion = this.parseAssertion(assertionValue);
            String subInitial = assertion.getInitial();
            List subAny = assertion.getAny();
            String subFinal = assertion.getFinal();
            ArrayList<T> queries = new ArrayList<T>();
            if (subInitial == null && subAny.size() == 0 && subFinal == null) {
                return factory.createMatchAllQuery();
            }
            ArrayList<String> elements = new ArrayList<String>();
            if (subInitial != null) {
                T query = this.matchInitialSubstring(subInitial, factory);
                queries.add(query);
            }
            if (subAny != null && subAny.size() > 0) {
                elements.addAll(subAny);
            }
            if (subFinal != null) {
                elements.add(subFinal);
            }
            for (String element : elements) {
                queries.add(this.matchSubstring(element, factory));
            }
            return factory.createIntersectionQuery(queries);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class Assertion {
            private String subInitial;
            private List<String> subAny;
            private String subFinal;

            private Assertion(String subInitial, List<String> subAny, String subFinal) {
                this.subInitial = subInitial;
                this.subAny = subAny;
                this.subFinal = subFinal;
            }

            private String getInitial() {
                return this.subInitial;
            }

            private List<String> getAny() {
                return this.subAny;
            }

            private String getFinal() {
                return this.subFinal;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CollationEqualityMatchingRule
    extends CollationMatchingRule
    implements OrderingMatchingRule {
        private static final long serialVersionUID = 3990778178484159862L;

        private CollationEqualityMatchingRule(String nOID, Collection<String> names, Locale locale) {
            super(nOID, names, locale);
        }

        @Override
        public ByteString normalizeValue(ByteSequence value) throws DirectoryException {
            CollationKey key = this.collator.getCollationKey(((Object)value).toString());
            return ByteString.wrap(key.toByteArray());
        }

        @Override
        public ConditionResult valuesMatch(ByteSequence attributeValue, ByteSequence assertionValue) {
            if (((Object)assertionValue).equals(attributeValue)) {
                return ConditionResult.TRUE;
            }
            return ConditionResult.FALSE;
        }

        @Override
        public <T> T createIndexQuery(ByteSequence assertionValue, IndexQueryFactory<T> factory) throws DirectoryException {
            return factory.createExactMatchQuery(this.indexer.getExtensibleIndexID(), this.normalizeValue(assertionValue));
        }

        @Override
        public int compare(byte[] arg0, byte[] arg1) {
            return StaticUtils.compare(arg0, arg1);
        }

        @Override
        public int compareValues(ByteSequence value1, ByteSequence value2) {
            return value1.compareTo(value2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class CollationMatchingRule
    extends AbstractMatchingRule
    implements ExtensibleMatchingRule {
        private final Collection<String> names;
        protected final Collator collator;
        private final String nOID;
        private final Locale locale;
        protected ExtensibleIndexer indexer;

        private CollationMatchingRule(String nOID, Collection<String> names, Locale locale) {
            this.names = names;
            this.collator = CollationMatchingRuleFactory.this.createCollator(locale);
            this.locale = locale;
            this.nOID = nOID;
        }

        @Override
        public String getName() {
            StringBuilder builder = new StringBuilder();
            for (String name : this.getAllNames()) {
                builder.append(name);
                builder.append("\b");
            }
            return builder.toString();
        }

        @Override
        public Collection<String> getAllNames() {
            return Collections.unmodifiableCollection(this.names);
        }

        @Override
        public String getOID() {
            return this.nOID;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public String getSyntaxOID() {
            return "1.3.6.1.4.1.1466.115.121.1.15";
        }

        public String getIndexName() {
            String language = this.locale.getLanguage();
            String country = this.locale.getCountry();
            String variant = this.locale.getVariant();
            StringBuilder builder = new StringBuilder(language);
            if (country != null && country.length() > 0) {
                builder.append("_");
                builder.append(this.locale.getCountry());
            }
            if (variant != null && variant.length() > 0) {
                builder.append("_");
                builder.append(this.locale.getVariant());
            }
            return builder.toString();
        }

        @Override
        public Collection<ExtensibleIndexer> getIndexers(IndexConfig config) {
            if (this.indexer == null) {
                this.indexer = new CollationSharedExtensibleIndexer(this);
            }
            return Collections.singletonList(this.indexer);
        }
    }
}

