/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.SchemaMessages;
import org.opends.server.admin.std.server.AttributeSyntaxCfg;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPSyntaxDescriptionSyntax
extends AttributeSyntax<AttributeSyntaxCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private OrderingMatchingRule defaultOrderingMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;

    @Override
    public void initializeSyntax(AttributeSyntaxCfg configuration) throws ConfigException {
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.2");
        if (this.defaultEqualityMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_EQUALITY_MATCHING_RULE.get("2.5.13.2", "LDAPSyntaxDescription"));
        }
        this.defaultOrderingMatchingRule = DirectoryServer.getOrderingMatchingRule("2.5.13.3");
        if (this.defaultOrderingMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_ORDERING_MATCHING_RULE.get("2.5.13.3", "LDAPSyntaxDescription"));
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.4");
        if (this.defaultSubstringMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_SUBSTRING_MATCHING_RULE.get("2.5.13.4", "LDAPSyntaxDescription"));
        }
    }

    @Override
    public String getSyntaxName() {
        return "LDAPSyntaxDescription";
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.1466.115.121.1.54";
    }

    @Override
    public String getDescription() {
        return "LDAP Syntax Description";
    }

    @Override
    public EqualityMatchingRule getEqualityMatchingRule() {
        return this.defaultEqualityMatchingRule;
    }

    @Override
    public OrderingMatchingRule getOrderingMatchingRule() {
        return this.defaultOrderingMatchingRule;
    }

    @Override
    public SubstringMatchingRule getSubstringMatchingRule() {
        return this.defaultSubstringMatchingRule;
    }

    @Override
    public ApproximateMatchingRule getApproximateMatchingRule() {
        return null;
    }

    @Override
    public boolean valueIsAcceptable(ByteSequence value, MessageBuilder invalidReason) {
        String tokenName;
        char c;
        int pos;
        String valueStr = ((Object)value).toString();
        String lowerStr = StaticUtils.toLowerCase(valueStr);
        int length = valueStr.length();
        for (pos = 0; pos < length && valueStr.charAt(pos) == ' '; ++pos) {
        }
        if (pos >= length) {
            invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_EMPTY_VALUE.get());
            return false;
        }
        if ((c = valueStr.charAt(pos++)) != '(') {
            invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_EXPECTED_OPEN_PARENTHESIS.get(valueStr, pos - 1, String.valueOf(c)));
            return false;
        }
        while (pos < length && (c = valueStr.charAt(pos)) == ' ') {
            ++pos;
        }
        if (pos >= length) {
            invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_TRUNCATED_VALUE.get(valueStr));
            return false;
        }
        if (StaticUtils.isDigit(c)) {
            boolean lastWasPeriod = false;
            while (pos < length && (c = valueStr.charAt(pos++)) != ' ') {
                if (c == '.') {
                    if (lastWasPeriod) {
                        invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_DOUBLE_PERIOD_IN_NUMERIC_OID.get(valueStr, pos - 1));
                        return false;
                    }
                    lastWasPeriod = true;
                    continue;
                }
                if (!StaticUtils.isDigit(c)) {
                    invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_ILLEGAL_CHAR_IN_NUMERIC_OID.get(valueStr, String.valueOf(c), pos - 1));
                    return false;
                }
                lastWasPeriod = false;
            }
        } else {
            while (pos < length && (c = valueStr.charAt(pos++)) != ' ') {
                if (StaticUtils.isAlpha(c) || StaticUtils.isDigit(c) || c == '-' || c == '_' && DirectoryServer.allowAttributeNameExceptions()) continue;
                invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_ILLEGAL_CHAR_IN_STRING_OID.get(valueStr, String.valueOf(c), pos - 1));
                return false;
            }
        }
        if (pos >= length) {
            invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_TRUNCATED_VALUE.get(valueStr));
            return false;
        }
        while (pos < length && (c = valueStr.charAt(pos)) == ' ') {
            ++pos;
        }
        if (pos >= length) {
            invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_TRUNCATED_VALUE.get(valueStr));
            return false;
        }
        if (c == ')') {
            if (pos < length) {
                invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_UNEXPECTED_CLOSE_PARENTHESIS.get(valueStr, pos - 1));
                return false;
            }
            return true;
        }
        try {
            StringBuilder tokenNameBuffer = new StringBuilder();
            pos = LDAPSyntaxDescriptionSyntax.readTokenName(lowerStr, tokenNameBuffer, pos);
            tokenName = tokenNameBuffer.toString();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_CANNOT_READ_DESC_TOKEN.get(valueStr, pos, StaticUtils.getExceptionMessage(e)));
            return false;
        }
        if (!tokenName.equals("desc")) {
            invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_TOKEN_NOT_DESC.get(valueStr, tokenName));
            return false;
        }
        try {
            StringBuilder descriptionBuffer = new StringBuilder();
            pos = LDAPSyntaxDescriptionSyntax.readQuotedString(valueStr, descriptionBuffer, pos);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_CANNOT_READ_DESC_VALUE.get(valueStr, pos, StaticUtils.getExceptionMessage(e)));
            return false;
        }
        c = valueStr.charAt(pos);
        if (c != ')') {
            try {
                pos = LDAPSyntaxDescriptionSyntax.parseExtension(valueStr, pos);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_INVALID_EXTENSION.get(StaticUtils.getExceptionMessage(e)));
                return false;
            }
        }
        if ((c = valueStr.charAt(pos++)) != ')') {
            invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_EXPECTED_CLOSE_PARENTHESIS.get(valueStr, pos, String.valueOf(c)));
            return false;
        }
        while (pos < length) {
            if ((c = valueStr.charAt(pos++)) == ' ') continue;
            invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_ILLEGAL_CHAR_AFTER_CLOSE.get(valueStr, String.valueOf(c), pos));
            return false;
        }
        return true;
    }

    private static int readTokenName(String valueStr, StringBuilder tokenName, int startPos) throws DirectoryException {
        char c = '\u0000';
        int length = valueStr.length();
        while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_TRUNCATED_VALUE.get(valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        while (startPos < length && (c = valueStr.charAt(startPos++)) != ' ') {
            tokenName.append(c);
        }
        while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        return startPos;
    }

    private static int readQuotedString(String valueStr, StringBuilder valueBuffer, int startPos) throws DirectoryException {
        char c = '\u0000';
        int length = valueStr.length();
        while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_TRUNCATED_VALUE.get(valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        if (c != '\'') {
            Message message = SchemaMessages.WARN_ATTR_SYNTAX_ATTRSYNTAX_EXPECTED_QUOTE_AT_POS.get(valueStr, startPos, String.valueOf(c));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        ++startPos;
        while (startPos < length && (c = valueStr.charAt(startPos)) != '\'') {
            valueBuffer.append(c);
            ++startPos;
        }
        ++startPos;
        while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_TRUNCATED_VALUE.get(valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        return startPos;
    }

    private static int parseExtension(String valueStr, int startPos) throws DirectoryException {
        int pos = startPos;
        int len = valueStr.length();
        do {
            StringBuilder qdString;
            Message message;
            StringBuilder tokenNameBuffer = new StringBuilder();
            pos = LDAPSyntaxDescriptionSyntax.readTokenName(valueStr, tokenNameBuffer, pos);
            String tokenName = tokenNameBuffer.toString();
            if (tokenName.length() <= 2 || !tokenName.startsWith("X-")) {
                Message message2 = SchemaMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_EXTENSION_INVALID_CHARACTER.get(valueStr, pos);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message2);
            }
            String xstring = tokenName.substring(2);
            if (xstring.split("^[A-Za-z_-]+").length > 0) {
                message = SchemaMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_EXTENSION_INVALID_CHARACTER.get(valueStr, pos);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
            char c = valueStr.charAt(pos);
            if (c == '\'') {
                qdString = new StringBuilder();
                pos = LDAPSyntaxDescriptionSyntax.readQuotedString(valueStr, qdString, pos);
            } else if (c == '(') {
                ++pos;
                qdString = new StringBuilder();
                while ((c = valueStr.charAt(pos)) != ')') {
                    pos = LDAPSyntaxDescriptionSyntax.readQuotedString(valueStr, qdString, pos);
                }
                ++pos;
            } else {
                message = SchemaMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_EXTENSION_INVALID_CHARACTER.get(valueStr, pos);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
            if (pos < len) continue;
            message = SchemaMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_TRUNCATED_VALUE.get(valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        } while (valueStr.charAt(pos) != ')');
        return pos;
    }

    @Override
    public boolean isBinary() {
        return false;
    }
}

