/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.Collection;
import java.util.Collections;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TelephoneNumberEqualityMatchingRule
extends EqualityMatchingRule {
    @Override
    public Collection<String> getAllNames() {
        return Collections.singleton(this.getName());
    }

    @Override
    public String getName() {
        return "telephoneNumberMatch";
    }

    @Override
    public String getOID() {
        return "2.5.13.20";
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getSyntaxOID() {
        return "1.3.6.1.4.1.1466.115.121.1.50";
    }

    @Override
    public ByteString normalizeValue(ByteSequence value) throws DirectoryException {
        String valueString = ((Object)value).toString();
        int valueLength = valueString.length();
        StringBuilder buffer = new StringBuilder(valueLength);
        for (int i = 0; i < valueLength; ++i) {
            char c = valueString.charAt(i);
            if (!StaticUtils.isDigit(c)) continue;
            buffer.append(c);
        }
        return ByteString.valueOf(buffer.toString());
    }
}

