/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.Collection;
import java.util.Collections;
import org.opends.messages.Message;
import org.opends.messages.SchemaMessages;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ByteString;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UniqueMemberEqualityMatchingRule
extends EqualityMatchingRule {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    @Override
    public Collection<String> getAllNames() {
        return Collections.singleton(this.getName());
    }

    @Override
    public String getName() {
        return "uniqueMemberMatch";
    }

    @Override
    public String getOID() {
        return "2.5.13.23";
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getSyntaxOID() {
        return "1.3.6.1.4.1.1466.115.121.1.34";
    }

    @Override
    public ByteString normalizeValue(ByteSequence value) throws DirectoryException {
        int valueLength;
        String valueString = ((Object)value).toString().trim();
        int dnEndPos = valueLength = valueString.length();
        int sharpPos = -1;
        if ((valueString.endsWith("'B") || valueString.endsWith("'b")) && (sharpPos = valueString.lastIndexOf("#'")) > 0) {
            dnEndPos = sharpPos;
        }
        StringBuilder valueBuffer = new StringBuilder(valueLength);
        try {
            DN dn = DN.decode(valueString.substring(0, dnEndPos));
            dn.toNormalizedString(valueBuffer);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_NAMEANDUID_INVALID_DN.get(valueString, StaticUtils.getExceptionMessage(e));
            switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                case REJECT: {
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                }
                case WARN: {
                    ErrorLogger.logError(message);
                    valueBuffer.append(StaticUtils.toLowerCase(valueString).substring(0, dnEndPos));
                    break;
                }
                default: {
                    valueBuffer.append(StaticUtils.toLowerCase(valueString).substring(0, dnEndPos));
                }
            }
        }
        if (sharpPos > 0) {
            valueBuffer.append("#'");
            int endPos = valueLength - 2;
            boolean logged = false;
            block10: for (int i = sharpPos + 2; i < endPos; ++i) {
                char c = valueString.charAt(i);
                if (c == '0' || c == '1') {
                    valueBuffer.append(c);
                    continue;
                }
                Message message = SchemaMessages.ERR_ATTR_SYNTAX_NAMEANDUID_ILLEGAL_BINARY_DIGIT.get(valueString, String.valueOf(c), i);
                switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                    case REJECT: {
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                    }
                    case WARN: {
                        if (logged) continue block10;
                        ErrorLogger.logError(message);
                        logged = true;
                    }
                }
            }
            valueBuffer.append("'B");
        }
        return ByteString.valueOf(valueBuffer.toString());
    }
}

