/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.File;
import java.util.LinkedHashSet;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.quicksetup.Constants;
import org.opends.quicksetup.util.Utils;
import org.opends.server.tools.ToolConstants;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.StringArgument;

public class JavaPropertiesToolArgumentParser
extends ArgumentParser {
    BooleanArgument showUsageArg;
    BooleanArgument quietArg;
    StringArgument propertiesFileArg;
    StringArgument destinationFileArg;

    public JavaPropertiesToolArgumentParser(String mainClassName) {
        super(mainClassName, ToolMessages.INFO_JAVAPROPERTIES_TOOL_DESCRIPTION.get(JavaPropertiesToolArgumentParser.getDefaultPropertiesValue()), false);
    }

    public void initializeArguments() throws ArgumentException {
        this.quietArg = new BooleanArgument("quiet", ToolConstants.OPTION_SHORT_QUIET, "quiet", ToolMessages.INFO_JAVAPROPERTIES_DESCRIPTION_SILENT.get());
        this.quietArg.setPropertyName("quiet");
        this.addArgument(this.quietArg);
        this.propertiesFileArg = new StringArgument("propertiesFile", Character.valueOf('p'), "propertiesFile", false, false, true, ToolMessages.INFO_PATH_PLACEHOLDER.get(), JavaPropertiesToolArgumentParser.getDefaultPropertiesValue(), "propertiesFile", ToolMessages.INFO_JAVAPROPERTIES_DESCRIPTION_PROPERTIES_FILE.get(JavaPropertiesToolArgumentParser.getDefaultPropertiesValue()));
        this.propertiesFileArg.setHidden(true);
        this.addArgument(this.propertiesFileArg);
        this.destinationFileArg = new StringArgument("destinationFile", Character.valueOf('d'), "destinationFile", false, false, true, ToolMessages.INFO_PATH_PLACEHOLDER.get(), this.getDefaultDestinationValue(), "destinationFile", ToolMessages.INFO_JAVAPROPERTIES_DESCRIPTION_DESTINATION_FILE.get(this.getDefaultDestinationValue()));
        this.destinationFileArg.setHidden(true);
        this.addArgument(this.destinationFileArg);
        this.showUsageArg = new BooleanArgument("help", Character.valueOf('H'), "help", ToolMessages.INFO_JAVAPROPERTIES_DESCRIPTION_HELP.get());
        this.addArgument(this.showUsageArg);
        this.setUsageArgument(this.showUsageArg);
    }

    public void parseArguments(String[] args) throws ArgumentException {
        LinkedHashSet<Message> errorMessages = new LinkedHashSet<Message>();
        try {
            super.parseArguments(args);
        }
        catch (ArgumentException ae) {
            errorMessages.add(ae.getMessageObject());
        }
        if (!this.isUsageArgumentPresent() && !this.isVersionArgumentPresent()) {
            File f;
            String value = this.propertiesFileArg.getValue();
            if (!(value == null || (f = new File(value)).exists() && f.isFile() && f.canRead())) {
                errorMessages.add(ToolMessages.ERR_JAVAPROPERTIES_WITH_PROPERTIES_FILE.get(value));
            }
            if ((value = this.destinationFileArg.getValue()) != null && ((f = new File(value)).isDirectory() || !Utils.canWrite(value))) {
                errorMessages.add(ToolMessages.ERR_JAVAPROPERTIES_WITH_DESTINATION_FILE.get(value));
            }
            if (errorMessages.size() > 0) {
                Message message = ToolMessages.ERR_CANNOT_INITIALIZE_ARGS.get(Utils.getMessageFromCollection(errorMessages, Constants.LINE_SEPARATOR));
                throw new ArgumentException(message);
            }
        }
    }

    private String getDefaultDestinationValue() {
        String value;
        String installPath = Utils.getInstallPathFromClasspath();
        String root = Utils.getInstancePathFromClasspath(installPath);
        if (root != null) {
            String libDir = Utils.getPath(root, "lib");
            value = Utils.isWindows() ? Utils.getPath(libDir, "set-java-home.bat") : Utils.getPath(libDir, "set-java-home");
        } else {
            value = Utils.isWindows() ? Utils.getPath("lib", "set-java-home.bat") : Utils.getPath("lib", "set-java-home");
        }
        return value;
    }

    private static String getDefaultPropertiesValue() {
        String defaultPropertiesValue;
        String installPath = Utils.getInstallPathFromClasspath();
        String root = Utils.getInstancePathFromClasspath(installPath);
        if (root != null) {
            String configDir = Utils.getPath(root, "config");
            defaultPropertiesValue = Utils.getPath(configDir, "java.properties");
        } else {
            defaultPropertiesValue = "java.properties";
        }
        return defaultPropertiesValue;
    }
}

