/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opends.server.tools.SSLConnectionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPConnectionOptions {
    private boolean reportAuthzID = false;
    private boolean useSSL = false;
    private boolean startTLS = false;
    private boolean saslExternal = false;
    private boolean usePasswordPolicyControl = false;
    private SSLConnectionFactory sslConnectionFactory = null;
    private String saslMechanism = null;
    private int versionNumber = 3;
    private Map<String, List<String>> saslProperties = new HashMap<String, List<String>>();
    private boolean verbose = false;

    public void setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
    }

    public boolean useSSL() {
        return this.useSSL;
    }

    public void setStartTLS(boolean startTLS) {
        this.startTLS = startTLS;
    }

    public boolean useStartTLS() {
        return this.startTLS;
    }

    public void setSASLExternal(boolean saslExternal) {
        this.saslExternal = saslExternal;
    }

    public boolean useSASLExternal() {
        return this.saslExternal;
    }

    public void setSSLConnectionFactory(SSLConnectionFactory sslConnectionFactory) {
        this.sslConnectionFactory = sslConnectionFactory;
    }

    public SSLConnectionFactory getSSLConnectionFactory() {
        return this.sslConnectionFactory;
    }

    public boolean setSASLMechanism(String mechanism) {
        int idx = mechanism.indexOf("=");
        if (idx == -1) {
            System.err.println("Invalid SASL mechanism property:" + mechanism);
            return false;
        }
        this.saslMechanism = mechanism.substring(idx + 1, mechanism.length());
        if (this.saslMechanism.equalsIgnoreCase("EXTERNAL")) {
            this.setSASLExternal(true);
        }
        return true;
    }

    public String getSASLMechanism() {
        return this.saslMechanism;
    }

    public Map<String, List<String>> getSASLProperties() {
        return this.saslProperties;
    }

    public boolean addSASLProperty(String property) {
        int idx = property.indexOf("=");
        if (idx == -1) {
            System.err.println("Invalid SASL property format:" + property);
            return false;
        }
        String key = property.substring(0, idx);
        String value = property.substring(idx + 1, property.length());
        List<String> valList = this.saslProperties.get(key);
        if (valList == null) {
            valList = new ArrayList<String>();
        }
        valList.add(value);
        this.saslProperties.put(key, valList);
        return true;
    }

    public void setVersionNumber(int version) {
        this.versionNumber = version;
    }

    public int getVersionNumber() {
        return this.versionNumber;
    }

    public boolean getReportAuthzID() {
        return this.reportAuthzID;
    }

    public void setReportAuthzID(boolean reportAuthzID) {
        this.reportAuthzID = reportAuthzID;
    }

    public boolean usePasswordPolicyControl() {
        return this.usePasswordPolicyControl;
    }

    public void setUsePasswordPolicyControl(boolean usePasswordPolicyControl) {
        this.usePasswordPolicyControl = usePasswordPolicyControl;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

