/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.protocols.ldap.LDAPMessage;
import org.opends.server.types.ByteString;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.RecordingOutputStream;
import org.opends.server.util.ServerConstants;

public class LDAPWriter {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    Socket socket;
    ASN1Writer asn1Writer;
    private RecordingOutputStream debugOutputStream;

    public LDAPWriter(Socket socket) throws IOException {
        this.socket = socket;
        this.debugOutputStream = new RecordingOutputStream(new BufferedOutputStream(socket.getOutputStream(), 4096));
        this.asn1Writer = ASN1.getWriter(this.debugOutputStream);
    }

    public void writeMessage(LDAPMessage message) throws IOException {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugProtocolElement(DebugLogLevel.VERBOSE, message.toString());
            this.debugOutputStream.setRecordingEnabled(true);
        }
        message.write(this.asn1Writer);
        this.asn1Writer.flush();
        if (this.debugOutputStream.isRecordingEnabled()) {
            ByteString bytesRead = this.debugOutputStream.getRecordedBytes();
            this.debugOutputStream.clearRecordedBytes();
            StringBuilder builder = new StringBuilder();
            builder.append("bytes written to wire(len=");
            builder.append(bytesRead.length());
            builder.append("):");
            builder.append(ServerConstants.EOL);
            bytesRead.toHexPlusAscii(builder, 4);
            TRACER.debugProtocolElement(DebugLogLevel.VERBOSE, builder.toString());
        }
    }

    public void close() {
        block6: {
            block5: {
                try {
                    this.asn1Writer.close();
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block5;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block6;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
    }
}

