/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.OutputStream;
import java.io.PrintStream;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.tools.ConfigureWindowsService;
import org.opends.server.types.NullOutputStream;
import org.opends.server.util.SetupUtils;
import org.opends.server.util.StaticUtils;

public class StopWindowsService {
    public static int SERVICE_STOP_SUCCESSFUL = 0;
    public static int SERVICE_NOT_FOUND = 1;
    public static int SERVICE_ALREADY_STOPPED = 2;
    public static int SERVICE_STOP_ERROR = 3;

    public static void main(String[] args) {
        int result = StopWindowsService.stopWindowsService(System.out, System.err);
        System.exit(StaticUtils.filterExitCode(result));
    }

    public static int stopWindowsService(OutputStream outStream, OutputStream errStream) {
        int returnValue;
        PrintStream out = outStream == null ? NullOutputStream.printStream() : new PrintStream(outStream);
        PrintStream err = errStream == null ? NullOutputStream.printStream() : new PrintStream(errStream);
        String serviceName = ConfigureWindowsService.getServiceName();
        if (serviceName == null) {
            Message message = ToolMessages.ERR_WINDOWS_SERVICE_NOT_FOUND.get();
            err.println(message);
            returnValue = SERVICE_NOT_FOUND;
        } else {
            String[] cmd = SetupUtils.isVista() ? new String[]{ConfigureWindowsService.getLauncherBinaryFullPath(), "run", ConfigureWindowsService.getLauncherAdministratorBinaryFullPath(), "run", "net", "stop", serviceName} : new String[]{"net", "stop", serviceName};
            try {
                returnValue = Runtime.getRuntime().exec(cmd).waitFor() == 0 ? SERVICE_STOP_SUCCESSFUL : SERVICE_STOP_ERROR;
            }
            catch (Throwable t) {
                Message message = ToolMessages.ERR_WINDOWS_SERVICE_STOP_ERROR.get();
                out.println(message);
                returnValue = SERVICE_STOP_ERROR;
            }
        }
        return returnValue;
    }
}

