/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.configurator;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.messages.ToolMessages;
import org.opends.quicksetup.BuildInformation;
import org.opends.quicksetup.QuickSetupLog;
import org.opends.quicksetup.ReturnCode;
import org.opends.server.util.DynamicConstants;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.StringArgument;

public class CheckInstance {
    private static final Logger LOG = Logger.getLogger(CheckInstance.class.getName());
    public static final String LOG_FILE_PREFIX = "opends-checkinstance-";
    private static String installRootFromSystem;
    private static String instanceRootFromSystem;
    public static final String CURRENT_USER_OPTION_LONG = "currentUser";
    public static final Character CURRENT_USER_OPTION_SHORT;
    public static final String CHECK_VERSION_OPTION_LONG = "checkVersion";
    public static final Character CHECK_VERSION_OPTION_SHORT;
    private static StringArgument currentUserArg;
    private static BooleanArgument checkVersionArg;
    private static String currentUser;
    private static String instanceOwner;
    private static boolean isWin;
    private static int SUCCESS;
    private static int ARGS_ERROR;
    private static int USER_ERROR;
    private static int VERSION_ERROR;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File from, File to) throws IOException {
        byte[] buffer = new byte[4096];
        FileInputStream inputStream = null;
        FileOutputStream outputStream = null;
        try {
            inputStream = new FileInputStream(from);
            outputStream = new FileOutputStream(to, false);
            int bytesRead = inputStream.read(buffer);
            while (bytesRead > 0) {
                outputStream.write(buffer, 0, bytesRead);
                bytesRead = inputStream.read(buffer);
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception e) {}
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            QuickSetupLog.initLogFileHandler(File.createTempFile(LOG_FILE_PREFIX, ".log"));
        }
        catch (Throwable t) {
            System.err.println(QuickSetupMessages.INFO_ERROR_INITIALIZING_LOG.get());
            t.printStackTrace();
        }
        Message toolDescription = ToolMessages.INFO_CHECK_DESCRIPTION.get();
        ArgumentParser argParser = new ArgumentParser(CheckInstance.class.getName(), toolDescription, false);
        installRootFromSystem = System.getProperty("INSTALL_ROOT");
        if (installRootFromSystem == null) {
            System.err.println(ToolMessages.ERR_INTERNAL.get(ToolMessages.ERR_INSTALL_ROOT_NOT_SPECIFIED.get()));
            System.exit(ReturnCode.APPLICATION_ERROR.getReturnCode());
        }
        if ((instanceRootFromSystem = System.getProperty("INSTANCE_ROOT")) == null) {
            System.err.println(ToolMessages.ERR_INTERNAL.get(ToolMessages.ERR_INSTANCE_ROOT_NOT_SPECIFIED.get()));
            System.exit(ReturnCode.APPLICATION_ERROR.getReturnCode());
        }
        isWin = System.getProperty("file.separator").equals("\\");
        try {
            if (!isWin) {
                currentUserArg = new StringArgument(CURRENT_USER_OPTION_LONG, CURRENT_USER_OPTION_SHORT, CURRENT_USER_OPTION_LONG, true, true, ToolMessages.INFO_CURRENT_USER_PLACEHOLDER.get(), ToolMessages.INFO_CHECK_DESCRIPTION_CURRENT_USER.get());
                argParser.addArgument(currentUserArg);
            }
            checkVersionArg = new BooleanArgument(CHECK_VERSION_OPTION_LONG, CHECK_VERSION_OPTION_SHORT, CHECK_VERSION_OPTION_LONG, ToolMessages.INFO_CHECK_DESCRIPTION_CHECK_VERSION.get());
            argParser.addArgument(checkVersionArg);
        }
        catch (ArgumentException ae) {
            System.err.println(ToolMessages.ERR_INTERNAL.get(ae.getMessageObject()));
            System.exit(ReturnCode.APPLICATION_ERROR.getReturnCode());
        }
        try {
            argParser.parseArguments(args);
        }
        catch (ArgumentException ae) {
            System.err.println(ToolMessages.ERR_INTERNAL.get(ae.getMessageObject()));
            System.exit(ARGS_ERROR);
        }
        File confDir = new File(instanceRootFromSystem, "config");
        if (!isWin) {
            File conf = new File(confDir, "config.ldif");
            String cmd = null;
            Process proc = null;
            int exit = 0;
            InputStreamReader reader = null;
            StringBuffer sb = new StringBuffer();
            cmd = "ls -l " + conf.getAbsolutePath();
            try {
                int c;
                proc = Runtime.getRuntime().exec(cmd);
                proc.waitFor();
                reader = new InputStreamReader(proc.getInputStream());
                while ((c = reader.read()) != -1) {
                    sb.append((char)c);
                }
                exit = proc.exitValue();
                if (exit != 0) {
                    LOG.log(Level.FINEST, cmd + " error= " + exit);
                    System.err.println(ToolMessages.ERR_CONFIG_LDIF_NOT_FOUND.get(conf.getAbsolutePath(), installRootFromSystem + File.separator + "instance.loc"));
                    System.exit(ReturnCode.APPLICATION_ERROR.getReturnCode());
                }
            }
            catch (InterruptedException ex) {
                LOG.log(Level.SEVERE, "InterruptedException" + ex.getMessage());
                System.err.println(ToolMessages.ERR_CONFIG_LDIF_NOT_FOUND.get(conf.getAbsolutePath(), installRootFromSystem + File.separator + "instance.loc"));
                System.exit(ReturnCode.APPLICATION_ERROR.getReturnCode());
            }
            catch (IOException ex) {
                LOG.log(Level.SEVERE, "IOException" + ex.getMessage());
                System.err.println(ToolMessages.ERR_CONFIG_LDIF_NOT_FOUND.get(conf.getAbsolutePath(), installRootFromSystem + File.separator + "instance.loc"));
                System.exit(ReturnCode.APPLICATION_ERROR.getReturnCode());
            }
            LOG.log(Level.FINEST, cmd + " returns [" + sb.toString() + "]");
            StringTokenizer tok = new StringTokenizer(sb.toString());
            if (tok.hasMoreTokens()) {
                tok.nextToken();
                if (tok.hasMoreTokens()) {
                    tok.nextToken();
                    if (tok.hasMoreTokens()) {
                        instanceOwner = tok.nextToken();
                        LOG.log(Level.FINEST, "instanceOwner=[" + instanceOwner + "]");
                    } else {
                        LOG.log(Level.SEVERE, "no instanceOwner");
                        System.err.println(ToolMessages.ERR_INTERNAL.get(Message.raw("no instanceOwner", new Object[0])));
                        System.exit(ReturnCode.APPLICATION_ERROR.getReturnCode());
                    }
                } else {
                    LOG.log(Level.SEVERE, "no inode");
                    System.err.println(ToolMessages.ERR_INTERNAL.get(Message.raw("no inode", new Object[0])));
                    System.exit(ReturnCode.APPLICATION_ERROR.getReturnCode());
                }
            } else {
                LOG.log(Level.SEVERE, "no access rights");
                System.err.println(ToolMessages.ERR_INTERNAL.get(Message.raw("no access rights", new Object[0])));
                System.exit(ReturnCode.APPLICATION_ERROR.getReturnCode());
            }
            currentUser = currentUserArg.getValue();
            LOG.log(Level.FINEST, "currentUser=[" + currentUser + "]");
            if (currentUser != null && !currentUser.equals(instanceOwner)) {
                System.err.println(ToolMessages.ERR_CHECK_USER_ERROR.get(instanceOwner));
                System.exit(USER_ERROR);
            }
        }
        BuildInformation installBi = BuildInformation.fromBuildString(DynamicConstants.MAJOR_VERSION + "." + DynamicConstants.MINOR_VERSION + "." + DynamicConstants.POINT_VERSION + "." + DynamicConstants.REVISION_NUMBER);
        File bif = new File(confDir, "buildinfo");
        if (!bif.exists()) {
            OutputStreamWriter fwriter = null;
            try {
                fwriter = new FileWriter(bif, true);
                fwriter.append(installBi.getBuildString());
            }
            catch (Exception e) {
            }
            finally {
                try {
                    fwriter.close();
                }
                catch (Exception e) {}
            }
        }
        if (checkVersionArg.isPresent()) {
            BuildInformation instanceBi;
            block60: {
                instanceBi = installBi;
                try {
                    if (!bif.exists()) break block60;
                    BufferedReader breader = new BufferedReader(new FileReader(bif));
                    try {
                        String line = breader.readLine();
                        instanceBi = BuildInformation.fromBuildString(line);
                    }
                    finally {
                        try {
                            breader.close();
                        }
                        catch (Exception e) {}
                    }
                    FileWriter fwriter = new FileWriter(bif, true);
                    try {
                        fwriter.append('\n');
                    }
                    finally {
                        try {
                            fwriter.close();
                        }
                        catch (Exception e) {}
                    }
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, "error getting build information for current instance", e);
                }
            }
            if (!installBi.equals(instanceBi)) {
                System.err.println(ToolMessages.ERR_CHECK_VERSION_NOT_MATCH.get());
                System.exit(VERSION_ERROR);
            }
        } else {
            LOG.log(Level.FINEST, "checkVersion not specified");
        }
        try {
            File upgradeDir = new File(confDir, "upgrade");
            File tmplUpgradeDir = new File(installRootFromSystem + File.separator + "tmpl_instance" + File.separator + "config" + File.separator + "upgrade");
            File concatenatedSchema = new File(upgradeDir, "schema.ldif." + DynamicConstants.REVISION_NUMBER);
            if (!concatenatedSchema.exists()) {
                File tmplConcatenatedSchema = new File(tmplUpgradeDir, "schema.ldif." + DynamicConstants.REVISION_NUMBER);
                CheckInstance.copyFile(tmplConcatenatedSchema, concatenatedSchema);
            } else {
                LOG.log(Level.INFO, concatenatedSchema.getAbsolutePath() + "already exists");
            }
            File initialConfig = new File(upgradeDir, "config.ldif." + DynamicConstants.REVISION_NUMBER);
            if (!initialConfig.exists()) {
                File tmplInitialConfig = new File(tmplUpgradeDir, "config.ldif." + DynamicConstants.REVISION_NUMBER);
                CheckInstance.copyFile(tmplInitialConfig, initialConfig);
            } else {
                LOG.log(Level.INFO, initialConfig.getAbsolutePath() + "already exists");
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "error initializing config/upgrade files", e);
        }
        System.exit(SUCCESS);
    }

    static {
        CURRENT_USER_OPTION_SHORT = null;
        CHECK_VERSION_OPTION_SHORT = null;
        SUCCESS = 0;
        ARGS_ERROR = 1;
        USER_ERROR = 2;
        VERSION_ERROR = 3;
    }
}

