/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opends.server.types.ByteString;
import org.opends.server.types.Control;
import org.opends.server.types.Operation;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public final class IntermediateResponse {
    private ByteString value;
    private List<Control> controls;
    private Operation operation;
    private String oid;

    public IntermediateResponse(Operation operation, String oid, ByteString value, List<Control> controls) {
        this.operation = operation;
        this.oid = oid;
        this.value = value;
        this.controls = controls == null ? new ArrayList<Control>(0) : controls;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public String getOID() {
        return this.oid;
    }

    public void setOID(String oid) {
        this.oid = oid;
    }

    public ByteString getValue() {
        return this.value;
    }

    public void setValue(ByteString value) {
        this.value = value;
    }

    public List<Control> getControls() {
        return this.controls;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("IntermediateResponse(operation=");
        this.operation.toString(buffer);
        buffer.append(",oid=");
        buffer.append(String.valueOf(this.oid));
        buffer.append(",value=");
        buffer.append(String.valueOf(buffer));
        if (!this.controls.isEmpty()) {
            buffer.append(",controls={");
            Iterator<Control> iterator = this.controls.iterator();
            iterator.next().toString(buffer);
            while (iterator.hasNext()) {
                buffer.append(",");
                iterator.next().toString(buffer);
            }
            buffer.append("}");
        }
        buffer.append(")");
    }
}

