/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import javax.management.Attribute;
import javax.management.MBeanException;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import org.opends.server.api.InvokableComponent;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;

@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=false, mayExtend=false, mayInvoke=true)
public class InvokableMethod {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private boolean retrievesComponentInfo;
    private boolean updatesComponentInfo;
    private ConfigAttribute[] arguments;
    private String description;
    private String name;
    private String returnType;

    public InvokableMethod(String name, String description, ConfigAttribute[] arguments, String returnType, boolean retrievesComponentInfo, boolean updatesComponentInfo) {
        this.name = name;
        this.description = description;
        this.returnType = returnType;
        this.retrievesComponentInfo = retrievesComponentInfo;
        this.updatesComponentInfo = updatesComponentInfo;
        this.arguments = arguments == null ? new ConfigAttribute[0] : arguments;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public ConfigAttribute[] getArguments() {
        return this.arguments;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public boolean retrievesComponentInfo() {
        return this.retrievesComponentInfo;
    }

    public boolean updatesComponentInfo() {
        return this.updatesComponentInfo;
    }

    public MBeanOperationInfo toOperationInfo() {
        MBeanParameterInfo[] signature = new MBeanParameterInfo[this.arguments.length];
        for (int i = 0; i < this.arguments.length; ++i) {
            signature[i] = this.arguments[i].toJMXParameterInfo();
        }
        int impact = this.retrievesComponentInfo ? (this.updatesComponentInfo ? 2 : 0) : (this.updatesComponentInfo ? 1 : 3);
        return new MBeanOperationInfo(this.name, this.description, signature, this.returnType, impact);
    }

    public boolean hasSignature(String methodName, String[] argumentTypes) {
        if (!methodName.equals(this.name)) {
            return false;
        }
        if (argumentTypes.length != this.arguments.length) {
            return false;
        }
        for (int i = 0; i < this.arguments.length; ++i) {
            MBeanParameterInfo paramInfo = this.arguments[i].toJMXParameterInfo();
            if (argumentTypes[i].equals(paramInfo.getType())) continue;
            return false;
        }
        return true;
    }

    public Object invoke(InvokableComponent component, Object[] parameters) throws MBeanException {
        try {
            ConfigAttribute[] methodArguments = new ConfigAttribute[this.arguments.length];
            for (int i = 0; i < this.arguments.length; ++i) {
                Attribute jmxAttr = new Attribute(this.arguments[i].getName(), parameters[i]);
                methodArguments[i] = this.arguments[i].duplicate();
                methodArguments[i].setValue(jmxAttr);
            }
            return component.invokeMethod(this.name, methodArguments);
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            throw new MBeanException(de, de.getMessage());
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            throw new MBeanException(e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.returnType == null) {
            buffer.append("void ");
        } else {
            buffer.append(this.returnType);
        }
        buffer.append(this.name);
        buffer.append('(');
        if (this.arguments != null && this.arguments.length > 0) {
            buffer.append(this.arguments[0].getDataType());
            buffer.append(' ');
            buffer.append(this.arguments[0].getName());
            for (int i = 1; i < this.arguments.length; ++i) {
                buffer.append(", ");
                buffer.append(this.arguments[i].getDataType());
                buffer.append(' ');
                buffer.append(this.arguments[i].getName());
            }
        }
        buffer.append(')');
        return buffer.toString();
    }
}

