/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.messages.BackendMessages;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.ExtensibleMatchingRule;
import org.opends.server.api.MatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.SchemaConfigManager;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.schema.CaseIgnoreEqualityMatchingRule;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.ByteString;
import org.opends.server.types.DITContentRule;
import org.opends.server.types.DITStructureRule;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.MatchingRuleUse;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;
import org.opends.server.types.NameForm;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SchemaFileElement;
import org.opends.server.types.StabilityLevel;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=false, mayExtend=false, mayInvoke=true)
public final class Schema {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private MatchingRule normalizationMatchingRule;
    private ConcurrentHashMap<AttributeType, List<AttributeType>> subordinateTypes;
    private ConcurrentHashMap<String, AttributeType> attributeTypes;
    private ConcurrentHashMap<String, ObjectClass> objectClasses;
    private ConcurrentHashMap<String, AttributeSyntax> syntaxes;
    private ConcurrentHashMap<String, MatchingRule> matchingRules;
    private ConcurrentHashMap<String, ApproximateMatchingRule> approximateMatchingRules;
    private ConcurrentHashMap<String, EqualityMatchingRule> equalityMatchingRules;
    private ConcurrentHashMap<String, OrderingMatchingRule> orderingMatchingRules;
    private ConcurrentHashMap<String, SubstringMatchingRule> substringMatchingRules;
    private ConcurrentHashMap<String, ExtensibleMatchingRule> extensibleMatchingRules;
    private ConcurrentHashMap<MatchingRule, MatchingRuleUse> matchingRuleUses;
    private ConcurrentHashMap<ObjectClass, DITContentRule> ditContentRules;
    private ConcurrentHashMap<Integer, DITStructureRule> ditStructureRulesByID;
    private ConcurrentHashMap<NameForm, DITStructureRule> ditStructureRulesByNameForm;
    private ConcurrentHashMap<ObjectClass, List<NameForm>> nameFormsByOC;
    private ConcurrentHashMap<String, NameForm> nameFormsByName;
    private LinkedHashSet<AttributeValue> syntaxSet;
    private LinkedHashSet<AttributeValue> attributeTypeSet;
    private LinkedHashSet<AttributeValue> ditContentRuleSet;
    private LinkedHashSet<AttributeValue> ditStructureRuleSet;
    private LinkedHashSet<AttributeValue> matchingRuleSet;
    private LinkedHashSet<AttributeValue> matchingRuleUseSet;
    private LinkedHashSet<AttributeValue> nameFormSet;
    private LinkedHashSet<AttributeValue> objectClassSet;
    private long oldestModificationTime;
    private long youngestModificationTime;
    private Map<String, Attribute> extraAttributes = new HashMap<String, Attribute>();

    public Schema() {
        this.attributeTypes = new ConcurrentHashMap();
        this.objectClasses = new ConcurrentHashMap();
        this.syntaxes = new ConcurrentHashMap();
        this.matchingRules = new ConcurrentHashMap();
        this.approximateMatchingRules = new ConcurrentHashMap();
        this.equalityMatchingRules = new ConcurrentHashMap();
        this.orderingMatchingRules = new ConcurrentHashMap();
        this.substringMatchingRules = new ConcurrentHashMap();
        this.extensibleMatchingRules = new ConcurrentHashMap();
        this.matchingRuleUses = new ConcurrentHashMap();
        this.ditContentRules = new ConcurrentHashMap();
        this.ditStructureRulesByID = new ConcurrentHashMap();
        this.ditStructureRulesByNameForm = new ConcurrentHashMap();
        this.nameFormsByOC = new ConcurrentHashMap();
        this.nameFormsByName = new ConcurrentHashMap();
        this.subordinateTypes = new ConcurrentHashMap();
        this.syntaxSet = new LinkedHashSet();
        this.attributeTypeSet = new LinkedHashSet();
        this.ditContentRuleSet = new LinkedHashSet();
        this.ditStructureRuleSet = new LinkedHashSet();
        this.matchingRuleSet = new LinkedHashSet();
        this.matchingRuleUseSet = new LinkedHashSet();
        this.nameFormSet = new LinkedHashSet();
        this.objectClassSet = new LinkedHashSet();
        this.normalizationMatchingRule = new CaseIgnoreEqualityMatchingRule();
        this.youngestModificationTime = this.oldestModificationTime = System.currentTimeMillis();
    }

    public ConcurrentHashMap<String, AttributeType> getAttributeTypes() {
        return this.attributeTypes;
    }

    public LinkedHashSet<AttributeValue> getAttributeTypeSet() {
        return this.attributeTypeSet;
    }

    public boolean hasAttributeType(String lowerName) {
        return this.attributeTypes.containsKey(lowerName);
    }

    public AttributeType getAttributeType(String lowerName) {
        return this.attributeTypes.get(lowerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAttributeType(AttributeType attributeType, boolean overwriteExisting) throws DirectoryException {
        ConcurrentHashMap<String, AttributeType> concurrentHashMap = this.attributeTypes;
        synchronized (concurrentHashMap) {
            if (!overwriteExisting) {
                String oid = StaticUtils.toLowerCase(attributeType.getOID());
                if (this.attributeTypes.containsKey(oid)) {
                    AttributeType conflictingType = this.attributeTypes.get(oid);
                    Message message = CoreMessages.ERR_SCHEMA_CONFLICTING_ATTRIBUTE_OID.get(attributeType.getNameOrOID(), oid, conflictingType.getNameOrOID());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
                }
                for (String name : attributeType.getNormalizedNames()) {
                    if (!this.attributeTypes.containsKey(name)) continue;
                    AttributeType conflictingType = this.attributeTypes.get(name);
                    Message message = CoreMessages.ERR_SCHEMA_CONFLICTING_ATTRIBUTE_NAME.get(attributeType.getNameOrOID(), name, conflictingType.getNameOrOID());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
                }
            }
            this.attributeTypes.put(StaticUtils.toLowerCase(attributeType.getOID()), attributeType);
            for (String name : attributeType.getNormalizedNames()) {
                this.attributeTypes.put(name, attributeType);
            }
            AttributeType superiorType = attributeType.getSuperiorType();
            if (superiorType != null) {
                this.registerSubordinateType(attributeType, superiorType);
            }
            String valueString = attributeType.getDefinition();
            ByteString rawValue = ByteString.valueOf(valueString);
            ByteString normValue = this.normalizationMatchingRule.normalizeValue(rawValue);
            this.attributeTypeSet.add(AttributeValues.create(rawValue, normValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterAttributeType(AttributeType attributeType) {
        ConcurrentHashMap<String, AttributeType> concurrentHashMap = this.attributeTypes;
        synchronized (concurrentHashMap) {
            this.attributeTypes.remove(StaticUtils.toLowerCase(attributeType.getOID()), attributeType);
            for (String name : attributeType.getNormalizedNames()) {
                this.attributeTypes.remove(name, attributeType);
            }
            AttributeType superiorType = attributeType.getSuperiorType();
            if (superiorType != null) {
                this.deregisterSubordinateType(attributeType, superiorType);
            }
            try {
                String valueString = attributeType.getDefinition();
                ByteString rawValue = ByteString.valueOf(valueString);
                ByteString normValue = this.normalizationMatchingRule.normalizeValue(rawValue);
                this.attributeTypeSet.remove(AttributeValues.create(rawValue, normValue));
            }
            catch (Exception e) {
                String valueString = attributeType.getDefinition();
                ByteString rawValue = ByteString.valueOf(valueString);
                ByteString normValue = ByteString.valueOf(StaticUtils.toLowerCase(valueString));
                this.attributeTypeSet.remove(AttributeValues.create(rawValue, normValue));
            }
        }
    }

    private void registerSubordinateType(AttributeType attributeType, AttributeType superiorType) {
        List<AttributeType> subTypes = this.subordinateTypes.get(superiorType);
        if (subTypes == null) {
            superiorType.setMayHaveSubordinateTypes();
            subTypes = new LinkedList<AttributeType>();
            subTypes.add(attributeType);
            this.subordinateTypes.put(superiorType, subTypes);
        } else if (!subTypes.contains(attributeType)) {
            superiorType.setMayHaveSubordinateTypes();
            subTypes.add(attributeType);
            AttributeType higherSuperior = superiorType.getSuperiorType();
            if (higherSuperior != null) {
                this.registerSubordinateType(attributeType, higherSuperior);
            }
        }
    }

    private void deregisterSubordinateType(AttributeType attributeType, AttributeType superiorType) {
        AttributeType higherSuperior;
        List<AttributeType> subTypes = this.subordinateTypes.get(superiorType);
        if (subTypes != null && subTypes.remove(attributeType) && (higherSuperior = superiorType.getSuperiorType()) != null) {
            this.deregisterSubordinateType(attributeType, higherSuperior);
        }
    }

    public Iterable<AttributeType> getSubTypes(AttributeType attributeType) {
        List<AttributeType> subTypes = this.subordinateTypes.get(attributeType);
        if (subTypes == null) {
            return Collections.emptyList();
        }
        return subTypes;
    }

    public ConcurrentHashMap<String, ObjectClass> getObjectClasses() {
        return this.objectClasses;
    }

    public LinkedHashSet<AttributeValue> getObjectClassSet() {
        return this.objectClassSet;
    }

    public boolean hasObjectClass(String lowerName) {
        return this.objectClasses.containsKey(lowerName);
    }

    public ObjectClass getObjectClass(String lowerName) {
        return this.objectClasses.get(lowerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerObjectClass(ObjectClass objectClass, boolean overwriteExisting) throws DirectoryException {
        ConcurrentHashMap<String, ObjectClass> concurrentHashMap = this.objectClasses;
        synchronized (concurrentHashMap) {
            if (!overwriteExisting) {
                String oid = StaticUtils.toLowerCase(objectClass.getOID());
                if (this.objectClasses.containsKey(oid)) {
                    ObjectClass conflictingClass = this.objectClasses.get(oid);
                    Message message = CoreMessages.ERR_SCHEMA_CONFLICTING_OBJECTCLASS_OID.get(objectClass.getNameOrOID(), oid, conflictingClass.getNameOrOID());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
                }
                for (String name : objectClass.getNormalizedNames()) {
                    if (!this.objectClasses.containsKey(name)) continue;
                    ObjectClass conflictingClass = this.objectClasses.get(name);
                    Message message = CoreMessages.ERR_SCHEMA_CONFLICTING_OBJECTCLASS_NAME.get(objectClass.getNameOrOID(), name, conflictingClass.getNameOrOID());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
                }
            }
            this.objectClasses.put(StaticUtils.toLowerCase(objectClass.getOID()), objectClass);
            for (String name : objectClass.getNormalizedNames()) {
                this.objectClasses.put(name, objectClass);
            }
            String valueString = objectClass.getDefinition();
            ByteString rawValue = ByteString.valueOf(valueString);
            ByteString normValue = this.normalizationMatchingRule.normalizeValue(rawValue);
            this.objectClassSet.add(AttributeValues.create(rawValue, normValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterObjectClass(ObjectClass objectClass) {
        ConcurrentHashMap<String, ObjectClass> concurrentHashMap = this.objectClasses;
        synchronized (concurrentHashMap) {
            this.objectClasses.remove(StaticUtils.toLowerCase(objectClass.getOID()), objectClass);
            for (String name : objectClass.getNormalizedNames()) {
                this.objectClasses.remove(name, objectClass);
            }
            try {
                String valueString = objectClass.getDefinition();
                ByteString rawValue = ByteString.valueOf(valueString);
                ByteString normValue = this.normalizationMatchingRule.normalizeValue(rawValue);
                this.objectClassSet.remove(AttributeValues.create(rawValue, normValue));
            }
            catch (Exception e) {
                String valueString = objectClass.getDefinition();
                ByteString rawValue = ByteString.valueOf(valueString);
                ByteString normValue = ByteString.valueOf(StaticUtils.toLowerCase(valueString));
                this.objectClassSet.remove(AttributeValues.create(rawValue, normValue));
            }
        }
    }

    public ConcurrentHashMap<String, AttributeSyntax> getSyntaxes() {
        return this.syntaxes;
    }

    public LinkedHashSet<AttributeValue> getSyntaxSet() {
        return this.syntaxSet;
    }

    public boolean hasSyntax(String lowerName) {
        return this.syntaxes.containsKey(lowerName);
    }

    public AttributeSyntax getSyntax(String lowerName) {
        return this.syntaxes.get(lowerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSyntax(AttributeSyntax syntax, boolean overwriteExisting) throws DirectoryException {
        ConcurrentHashMap<String, AttributeSyntax> concurrentHashMap = this.syntaxes;
        synchronized (concurrentHashMap) {
            String oid;
            if (!overwriteExisting && this.syntaxes.containsKey(oid = StaticUtils.toLowerCase(syntax.getOID()))) {
                AttributeSyntax conflictingSyntax = this.syntaxes.get(oid);
                Message message = CoreMessages.ERR_SCHEMA_CONFLICTING_SYNTAX_OID.get(syntax.getSyntaxName(), oid, conflictingSyntax.getSyntaxName());
                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
            }
            this.syntaxes.put(StaticUtils.toLowerCase(syntax.getOID()), syntax);
            String valueString = syntax.toString();
            ByteString rawValue = ByteString.valueOf(valueString);
            ByteString normValue = this.normalizationMatchingRule.normalizeValue(rawValue);
            this.syntaxSet.add(AttributeValues.create(rawValue, normValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterSyntax(AttributeSyntax syntax) {
        ConcurrentHashMap<String, AttributeSyntax> concurrentHashMap = this.syntaxes;
        synchronized (concurrentHashMap) {
            this.syntaxes.remove(StaticUtils.toLowerCase(syntax.getOID()), syntax);
            try {
                String valueString = syntax.toString();
                ByteString rawValue = ByteString.valueOf(valueString);
                ByteString normValue = this.normalizationMatchingRule.normalizeValue(rawValue);
                this.syntaxSet.remove(AttributeValues.create(rawValue, normValue));
            }
            catch (Exception e) {
                String valueString = syntax.toString();
                ByteString rawValue = ByteString.valueOf(valueString);
                ByteString normValue = ByteString.valueOf(StaticUtils.toLowerCase(valueString));
                this.syntaxSet.remove(AttributeValues.create(rawValue, normValue));
            }
        }
    }

    public ConcurrentHashMap<String, MatchingRule> getMatchingRules() {
        return this.matchingRules;
    }

    public LinkedHashSet<AttributeValue> getMatchingRuleSet() {
        return this.matchingRuleSet;
    }

    public boolean hasMatchingRule(String lowerName) {
        return this.matchingRules.containsKey(lowerName);
    }

    public MatchingRule getMatchingRule(String lowerName) {
        return this.matchingRules.get(lowerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMatchingRule(MatchingRule matchingRule, boolean overwriteExisting) throws DirectoryException {
        if (matchingRule instanceof ApproximateMatchingRule) {
            this.registerApproximateMatchingRule((ApproximateMatchingRule)matchingRule, overwriteExisting);
        } else if (matchingRule instanceof EqualityMatchingRule) {
            this.registerEqualityMatchingRule((EqualityMatchingRule)matchingRule, overwriteExisting);
        } else if (matchingRule instanceof OrderingMatchingRule) {
            this.registerOrderingMatchingRule((OrderingMatchingRule)matchingRule, overwriteExisting);
        } else if (matchingRule instanceof SubstringMatchingRule) {
            this.registerSubstringMatchingRule((SubstringMatchingRule)matchingRule, overwriteExisting);
        } else if (matchingRule instanceof ExtensibleMatchingRule) {
            this.registerExtensibleMatchingRule((ExtensibleMatchingRule)matchingRule, overwriteExisting);
        } else {
            ConcurrentHashMap<String, MatchingRule> concurrentHashMap = this.matchingRules;
            synchronized (concurrentHashMap) {
                if (!overwriteExisting) {
                    String oid = StaticUtils.toLowerCase(matchingRule.getOID());
                    if (this.matchingRules.containsKey(oid)) {
                        MatchingRule conflictingRule = this.matchingRules.get(oid);
                        Message message = CoreMessages.ERR_SCHEMA_CONFLICTING_MR_OID.get(matchingRule.getNameOrOID(), oid, conflictingRule.getNameOrOID());
                        throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
                    }
                    for (String name : matchingRule.getAllNames()) {
                        if (name == null || !this.matchingRules.containsKey(name = StaticUtils.toLowerCase(name))) continue;
                        MatchingRule conflictingRule = this.matchingRules.get(name);
                        Message message = CoreMessages.ERR_SCHEMA_CONFLICTING_MR_NAME.get(matchingRule.getOID(), name, conflictingRule.getOID());
                        throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
                    }
                }
                this.matchingRules.put(StaticUtils.toLowerCase(matchingRule.getOID()), matchingRule);
                for (String name : matchingRule.getAllNames()) {
                    if (name == null) continue;
                    this.matchingRules.put(StaticUtils.toLowerCase(name), matchingRule);
                }
                String valueString = matchingRule.toString();
                ByteString rawValue = ByteString.valueOf(valueString);
                ByteString normValue = this.normalizationMatchingRule.normalizeValue(rawValue);
                this.matchingRuleSet.add(AttributeValues.create(rawValue, normValue));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterMatchingRule(MatchingRule matchingRule) {
        if (matchingRule instanceof ApproximateMatchingRule) {
            this.deregisterApproximateMatchingRule((ApproximateMatchingRule)matchingRule);
        } else if (matchingRule instanceof EqualityMatchingRule) {
            this.deregisterEqualityMatchingRule((EqualityMatchingRule)matchingRule);
        } else if (matchingRule instanceof OrderingMatchingRule) {
            this.deregisterOrderingMatchingRule((OrderingMatchingRule)matchingRule);
        } else if (matchingRule instanceof SubstringMatchingRule) {
            this.deregisterSubstringMatchingRule((SubstringMatchingRule)matchingRule);
        } else {
            ConcurrentHashMap<String, MatchingRule> concurrentHashMap = this.matchingRules;
            synchronized (concurrentHashMap) {
                this.matchingRules.remove(StaticUtils.toLowerCase(matchingRule.getOID()), matchingRule);
                for (String name : matchingRule.getAllNames()) {
                    if (name == null) continue;
                    this.matchingRules.remove(StaticUtils.toLowerCase(name), matchingRule);
                }
                try {
                    String valueString = matchingRule.toString();
                    ByteString rawValue = ByteString.valueOf(valueString);
                    ByteString normValue = this.normalizationMatchingRule.normalizeValue(rawValue);
                    this.matchingRuleSet.remove(AttributeValues.create(rawValue, normValue));
                }
                catch (Exception e) {
                    String valueString = matchingRule.toString();
                    ByteString rawValue = ByteString.valueOf(valueString);
                    ByteString normValue = ByteString.valueOf(StaticUtils.toLowerCase(valueString));
                    this.matchingRuleSet.remove(AttributeValues.create(rawValue, normValue));
                }
            }
        }
    }

    public ConcurrentHashMap<String, ApproximateMatchingRule> getApproximateMatchingRules() {
        return this.approximateMatchingRules;
    }

    public ApproximateMatchingRule getApproximateMatchingRule(String lowerName) {
        return this.approximateMatchingRules.get(lowerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerApproximateMatchingRule(ApproximateMatchingRule matchingRule, boolean overwriteExisting) throws DirectoryException {
        ConcurrentHashMap<String, MatchingRule> concurrentHashMap = this.matchingRules;
        synchronized (concurrentHashMap) {
            String oid;
            if (!overwriteExisting) {
                oid = StaticUtils.toLowerCase(matchingRule.getOID());
                if (this.matchingRules.containsKey(oid)) {
                    MatchingRule conflictingRule = this.matchingRules.get(oid);
                    Message message = CoreMessages.ERR_SCHEMA_CONFLICTING_MR_OID.get(matchingRule.getNameOrOID(), oid, conflictingRule.getNameOrOID());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
                }
                for (String name : matchingRule.getAllNames()) {
                    if (name == null || !this.matchingRules.containsKey(name = StaticUtils.toLowerCase(name))) continue;
                    MatchingRule conflictingRule = this.matchingRules.get(name);
                    Message message = CoreMessages.ERR_SCHEMA_CONFLICTING_MR_NAME.get(matchingRule.getOID(), name, conflictingRule.getOID());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
                }
            }
            oid = StaticUtils.toLowerCase(matchingRule.getOID());
            this.approximateMatchingRules.put(oid, matchingRule);
            this.matchingRules.put(oid, matchingRule);
            for (String name : matchingRule.getAllNames()) {
                if (name == null) continue;
                name = StaticUtils.toLowerCase(name);
                this.approximateMatchingRules.put(name, matchingRule);
                this.matchingRules.put(name, matchingRule);
            }
            String valueString = matchingRule.toString();
            ByteString rawValue = ByteString.valueOf(valueString);
            ByteString normValue = this.normalizationMatchingRule.normalizeValue(rawValue);
            this.matchingRuleSet.add(AttributeValues.create(rawValue, normValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterApproximateMatchingRule(ApproximateMatchingRule matchingRule) {
        ConcurrentHashMap<String, MatchingRule> concurrentHashMap = this.matchingRules;
        synchronized (concurrentHashMap) {
            String oid = matchingRule.getOID();
            this.approximateMatchingRules.remove(oid, matchingRule);
            this.matchingRules.remove(oid, matchingRule);
            for (String name : matchingRule.getAllNames()) {
                if (name == null) continue;
                name = StaticUtils.toLowerCase(name);
                this.approximateMatchingRules.remove(name, matchingRule);
                this.matchingRules.remove(name, matchingRule);
            }
            try {
                String valueString = matchingRule.toString();
                ByteString rawValue = ByteString.valueOf(valueString);
                ByteString normValue = this.normalizationMatchingRule.normalizeValue(rawValue);
                this.matchingRuleSet.remove(AttributeValues.create(rawValue, normValue));
            }
            catch (Exception e) {
                String valueString = matchingRule.toString();
                ByteString rawValue = ByteString.valueOf(valueString);
                ByteString normValue = ByteString.valueOf(StaticUtils.toLowerCase(valueString));
                this.matchingRuleSet.remove(AttributeValues.create(rawValue, normValue));
            }
        }
    }

    public ConcurrentHashMap<String, EqualityMatchingRule> getEqualityMatchingRules() {
        return this.equalityMatchingRules;
    }

    public EqualityMatchingRule getEqualityMatchingRule(String lowerName) {
        return this.equalityMatchingRules.get(lowerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEqualityMatchingRule(EqualityMatchingRule matchingRule, boolean overwriteExisting) throws DirectoryException {
        ConcurrentHashMap<String, MatchingRule> concurrentHashMap = this.matchingRules;
        synchronized (concurrentHashMap) {
            String oid;
            if (!overwriteExisting) {
                oid = StaticUtils.toLowerCase(matchingRule.getOID());
                if (this.matchingRules.containsKey(oid)) {
                    MatchingRule conflictingRule = this.matchingRules.get(oid);
                    Message message = CoreMessages.ERR_SCHEMA_CONFLICTING_MR_OID.get(matchingRule.getNameOrOID(), oid, conflictingRule.getNameOrOID());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
                }
                for (String name : matchingRule.getAllNames()) {
                    if (name == null || !this.matchingRules.containsKey(name = StaticUtils.toLowerCase(name))) continue;
                    MatchingRule conflictingRule = this.matchingRules.get(name);
                    Message message = CoreMessages.ERR_SCHEMA_CONFLICTING_MR_NAME.get(matchingRule.getOID(), name, conflictingRule.getOID());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
                }
            }
            oid = StaticUtils.toLowerCase(matchingRule.getOID());
            this.equalityMatchingRules.put(oid, matchingRule);
            this.matchingRules.put(oid, matchingRule);
            for (String name : matchingRule.getAllNames()) {
                if (name == null) continue;
                name = StaticUtils.toLowerCase(name);
                this.equalityMatchingRules.put(name, matchingRule);
                this.matchingRules.put(name, matchingRule);
            }
            String valueString = matchingRule.toString();
            ByteString rawValue = ByteString.valueOf(valueString);
            ByteString normValue = this.normalizationMatchingRule.normalizeValue(rawValue);
            this.matchingRuleSet.add(AttributeValues.create(rawValue, normValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterEqualityMatchingRule(EqualityMatchingRule matchingRule) {
        ConcurrentHashMap<String, MatchingRule> concurrentHashMap = this.matchingRules;
        synchronized (concurrentHashMap) {
            String oid = matchingRule.getOID();
            this.equalityMatchingRules.remove(oid, matchingRule);
            this.matchingRules.remove(oid, matchingRule);
            for (String name : matchingRule.getAllNames()) {
                if (name == null) continue;
                name = StaticUtils.toLowerCase(name);
                this.equalityMatchingRules.remove(name, matchingRule);
                this.matchingRules.remove(name, matchingRule);
            }
            try {
                String valueString = matchingRule.toString();
                ByteString rawValue = ByteString.valueOf(valueString);
                ByteString normValue = this.normalizationMatchingRule.normalizeValue(rawValue);
                this.matchingRuleSet.remove(AttributeValues.create(rawValue, normValue));
            }
            catch (Exception e) {
                String valueString = matchingRule.toString();
                ByteString rawValue = ByteString.valueOf(valueString);
                ByteString normValue = ByteString.valueOf(StaticUtils.toLowerCase(valueString));
                this.matchingRuleSet.remove(AttributeValues.create(rawValue, normValue));
            }
        }
    }

    public ConcurrentHashMap<String, OrderingMatchingRule> getOrderingMatchingRules() {
        return this.orderingMatchingRules;
    }

    public OrderingMatchingRule getOrderingMatchingRule(String lowerName) {
        return this.orderingMatchingRules.get(lowerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOrderingMatchingRule(OrderingMatchingRule matchingRule, boolean overwriteExisting) throws DirectoryException {
        ConcurrentHashMap<String, MatchingRule> concurrentHashMap = this.matchingRules;
        synchronized (concurrentHashMap) {
            String oid;
            if (!overwriteExisting) {
                oid = StaticUtils.toLowerCase(matchingRule.getOID());
                if (this.matchingRules.containsKey(oid)) {
                    MatchingRule conflictingRule = this.matchingRules.get(oid);
                    Message message = CoreMessages.ERR_SCHEMA_CONFLICTING_MR_OID.get(matchingRule.getNameOrOID(), oid, conflictingRule.getNameOrOID());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
                }
                for (String name : matchingRule.getAllNames()) {
                    if (name == null || !this.matchingRules.containsKey(name = StaticUtils.toLowerCase(name))) continue;
                    MatchingRule conflictingRule = this.matchingRules.get(name);
                    Message message = CoreMessages.ERR_SCHEMA_CONFLICTING_MR_NAME.get(matchingRule.getOID(), name, conflictingRule.getOID());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
                }
            }
            oid = StaticUtils.toLowerCase(matchingRule.getOID());
            this.orderingMatchingRules.put(oid, matchingRule);
            this.matchingRules.put(oid, matchingRule);
            for (String name : matchingRule.getAllNames()) {
                if (name == null) continue;
                name = StaticUtils.toLowerCase(name);
                this.orderingMatchingRules.put(name, matchingRule);
                this.matchingRules.put(name, matchingRule);
            }
            String valueString = matchingRule.toString();
            ByteString rawValue = ByteString.valueOf(valueString);
            ByteString normValue = this.normalizationMatchingRule.normalizeValue(rawValue);
            this.matchingRuleSet.add(AttributeValues.create(rawValue, normValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterOrderingMatchingRule(OrderingMatchingRule matchingRule) {
        ConcurrentHashMap<String, MatchingRule> concurrentHashMap = this.matchingRules;
        synchronized (concurrentHashMap) {
            String oid = matchingRule.getOID();
            this.orderingMatchingRules.remove(oid, matchingRule);
            this.matchingRules.remove(oid, matchingRule);
            for (String name : matchingRule.getAllNames()) {
                if (name == null) continue;
                name = StaticUtils.toLowerCase(name);
                this.orderingMatchingRules.remove(name, matchingRule);
                this.matchingRules.remove(name, matchingRule);
            }
            try {
                String valueString = matchingRule.toString();
                ByteString rawValue = ByteString.valueOf(valueString);
                ByteString normValue = this.normalizationMatchingRule.normalizeValue(rawValue);
                this.matchingRuleSet.remove(AttributeValues.create(rawValue, normValue));
            }
            catch (Exception e) {
                String valueString = matchingRule.toString();
                ByteString rawValue = ByteString.valueOf(valueString);
                ByteString normValue = ByteString.valueOf(StaticUtils.toLowerCase(valueString));
                this.matchingRuleSet.remove(AttributeValues.create(rawValue, normValue));
            }
        }
    }

    public ConcurrentHashMap<String, SubstringMatchingRule> getSubstringMatchingRules() {
        return this.substringMatchingRules;
    }

    public SubstringMatchingRule getSubstringMatchingRule(String lowerName) {
        return this.substringMatchingRules.get(lowerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSubstringMatchingRule(SubstringMatchingRule matchingRule, boolean overwriteExisting) throws DirectoryException {
        ConcurrentHashMap<String, MatchingRule> concurrentHashMap = this.matchingRules;
        synchronized (concurrentHashMap) {
            String oid;
            if (!overwriteExisting) {
                oid = StaticUtils.toLowerCase(matchingRule.getOID());
                if (this.matchingRules.containsKey(oid)) {
                    MatchingRule conflictingRule = this.matchingRules.get(oid);
                    Message message = CoreMessages.ERR_SCHEMA_CONFLICTING_MR_OID.get(matchingRule.getNameOrOID(), oid, conflictingRule.getNameOrOID());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
                }
                for (String name : matchingRule.getAllNames()) {
                    if (name == null || !this.matchingRules.containsKey(name = StaticUtils.toLowerCase(name))) continue;
                    MatchingRule conflictingRule = this.matchingRules.get(name);
                    Message message = CoreMessages.ERR_SCHEMA_CONFLICTING_MR_NAME.get(matchingRule.getOID(), name, conflictingRule.getOID());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
                }
            }
            oid = StaticUtils.toLowerCase(matchingRule.getOID());
            this.substringMatchingRules.put(oid, matchingRule);
            this.matchingRules.put(oid, matchingRule);
            for (String name : matchingRule.getAllNames()) {
                if (name == null) continue;
                name = StaticUtils.toLowerCase(name);
                this.substringMatchingRules.put(name, matchingRule);
                this.matchingRules.put(name, matchingRule);
            }
            String valueString = matchingRule.toString();
            ByteString rawValue = ByteString.valueOf(valueString);
            ByteString normValue = this.normalizationMatchingRule.normalizeValue(rawValue);
            this.matchingRuleSet.add(AttributeValues.create(rawValue, normValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterSubstringMatchingRule(SubstringMatchingRule matchingRule) {
        ConcurrentHashMap<String, MatchingRule> concurrentHashMap = this.matchingRules;
        synchronized (concurrentHashMap) {
            String oid = matchingRule.getOID();
            this.substringMatchingRules.remove(oid, matchingRule);
            this.matchingRules.remove(oid, matchingRule);
            for (String name : matchingRule.getAllNames()) {
                if (name == null) continue;
                name = StaticUtils.toLowerCase(name);
                this.substringMatchingRules.remove(name, matchingRule);
                this.matchingRules.remove(name, matchingRule);
            }
            try {
                String valueString = matchingRule.toString();
                ByteString rawValue = ByteString.valueOf(valueString);
                ByteString normValue = this.normalizationMatchingRule.normalizeValue(rawValue);
                this.matchingRuleSet.remove(AttributeValues.create(rawValue, normValue));
            }
            catch (Exception e) {
                String valueString = matchingRule.toString();
                ByteString rawValue = ByteString.valueOf(valueString);
                ByteString normValue = ByteString.valueOf(StaticUtils.toLowerCase(valueString));
                this.matchingRuleSet.remove(AttributeValues.create(rawValue, normValue));
            }
        }
    }

    public Map<String, ExtensibleMatchingRule> getExtensibleMatchingRules() {
        return Collections.unmodifiableMap(this.extensibleMatchingRules);
    }

    public ExtensibleMatchingRule getExtensibleMatchingRule(String lowerName) {
        MatchingRule rule = this.matchingRules.get(lowerName);
        if (rule instanceof ExtensibleMatchingRule) {
            return (ExtensibleMatchingRule)rule;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerExtensibleMatchingRule(ExtensibleMatchingRule matchingRule, boolean overwriteExisting) throws DirectoryException {
        ConcurrentHashMap<String, MatchingRule> concurrentHashMap = this.matchingRules;
        synchronized (concurrentHashMap) {
            String oid;
            if (!overwriteExisting) {
                oid = StaticUtils.toLowerCase(matchingRule.getOID());
                if (this.matchingRules.containsKey(oid)) {
                    MatchingRule conflictingRule = this.matchingRules.get(oid);
                    Message message = CoreMessages.ERR_SCHEMA_CONFLICTING_MR_OID.get(matchingRule.getNameOrOID(), oid, conflictingRule.getNameOrOID());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
                }
                for (String name : matchingRule.getAllNames()) {
                    if (name == null || !this.matchingRules.containsKey(name = StaticUtils.toLowerCase(name))) continue;
                    MatchingRule conflictingRule = this.matchingRules.get(name);
                    Message message = CoreMessages.ERR_SCHEMA_CONFLICTING_MR_NAME.get(matchingRule.getOID(), name, conflictingRule.getOID());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
                }
            }
            oid = StaticUtils.toLowerCase(matchingRule.getOID());
            this.extensibleMatchingRules.put(oid, matchingRule);
            this.matchingRules.put(oid, matchingRule);
            for (String name : matchingRule.getAllNames()) {
                if (name == null) continue;
                name = StaticUtils.toLowerCase(name);
                this.extensibleMatchingRules.put(name, matchingRule);
                this.matchingRules.put(name, matchingRule);
            }
            String valueString = matchingRule.toString();
            ByteString rawValue = ByteString.valueOf(valueString);
            ByteString normValue = this.normalizationMatchingRule.normalizeValue(rawValue);
            this.matchingRuleSet.add(AttributeValues.create(rawValue, normValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterExtensibleMatchingRule(ExtensibleMatchingRule matchingRule) {
        ConcurrentHashMap<String, MatchingRule> concurrentHashMap = this.matchingRules;
        synchronized (concurrentHashMap) {
            String oid = matchingRule.getOID();
            this.extensibleMatchingRules.remove(oid, matchingRule);
            this.matchingRules.remove(oid, matchingRule);
            for (String name : matchingRule.getAllNames()) {
                if (name == null) continue;
                name = StaticUtils.toLowerCase(name);
                this.extensibleMatchingRules.remove(name, matchingRule);
                this.matchingRules.remove(name, matchingRule);
            }
            try {
                String valueString = matchingRule.toString();
                ByteString rawValue = ByteString.valueOf(valueString);
                ByteString normValue = this.normalizationMatchingRule.normalizeValue(rawValue);
                this.matchingRuleSet.remove(AttributeValues.create(rawValue, normValue));
            }
            catch (Exception e) {
                String valueString = matchingRule.toString();
                ByteString rawValue = ByteString.valueOf(valueString);
                ByteString normValue = ByteString.valueOf(StaticUtils.toLowerCase(valueString));
                this.matchingRuleSet.remove(AttributeValues.create(rawValue, normValue));
            }
        }
    }

    public ConcurrentHashMap<MatchingRule, MatchingRuleUse> getMatchingRuleUses() {
        return this.matchingRuleUses;
    }

    public LinkedHashSet<AttributeValue> getMatchingRuleUseSet() {
        return this.matchingRuleUseSet;
    }

    public boolean hasMatchingRuleUse(MatchingRule matchingRule) {
        return this.matchingRuleUses.containsKey(matchingRule);
    }

    public MatchingRuleUse getMatchingRuleUse(MatchingRule matchingRule) {
        return this.matchingRuleUses.get(matchingRule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMatchingRuleUse(MatchingRuleUse matchingRuleUse, boolean overwriteExisting) throws DirectoryException {
        ConcurrentHashMap<MatchingRule, MatchingRuleUse> concurrentHashMap = this.matchingRuleUses;
        synchronized (concurrentHashMap) {
            MatchingRule matchingRule = matchingRuleUse.getMatchingRule();
            if (!overwriteExisting && this.matchingRuleUses.containsKey(matchingRule)) {
                MatchingRuleUse conflictingUse = this.matchingRuleUses.get(matchingRule);
                Message message = CoreMessages.ERR_SCHEMA_CONFLICTING_MATCHING_RULE_USE.get(matchingRuleUse.getName(), matchingRule.getNameOrOID(), conflictingUse.getName());
                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
            }
            this.matchingRuleUses.put(matchingRule, matchingRuleUse);
            String valueString = matchingRuleUse.getDefinition();
            ByteString rawValue = ByteString.valueOf(valueString);
            ByteString normValue = this.normalizationMatchingRule.normalizeValue(rawValue);
            this.matchingRuleUseSet.add(AttributeValues.create(rawValue, normValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterMatchingRuleUse(MatchingRuleUse matchingRuleUse) {
        ConcurrentHashMap<MatchingRule, MatchingRuleUse> concurrentHashMap = this.matchingRuleUses;
        synchronized (concurrentHashMap) {
            this.matchingRuleUses.remove(matchingRuleUse.getMatchingRule(), matchingRuleUse);
            try {
                String valueString = matchingRuleUse.getDefinition();
                ByteString rawValue = ByteString.valueOf(valueString);
                ByteString normValue = this.normalizationMatchingRule.normalizeValue(rawValue);
                this.matchingRuleUseSet.remove(AttributeValues.create(rawValue, normValue));
            }
            catch (Exception e) {
                String valueString = matchingRuleUse.getDefinition();
                ByteString rawValue = ByteString.valueOf(valueString);
                ByteString normValue = ByteString.valueOf(StaticUtils.toLowerCase(valueString));
                this.matchingRuleUseSet.remove(AttributeValues.create(rawValue, normValue));
            }
        }
    }

    public ConcurrentHashMap<ObjectClass, DITContentRule> getDITContentRules() {
        return this.ditContentRules;
    }

    public LinkedHashSet<AttributeValue> getDITContentRuleSet() {
        return this.ditContentRuleSet;
    }

    public boolean hasDITContentRule(ObjectClass objectClass) {
        return this.ditContentRules.containsKey(objectClass);
    }

    public DITContentRule getDITContentRule(ObjectClass objectClass) {
        return this.ditContentRules.get(objectClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDITContentRule(DITContentRule ditContentRule, boolean overwriteExisting) throws DirectoryException {
        ConcurrentHashMap<ObjectClass, DITContentRule> concurrentHashMap = this.ditContentRules;
        synchronized (concurrentHashMap) {
            ObjectClass objectClass = ditContentRule.getStructuralClass();
            if (!overwriteExisting && this.ditContentRules.containsKey(objectClass)) {
                DITContentRule conflictingRule = this.ditContentRules.get(objectClass);
                Message message = CoreMessages.ERR_SCHEMA_CONFLICTING_DIT_CONTENT_RULE.get(ditContentRule.getName(), objectClass.getNameOrOID(), conflictingRule.getName());
                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
            }
            this.ditContentRules.put(objectClass, ditContentRule);
            String valueString = ditContentRule.getDefinition();
            ByteString rawValue = ByteString.valueOf(valueString);
            ByteString normValue = this.normalizationMatchingRule.normalizeValue(rawValue);
            this.ditContentRuleSet.add(AttributeValues.create(rawValue, normValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterDITContentRule(DITContentRule ditContentRule) {
        ConcurrentHashMap<ObjectClass, DITContentRule> concurrentHashMap = this.ditContentRules;
        synchronized (concurrentHashMap) {
            this.ditContentRules.remove(ditContentRule.getStructuralClass(), ditContentRule);
            try {
                String valueString = ditContentRule.getDefinition();
                ByteString rawValue = ByteString.valueOf(valueString);
                ByteString normValue = this.normalizationMatchingRule.normalizeValue(rawValue);
                this.ditContentRuleSet.remove(AttributeValues.create(rawValue, normValue));
            }
            catch (Exception e) {
                String valueString = ditContentRule.getDefinition();
                ByteString rawValue = ByteString.valueOf(valueString);
                ByteString normValue = ByteString.valueOf(StaticUtils.toLowerCase(valueString));
                this.ditContentRuleSet.remove(AttributeValues.create(rawValue, normValue));
            }
        }
    }

    public LinkedHashSet<AttributeValue> getDITStructureRuleSet() {
        return this.ditStructureRuleSet;
    }

    public ConcurrentHashMap<Integer, DITStructureRule> getDITStructureRulesByID() {
        return this.ditStructureRulesByID;
    }

    public ConcurrentHashMap<NameForm, DITStructureRule> getDITStructureRulesByNameForm() {
        return this.ditStructureRulesByNameForm;
    }

    public boolean hasDITStructureRule(int ruleID) {
        return this.ditStructureRulesByID.containsKey(ruleID);
    }

    public boolean hasDITStructureRule(NameForm nameForm) {
        return this.ditStructureRulesByNameForm.containsKey(nameForm);
    }

    public DITStructureRule getDITStructureRule(int ruleID) {
        return this.ditStructureRulesByID.get(ruleID);
    }

    public DITStructureRule getDITStructureRule(NameForm nameForm) {
        return this.ditStructureRulesByNameForm.get(nameForm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDITStructureRule(DITStructureRule ditStructureRule, boolean overwriteExisting) throws DirectoryException {
        ConcurrentHashMap<NameForm, DITStructureRule> concurrentHashMap = this.ditStructureRulesByNameForm;
        synchronized (concurrentHashMap) {
            NameForm nameForm = ditStructureRule.getNameForm();
            int ruleID = ditStructureRule.getRuleID();
            if (!overwriteExisting) {
                if (this.ditStructureRulesByNameForm.containsKey(nameForm)) {
                    DITStructureRule conflictingRule = this.ditStructureRulesByNameForm.get(nameForm);
                    Message message = CoreMessages.ERR_SCHEMA_CONFLICTING_DIT_STRUCTURE_RULE_NAME_FORM.get(ditStructureRule.getNameOrRuleID(), nameForm.getNameOrOID(), conflictingRule.getNameOrRuleID());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
                }
                if (this.ditStructureRulesByID.containsKey(ruleID)) {
                    DITStructureRule conflictingRule = this.ditStructureRulesByID.get(ruleID);
                    Message message = CoreMessages.ERR_SCHEMA_CONFLICTING_DIT_STRUCTURE_RULE_ID.get(ditStructureRule.getNameOrRuleID(), ruleID, conflictingRule.getNameOrRuleID());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
                }
            }
            this.ditStructureRulesByNameForm.put(nameForm, ditStructureRule);
            this.ditStructureRulesByID.put(ruleID, ditStructureRule);
            String valueString = ditStructureRule.getDefinition();
            ByteString rawValue = ByteString.valueOf(valueString);
            ByteString normValue = this.normalizationMatchingRule.normalizeValue(rawValue);
            this.ditStructureRuleSet.add(AttributeValues.create(rawValue, normValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterDITStructureRule(DITStructureRule ditStructureRule) {
        ConcurrentHashMap<NameForm, DITStructureRule> concurrentHashMap = this.ditStructureRulesByNameForm;
        synchronized (concurrentHashMap) {
            this.ditStructureRulesByNameForm.remove(ditStructureRule.getNameForm(), ditStructureRule);
            this.ditStructureRulesByID.remove(ditStructureRule.getRuleID(), ditStructureRule);
            try {
                String valueString = ditStructureRule.getDefinition();
                ByteString rawValue = ByteString.valueOf(valueString);
                ByteString normValue = this.normalizationMatchingRule.normalizeValue(rawValue);
                this.ditStructureRuleSet.remove(AttributeValues.create(rawValue, normValue));
            }
            catch (Exception e) {
                String valueString = ditStructureRule.getDefinition();
                ByteString rawValue = ByteString.valueOf(valueString);
                ByteString normValue = ByteString.valueOf(StaticUtils.toLowerCase(valueString));
                this.ditStructureRuleSet.remove(AttributeValues.create(rawValue, normValue));
            }
        }
    }

    public LinkedHashSet<AttributeValue> getNameFormSet() {
        return this.nameFormSet;
    }

    public ConcurrentHashMap<ObjectClass, List<NameForm>> getNameFormsByObjectClass() {
        return this.nameFormsByOC;
    }

    public ConcurrentHashMap<String, NameForm> getNameFormsByNameOrOID() {
        return this.nameFormsByName;
    }

    public boolean hasNameForm(ObjectClass objectClass) {
        return this.nameFormsByOC.containsKey(objectClass);
    }

    public boolean hasNameForm(String lowerName) {
        return this.nameFormsByName.containsKey(lowerName);
    }

    public List<NameForm> getNameForm(ObjectClass objectClass) {
        return this.nameFormsByOC.get(objectClass);
    }

    public NameForm getNameForm(String lowerName) {
        return this.nameFormsByName.get(lowerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerNameForm(NameForm nameForm, boolean overwriteExisting) throws DirectoryException {
        ConcurrentHashMap<ObjectClass, List<NameForm>> concurrentHashMap = this.nameFormsByOC;
        synchronized (concurrentHashMap) {
            ObjectClass objectClass = nameForm.getStructuralClass();
            List<NameForm> mappedForms = this.nameFormsByOC.get(objectClass);
            if (!overwriteExisting) {
                String oid;
                if (mappedForms != null) {
                    for (NameForm nf : mappedForms) {
                        if (!nf.equals(nameForm)) continue;
                        Message message = CoreMessages.ERR_SCHEMA_CONFLICTING_NAME_FORM_OC.get(nameForm.getNameOrOID(), objectClass.getNameOrOID(), nf.getNameOrOID());
                        throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
                    }
                }
                if (this.nameFormsByName.containsKey(oid = StaticUtils.toLowerCase(nameForm.getOID()))) {
                    NameForm conflictingNameForm = this.nameFormsByName.get(oid);
                    Message message = CoreMessages.ERR_SCHEMA_CONFLICTING_NAME_FORM_OID.get(nameForm.getNameOrOID(), oid, conflictingNameForm.getNameOrOID());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
                }
                for (String name : nameForm.getNames().keySet()) {
                    if (!this.nameFormsByName.containsKey(name)) continue;
                    NameForm conflictingNameForm = this.nameFormsByName.get(name);
                    Message message = CoreMessages.ERR_SCHEMA_CONFLICTING_NAME_FORM_NAME.get(nameForm.getNameOrOID(), oid, conflictingNameForm.getNameOrOID());
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
                }
            }
            if (mappedForms == null) {
                mappedForms = new ArrayList<NameForm>();
            }
            mappedForms.add(nameForm);
            this.nameFormsByOC.put(objectClass, mappedForms);
            this.nameFormsByName.put(StaticUtils.toLowerCase(nameForm.getOID()), nameForm);
            for (String name : nameForm.getNames().keySet()) {
                this.nameFormsByName.put(name, nameForm);
            }
            String valueString = nameForm.getDefinition();
            ByteString rawValue = ByteString.valueOf(valueString);
            ByteString normValue = this.normalizationMatchingRule.normalizeValue(rawValue);
            this.nameFormSet.add(AttributeValues.create(rawValue, normValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterNameForm(NameForm nameForm) {
        ConcurrentHashMap<ObjectClass, List<NameForm>> concurrentHashMap = this.nameFormsByOC;
        synchronized (concurrentHashMap) {
            List<NameForm> mappedForms = this.nameFormsByOC.get(nameForm.getStructuralClass());
            if (mappedForms != null) {
                mappedForms.remove(nameForm);
                if (mappedForms.size() == 0) {
                    this.nameFormsByOC.remove(nameForm.getStructuralClass());
                }
            }
            this.nameFormsByOC.remove(nameForm.getStructuralClass(), nameForm);
            this.nameFormsByName.remove(StaticUtils.toLowerCase(nameForm.getOID()), nameForm);
            for (String name : nameForm.getNames().keySet()) {
                this.nameFormsByName.remove(name, nameForm);
            }
            try {
                String valueString = nameForm.getDefinition();
                ByteString rawValue = ByteString.valueOf(valueString);
                ByteString normValue = this.normalizationMatchingRule.normalizeValue(rawValue);
                this.nameFormSet.remove(AttributeValues.create(rawValue, normValue));
            }
            catch (Exception e) {
                String valueString = nameForm.getDefinition();
                ByteString rawValue = ByteString.valueOf(valueString);
                ByteString normValue = ByteString.valueOf(StaticUtils.toLowerCase(valueString));
                this.nameFormSet.remove(AttributeValues.create(rawValue, normValue));
            }
        }
    }

    public long getOldestModificationTime() {
        return this.oldestModificationTime;
    }

    public void setOldestModificationTime(long oldestModificationTime) {
        this.oldestModificationTime = oldestModificationTime;
    }

    public long getYoungestModificationTime() {
        return this.youngestModificationTime;
    }

    public void setYoungestModificationTime(long youngestModificationTime) {
        this.youngestModificationTime = youngestModificationTime;
    }

    public void rebuildDependentElements(SchemaFileElement element) throws DirectoryException {
        try {
            this.rebuildDependentElements(element, 0);
        }
        catch (DirectoryException de) {
            if (de.getMessageObject().getDescriptor().equals(CoreMessages.ERR_SCHEMA_CIRCULAR_DEPENDENCY_REFERENCE)) {
                Message message = CoreMessages.ERR_SCHEMA_CIRCULAR_DEPENDENCY_REFERENCE.get(element.getDefinition());
                throw new DirectoryException(de.getResultCode(), message, de);
            }
            throw de;
        }
    }

    private void rebuildDependentElements(SchemaFileElement element, int depth) throws DirectoryException {
        block14: {
            block16: {
                block15: {
                    block13: {
                        if (depth > 20) {
                            Message message = CoreMessages.ERR_SCHEMA_CIRCULAR_DEPENDENCY_REFERENCE.get(element.getDefinition());
                            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
                        }
                        if (!(element instanceof AttributeType)) break block13;
                        AttributeType t = (AttributeType)element;
                        for (AttributeType attributeType : this.attributeTypes.values()) {
                            if (attributeType.getSuperiorType() == null || !attributeType.getSuperiorType().equals(t)) continue;
                            AttributeType newAT = attributeType.recreateFromDefinition();
                            this.deregisterAttributeType(attributeType);
                            this.registerAttributeType(newAT, true);
                            this.rebuildDependentElements(attributeType, depth + 1);
                        }
                        for (ObjectClass objectClass : this.objectClasses.values()) {
                            if (!objectClass.getRequiredAttributes().contains(t) && !objectClass.getOptionalAttributes().contains(t)) continue;
                            ObjectClass newOC = objectClass.recreateFromDefinition();
                            this.deregisterObjectClass(objectClass);
                            this.registerObjectClass(newOC, true);
                            this.rebuildDependentElements(objectClass, depth + 1);
                        }
                        for (List list : this.nameFormsByOC.values()) {
                            for (NameForm nf : list) {
                                if (!nf.getRequiredAttributes().contains(t) && !nf.getOptionalAttributes().contains(t)) continue;
                                NameForm newNF = nf.recreateFromDefinition();
                                this.deregisterNameForm(nf);
                                this.registerNameForm(newNF, true);
                                this.rebuildDependentElements(nf, depth + 1);
                            }
                        }
                        for (DITContentRule dITContentRule : this.ditContentRules.values()) {
                            if (!dITContentRule.getRequiredAttributes().contains(t) && !dITContentRule.getOptionalAttributes().contains(t) && !dITContentRule.getProhibitedAttributes().contains(t)) continue;
                            DITContentRule newDCR = dITContentRule.recreateFromDefinition();
                            this.deregisterDITContentRule(dITContentRule);
                            this.registerDITContentRule(newDCR, true);
                            this.rebuildDependentElements(dITContentRule, depth + 1);
                        }
                        for (MatchingRuleUse matchingRuleUse : this.matchingRuleUses.values()) {
                            if (!matchingRuleUse.getAttributes().contains(t)) continue;
                            MatchingRuleUse newMRU = matchingRuleUse.recreateFromDefinition();
                            this.deregisterMatchingRuleUse(matchingRuleUse);
                            this.registerMatchingRuleUse(newMRU, true);
                            this.rebuildDependentElements(matchingRuleUse, depth + 1);
                        }
                        break block14;
                    }
                    if (!(element instanceof ObjectClass)) break block15;
                    ObjectClass c = (ObjectClass)element;
                    for (ObjectClass objectClass : this.objectClasses.values()) {
                        if (objectClass.getSuperiorClass() == null || !objectClass.getSuperiorClass().equals(c)) continue;
                        ObjectClass newOC = objectClass.recreateFromDefinition();
                        this.deregisterObjectClass(objectClass);
                        this.registerObjectClass(newOC, true);
                        this.rebuildDependentElements(objectClass, depth + 1);
                    }
                    List<NameForm> mappedForms = this.nameFormsByOC.get(c);
                    if (mappedForms != null) {
                        for (NameForm nf : mappedForms) {
                            if (nf == null) continue;
                            NameForm newNF = nf.recreateFromDefinition();
                            this.deregisterNameForm(nf);
                            this.registerNameForm(newNF, true);
                            this.rebuildDependentElements(nf, depth + 1);
                        }
                    }
                    for (DITContentRule dcr : this.ditContentRules.values()) {
                        if (!dcr.getStructuralClass().equals(c) && !dcr.getAuxiliaryClasses().contains(c)) continue;
                        DITContentRule newDCR = dcr.recreateFromDefinition();
                        this.deregisterDITContentRule(dcr);
                        this.registerDITContentRule(newDCR, true);
                        this.rebuildDependentElements(dcr, depth + 1);
                    }
                    break block14;
                }
                if (!(element instanceof NameForm)) break block16;
                NameForm n = (NameForm)element;
                DITStructureRule dsr = this.ditStructureRulesByNameForm.get(n);
                if (dsr == null) break block14;
                DITStructureRule dITStructureRule = dsr.recreateFromDefinition();
                this.deregisterDITStructureRule(dsr);
                this.registerDITStructureRule(dITStructureRule, true);
                this.rebuildDependentElements(dsr, depth + 1);
                break block14;
            }
            if (element instanceof DITStructureRule) {
                DITStructureRule d = (DITStructureRule)element;
                for (DITStructureRule dITStructureRule : this.ditStructureRulesByID.values()) {
                    if (!dITStructureRule.getSuperiorRules().contains(d)) continue;
                    DITStructureRule newDSR = dITStructureRule.recreateFromDefinition();
                    this.deregisterDITStructureRule(dITStructureRule);
                    this.registerDITStructureRule(newDSR, true);
                    this.rebuildDependentElements(dITStructureRule, depth + 1);
                }
            }
        }
    }

    public Schema duplicate() {
        Schema dupSchema = new Schema();
        dupSchema.attributeTypes.putAll(this.attributeTypes);
        dupSchema.subordinateTypes.putAll(this.subordinateTypes);
        dupSchema.objectClasses.putAll(this.objectClasses);
        dupSchema.syntaxes.putAll(this.syntaxes);
        dupSchema.matchingRules.putAll(this.matchingRules);
        dupSchema.approximateMatchingRules.putAll(this.approximateMatchingRules);
        dupSchema.equalityMatchingRules.putAll(this.equalityMatchingRules);
        dupSchema.orderingMatchingRules.putAll(this.orderingMatchingRules);
        dupSchema.substringMatchingRules.putAll(this.substringMatchingRules);
        dupSchema.extensibleMatchingRules.putAll(this.extensibleMatchingRules);
        dupSchema.matchingRuleUses.putAll(this.matchingRuleUses);
        dupSchema.ditContentRules.putAll(this.ditContentRules);
        dupSchema.ditStructureRulesByID.putAll(this.ditStructureRulesByID);
        dupSchema.ditStructureRulesByNameForm.putAll(this.ditStructureRulesByNameForm);
        dupSchema.nameFormsByOC.putAll(this.nameFormsByOC);
        dupSchema.nameFormsByName.putAll(this.nameFormsByName);
        dupSchema.syntaxSet.addAll(this.syntaxSet);
        dupSchema.attributeTypeSet.addAll(this.attributeTypeSet);
        dupSchema.ditContentRuleSet.addAll(this.ditContentRuleSet);
        dupSchema.ditStructureRuleSet.addAll(this.ditStructureRuleSet);
        dupSchema.matchingRuleSet.addAll(this.matchingRuleSet);
        dupSchema.matchingRuleUseSet.addAll(this.matchingRuleUseSet);
        dupSchema.nameFormSet.addAll(this.nameFormSet);
        dupSchema.objectClassSet.addAll(this.objectClassSet);
        dupSchema.oldestModificationTime = this.oldestModificationTime;
        dupSchema.youngestModificationTime = this.youngestModificationTime;
        if (this.extraAttributes != null) {
            dupSchema.extraAttributes = new HashMap<String, Attribute>(this.extraAttributes);
        }
        return dupSchema;
    }

    public Map<String, Attribute> getExtraAttributes() {
        return this.extraAttributes;
    }

    public void addExtraAttribute(String name, Attribute attr) {
        this.extraAttributes.put(name, attr);
    }

    public static void writeConcatenatedSchema() {
        String concatFilePath = null;
        try {
            LinkedHashSet<String> attributeTypes = new LinkedHashSet<String>();
            LinkedHashSet<String> objectClasses = new LinkedHashSet<String>();
            LinkedHashSet<String> nameForms = new LinkedHashSet<String>();
            LinkedHashSet<String> ditContentRules = new LinkedHashSet<String>();
            LinkedHashSet<String> ditStructureRules = new LinkedHashSet<String>();
            LinkedHashSet<String> matchingRuleUses = new LinkedHashSet<String>();
            Schema.genConcatenatedSchema(attributeTypes, objectClasses, nameForms, ditContentRules, ditStructureRules, matchingRuleUses);
            File configFile = new File(DirectoryServer.getConfigFile());
            File configDirectory = configFile.getParentFile();
            File upgradeDirectory = new File(configDirectory, "upgrade");
            upgradeDirectory.mkdir();
            File concatFile = new File(upgradeDirectory, "schema.ldif.current");
            concatFilePath = concatFile.getAbsolutePath();
            File tempFile = new File(concatFilePath + ".tmp");
            BufferedWriter writer = new BufferedWriter(new FileWriter(tempFile, false));
            writer.write("dn: " + DirectoryServer.getSchemaDN().toString());
            writer.newLine();
            writer.write("objectClass: top");
            writer.newLine();
            writer.write("objectClass: ldapSubentry");
            writer.newLine();
            writer.write("objectClass: subschema");
            writer.newLine();
            for (String line : attributeTypes) {
                writer.write("attributeTypes");
                writer.write(": ");
                writer.write(line);
                writer.newLine();
            }
            for (String line : objectClasses) {
                writer.write("objectClasses");
                writer.write(": ");
                writer.write(line);
                writer.newLine();
            }
            for (String line : nameForms) {
                writer.write("nameForms");
                writer.write(": ");
                writer.write(line);
                writer.newLine();
            }
            for (String line : ditContentRules) {
                writer.write("dITContentRules");
                writer.write(": ");
                writer.write(line);
                writer.newLine();
            }
            for (String line : ditStructureRules) {
                writer.write("dITStructureRules");
                writer.write(": ");
                writer.write(line);
                writer.newLine();
            }
            for (String line : matchingRuleUses) {
                writer.write("matchingRuleUse");
                writer.write(": ");
                writer.write(line);
                writer.newLine();
            }
            writer.close();
            if (concatFile.exists()) {
                concatFile.delete();
            }
            tempFile.renameTo(concatFile);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            ErrorLogger.logError(BackendMessages.ERR_SCHEMA_CANNOT_WRITE_CONCAT_SCHEMA_FILE.get(String.valueOf(concatFilePath), StaticUtils.getExceptionMessage(e)));
        }
    }

    public static void genConcatenatedSchema(LinkedHashSet<String> attributeTypes, LinkedHashSet<String> objectClasses, LinkedHashSet<String> nameForms, LinkedHashSet<String> ditContentRules, LinkedHashSet<String> ditStructureRules, LinkedHashSet<String> matchingRuleUses) throws IOException {
        String schemaDirectory = SchemaConfigManager.getSchemaDirectoryPath(false);
        TreeSet<File> schemaFiles = new TreeSet<File>();
        for (File f : new File(schemaDirectory).listFiles()) {
            if (!f.isFile()) continue;
            schemaFiles.add(f);
        }
        schemaDirectory = SchemaConfigManager.getSchemaDirectoryPath(true);
        for (File f : new File(schemaDirectory).listFiles()) {
            if (!f.isFile()) continue;
            schemaFiles.add(f);
        }
        for (File f : schemaFiles) {
            String line;
            LinkedList<StringBuilder> lines = new LinkedList<StringBuilder>();
            BufferedReader reader = new BufferedReader(new FileReader(f));
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#") || line.length() == 0) continue;
                if (line.startsWith(" ")) {
                    ((StringBuilder)lines.getLast()).append(line.substring(1));
                    continue;
                }
                lines.add(new StringBuilder(line));
            }
            reader.close();
            for (StringBuilder buffer : lines) {
                String value;
                String line2 = buffer.toString().trim();
                if (line2.endsWith(" )")) {
                    line2 = line2.substring(0, line2.length() - 1) + "X-SCHEMA-FILE" + " '" + f.getName() + "' )";
                } else {
                    if (!line2.endsWith(")")) continue;
                    line2 = line2.substring(0, line2.length() - 1) + " " + "X-SCHEMA-FILE" + " '" + f.getName() + "' )";
                }
                String lowerLine = StaticUtils.toLowerCase(line2);
                if (lowerLine.startsWith("attributetypes")) {
                    value = line2.substring("attributeTypes".length() + 1).trim();
                    attributeTypes.add(value);
                    continue;
                }
                if (lowerLine.startsWith("objectclasses")) {
                    value = line2.substring("objectClasses".length() + 1).trim();
                    objectClasses.add(value);
                    continue;
                }
                if (lowerLine.startsWith("nameforms")) {
                    value = line2.substring("nameForms".length() + 1).trim();
                    nameForms.add(value);
                    continue;
                }
                if (lowerLine.startsWith("ditcontentrules")) {
                    value = line2.substring("dITContentRules".length() + 1).trim();
                    ditContentRules.add(value);
                    continue;
                }
                if (lowerLine.startsWith("ditstructurerules")) {
                    value = line2.substring("dITStructureRules".length() + 1).trim();
                    ditStructureRules.add(value);
                    continue;
                }
                if (!lowerLine.startsWith("matchingruleuse")) continue;
                value = line2.substring("matchingRuleUse".length() + 1).trim();
                matchingRuleUses.add(value);
            }
        }
    }

    public static void readConcatenatedSchema(String concatSchemaFile, LinkedHashSet<String> attributeTypes, LinkedHashSet<String> objectClasses, LinkedHashSet<String> nameForms, LinkedHashSet<String> ditContentRules, LinkedHashSet<String> ditStructureRules, LinkedHashSet<String> matchingRuleUses) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(concatSchemaFile));
        while ((line = reader.readLine()) != null) {
            String value;
            String lowerLine = StaticUtils.toLowerCase(line);
            if (lowerLine.startsWith("attributetypes")) {
                value = line.substring("attributeTypes".length() + 1).trim();
                attributeTypes.add(value);
                continue;
            }
            if (lowerLine.startsWith("objectclasses")) {
                value = line.substring("objectClasses".length() + 1).trim();
                objectClasses.add(value);
                continue;
            }
            if (lowerLine.startsWith("nameforms")) {
                value = line.substring("nameForms".length() + 1).trim();
                nameForms.add(value);
                continue;
            }
            if (lowerLine.startsWith("ditcontentrules")) {
                value = line.substring("dITContentRules".length() + 1).trim();
                ditContentRules.add(value);
                continue;
            }
            if (lowerLine.startsWith("ditstructurerules")) {
                value = line.substring("dITStructureRules".length() + 1).trim();
                ditStructureRules.add(value);
                continue;
            }
            if (!lowerLine.startsWith("matchingruleuse")) continue;
            value = line.substring("matchingRuleUse".length() + 1).trim();
            matchingRuleUses.add(value);
        }
        reader.close();
    }

    public static void compareConcatenatedSchema(LinkedHashSet<String> oldElements, LinkedHashSet<String> newElements, AttributeType elementType, LinkedList<Modification> mods) {
        AttributeType attributeTypesType = DirectoryServer.getAttributeType("attributetypes", true);
        AttributeBuilder builder = new AttributeBuilder(elementType);
        for (String s : oldElements) {
            if (newElements.contains(s)) continue;
            builder.add(AttributeValues.create(attributeTypesType, s));
        }
        if (!builder.isEmpty()) {
            mods.add(new Modification(ModificationType.DELETE, builder.toAttribute()));
        }
        builder.setAttributeType(elementType);
        for (String s : newElements) {
            if (oldElements.contains(s)) continue;
            builder.add(AttributeValues.create(attributeTypesType, s));
        }
        if (!builder.isEmpty()) {
            mods.add(new Modification(ModificationType.ADD, builder.toAttribute()));
        }
    }

    @PublicAPI(stability=StabilityLevel.PRIVATE, mayInstantiate=false, mayExtend=false, mayInvoke=true)
    public synchronized void destroy() {
        if (this.approximateMatchingRules != null) {
            this.approximateMatchingRules.clear();
            this.approximateMatchingRules = null;
        }
        if (this.attributeTypes != null) {
            this.attributeTypes.clear();
            this.attributeTypes = null;
        }
        if (this.attributeTypeSet != null) {
            this.attributeTypeSet.clear();
            this.attributeTypeSet = null;
        }
        if (this.ditContentRules != null) {
            this.ditContentRules.clear();
            this.ditContentRules = null;
        }
        if (this.ditContentRuleSet != null) {
            this.ditContentRuleSet.clear();
            this.ditContentRuleSet = null;
        }
        if (this.ditStructureRulesByID != null) {
            this.ditStructureRulesByID.clear();
            this.ditStructureRulesByID = null;
        }
        if (this.ditStructureRulesByNameForm != null) {
            this.ditStructureRulesByNameForm.clear();
            this.ditStructureRulesByNameForm = null;
        }
        if (this.ditStructureRuleSet != null) {
            this.ditStructureRuleSet.clear();
            this.ditStructureRuleSet = null;
        }
        if (this.equalityMatchingRules != null) {
            this.equalityMatchingRules.clear();
            this.equalityMatchingRules = null;
        }
        if (this.matchingRules != null) {
            this.matchingRules.clear();
            this.matchingRules = null;
        }
        if (this.matchingRuleSet != null) {
            this.matchingRuleSet.clear();
            this.matchingRuleSet = null;
        }
        if (this.matchingRuleUses != null) {
            this.matchingRuleUses.clear();
            this.matchingRuleUses = null;
        }
        if (this.matchingRuleUseSet != null) {
            this.matchingRuleUseSet.clear();
            this.matchingRuleUseSet = null;
        }
        if (this.nameFormsByName != null) {
            this.nameFormsByName.clear();
            this.nameFormsByName = null;
        }
        if (this.nameFormsByOC != null) {
            this.nameFormsByOC.clear();
            this.nameFormsByOC = null;
        }
        if (this.nameFormSet != null) {
            this.nameFormSet.clear();
            this.nameFormSet = null;
        }
        if (this.objectClasses != null) {
            this.objectClasses.clear();
            this.objectClasses = null;
        }
        if (this.objectClassSet != null) {
            this.objectClassSet.clear();
            this.objectClassSet = null;
        }
        if (this.orderingMatchingRules != null) {
            this.orderingMatchingRules.clear();
            this.orderingMatchingRules = null;
        }
        if (this.subordinateTypes != null) {
            this.subordinateTypes.clear();
            this.subordinateTypes = null;
        }
        if (this.substringMatchingRules != null) {
            this.substringMatchingRules.clear();
            this.substringMatchingRules = null;
        }
        if (this.extraAttributes != null) {
            this.extraAttributes.clear();
            this.extraAttributes = null;
        }
        if (this.syntaxes != null) {
            this.syntaxes.clear();
            this.syntaxes = null;
        }
        if (this.syntaxSet != null) {
            this.syntaxSet.clear();
            this.syntaxSet = null;
        }
        if (this.extensibleMatchingRules != null) {
            this.extensibleMatchingRules.clear();
            this.extensibleMatchingRules = null;
        }
    }
}

