/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util;

import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;
import org.opends.server.util.Validator;

@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=false, mayExtend=false, mayInvoke=true)
public final class LevenshteinDistance {
    public static int calculate(String source, String target) {
        int i;
        Validator.ensureNotNull(source, target);
        int sl = source.length();
        int tl = target.length();
        if (sl == 0) {
            return tl;
        }
        if (tl == 0) {
            return sl;
        }
        int w = sl + 1;
        int h = tl + 1;
        int[][] m = new int[w][h];
        for (i = 0; i < w; ++i) {
            m[i][0] = i;
        }
        for (i = 1; i < h; ++i) {
            m[0][i] = i;
        }
        i = 0;
        int x = 1;
        while (i < sl) {
            char s = source.charAt(i);
            int j = 0;
            int y = 1;
            while (j < tl) {
                char t = target.charAt(j);
                m[x][y] = Math.min(Math.min(m[i][y] + 1, m[x][j] + 1), m[i][j] + (s == t ? 0 : 1));
                ++j;
                ++y;
            }
            ++i;
            ++x;
        }
        return m[sl][tl];
    }
}

