/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util;

import org.opends.messages.Message;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;
import org.opends.server.util.ServerConstants;

@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=false, mayExtend=false, mayInvoke=true)
public class Validator {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    public static final boolean ENABLE_CHECKS = true;
    private static final String[] PARAM_DESCRIPTIONS = new String[]{"** A ZERO-BASED INDEX IS INVALID **", "(1st parameter)", "(2nd parameter)", "(3rd parameter)", "(4th parameter)", "(5th parameter)", "(6th parameter)", "(7th parameter)", "(8th parameter)", "(9th parameter)", "(10th parameter)"};
    private static long _errorCount = 0L;

    public static boolean ensureNotNull(Object param) throws AssertionError {
        if (param == null) {
            Validator.throwNull("");
        }
        return true;
    }

    public static boolean ensureNotNull(Object param1, Object param2) throws AssertionError {
        if (param1 == null) {
            Validator.throwNull(PARAM_DESCRIPTIONS[1]);
        }
        if (param2 == null) {
            Validator.throwNull(PARAM_DESCRIPTIONS[2]);
        }
        return true;
    }

    public static boolean ensureNotNull(Object param1, Object param2, Object param3) throws AssertionError {
        if (param1 == null) {
            Validator.throwNull(PARAM_DESCRIPTIONS[1]);
        }
        if (param2 == null) {
            Validator.throwNull(PARAM_DESCRIPTIONS[2]);
        }
        if (param3 == null) {
            Validator.throwNull(PARAM_DESCRIPTIONS[3]);
        }
        return true;
    }

    public static boolean ensureNotNull(Object param1, Object param2, Object param3, Object param4) throws AssertionError {
        if (param1 == null) {
            Validator.throwNull(PARAM_DESCRIPTIONS[1]);
        }
        if (param2 == null) {
            Validator.throwNull(PARAM_DESCRIPTIONS[2]);
        }
        if (param3 == null) {
            Validator.throwNull(PARAM_DESCRIPTIONS[3]);
        }
        if (param4 == null) {
            Validator.throwNull(PARAM_DESCRIPTIONS[4]);
        }
        return true;
    }

    public static boolean ensureTrue(boolean condition) throws AssertionError {
        if (!condition) {
            Validator.ensureTrue(condition, "");
        }
        return true;
    }

    public static boolean ensureTrue(boolean condition, String message) throws AssertionError {
        if (!condition) {
            StringBuilder mb = new StringBuilder();
            mb.append("The specified condition must be true. ");
            mb.append(message);
            String fullString = Validator.generateLineSpecificErrorString(mb.toString());
            Validator.logError(fullString);
            throw new AssertionError((Object)fullString);
        }
        return true;
    }

    public static synchronized long getErrorCount() {
        return _errorCount;
    }

    public static synchronized void resetErrorCount() {
        _errorCount = 0L;
    }

    private static synchronized void incrementErrorCount() {
        ++_errorCount;
    }

    private static String generateLineSpecificErrorString(String message) {
        StringBuilder mb = new StringBuilder();
        mb.append(message);
        mb.append("  The error occurred at ");
        mb.append(Validator.getOriginalCallerLineInfo());
        return mb.toString();
    }

    private static void throwNull(String message) throws AssertionError {
        StringBuilder mb = new StringBuilder();
        mb.append("The specified parameter must not be null. ");
        mb.append(message);
        String fullString = Validator.generateLineSpecificErrorString(mb.toString());
        Validator.logError(fullString);
        throw new AssertionError((Object)fullString);
    }

    private static void logError(String message) {
        Validator.incrementErrorCount();
        StringBuilder mb = new StringBuilder();
        mb.append(message);
        mb.append(ServerConstants.EOL);
        mb.append(Validator.getCallingStack());
        String messageWithStack = mb.toString();
        if (DebugLogger.debugEnabled()) {
            TRACER.debugError(messageWithStack.toString());
        }
        ErrorLogger.logError(Message.raw(messageWithStack, new Object[0]));
    }

    private static String getOriginalCallerLineInfo() {
        StackTraceElement[] stackElements = Thread.currentThread().getStackTrace();
        int callerIndex = Validator.getOriginalCallerStackIndex(stackElements);
        return stackElements[callerIndex].toString();
    }

    private static String getCallingStack() {
        StackTraceElement[] stackElements = Thread.currentThread().getStackTrace();
        int callerIndex = Validator.getOriginalCallerStackIndex(stackElements);
        StringBuilder buffer = new StringBuilder();
        for (int i = callerIndex; i < stackElements.length; ++i) {
            StackTraceElement stackElement = stackElements[i];
            buffer.append(stackElement).append(ServerConstants.EOL);
        }
        return buffer.toString();
    }

    private static int getOriginalCallerStackIndex(StackTraceElement[] stack) {
        int i;
        StackTraceElement element = null;
        for (i = 0; i < stack.length && ((element = stack[i]).getClassName().equals(Validator.class.getName()) || element.getClassName().equals(Thread.class.getName())); ++i) {
        }
        return i;
    }
}

