/*
 * IzPack - Copyright 2001-2008 Julien Ponge, All Rights Reserved.
 *
 * http://izpack.org/
 * http://izpack.codehaus.org/
 *
 * Copyright 2004 Klaus Bartz
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.co.ase.izpack.event;

import jp.co.ase.izpack.util.RegistryManager;

import com.izforge.izpack.event.RegistryInstallerListener;

/**
 * Installer custom action for handling registry entries on Windows. On Unix
 * nothing will be done. The actions which should be performed are defined in a
 * resource file named "RegistrySpec.xml". This resource should be declared in
 * the installation definition file (install.xml), else an exception will be
 * raised during execution of this custom action. The related DTD is
 * appl/install/IzPack/resources/registry.dtd.
 *
 * @author Klaus Bartz
 */
public class RedmineLERegistryInstallerListener extends RegistryInstallerListener {

	/**
	 * Default constructor.
	 */
	public RedmineLERegistryInstallerListener() {
		super();
		RegistryManager.getInstance();
	}

}
