# -*- encoding: utf-8 -*-

Gem::Specification.new do |s|
  s.name = %q{activeldap}
  s.version = "1.2.4"

  s.required_rubygems_version = Gem::Requirement.new(">= 0") if s.respond_to? :required_rubygems_version=
  s.authors = ["Will Drewry", "Kouhei Sutou"]
  s.date = %q{2011-05-13}
  s.description = %q{    'ActiveLdap' is a ruby extension library which provides a clean
    objected oriented interface to the Ruby/LDAP library.  It was inspired
    by ActiveRecord. This is not nearly as clean or as flexible as
    ActiveRecord, but it is still trivial to define new objects and manipulate
    them with minimal difficulty.
}
  s.email = ["redpig@dataspill.org", "kou@cozmixng.org"]
  s.extra_rdoc_files = ["README", "CHANGES", "COPYING", "LICENSE"]
  s.files = ["CHANGES", "COPYING", "LICENSE", "README", "Rakefile", "TODO", "benchmark/bench-al.rb", "benchmark/config.yaml.sample", "examples/config.yaml.example", "examples/example.der", "examples/example.jpg", "examples/groupadd", "examples/groupdel", "examples/groupls", "examples/groupmod", "examples/lpasswd", "examples/objects/group.rb", "examples/objects/ou.rb", "examples/objects/user.rb", "examples/ouadd", "examples/useradd", "examples/useradd-binary", "examples/userdel", "examples/userls", "examples/usermod", "examples/usermod-binary-add", "examples/usermod-binary-add-time", "examples/usermod-binary-del", "examples/usermod-lang-add", "lib/active_ldap.rb", "lib/active_ldap/action_controller/ldap_benchmarking.rb", "lib/active_ldap/acts/tree.rb", "lib/active_ldap/adapter/base.rb", "lib/active_ldap/adapter/jndi.rb", "lib/active_ldap/adapter/jndi_connection.rb", "lib/active_ldap/adapter/ldap.rb", "lib/active_ldap/adapter/ldap_ext.rb", "lib/active_ldap/adapter/net_ldap.rb", "lib/active_ldap/adapter/net_ldap_ext.rb", "lib/active_ldap/association/belongs_to.rb", "lib/active_ldap/association/belongs_to_many.rb", "lib/active_ldap/association/children.rb", "lib/active_ldap/association/collection.rb", "lib/active_ldap/association/has_many.rb", "lib/active_ldap/association/has_many_utils.rb", "lib/active_ldap/association/has_many_wrap.rb", "lib/active_ldap/association/proxy.rb", "lib/active_ldap/associations.rb", "lib/active_ldap/attributes.rb", "lib/active_ldap/base.rb", "lib/active_ldap/callbacks.rb", "lib/active_ldap/command.rb", "lib/active_ldap/compatible.rb", "lib/active_ldap/configuration.rb", "lib/active_ldap/connection.rb", "lib/active_ldap/distinguished_name.rb", "lib/active_ldap/entry_attribute.rb", "lib/active_ldap/escape.rb", "lib/active_ldap/get_text.rb", "lib/active_ldap/get_text/parser.rb", "lib/active_ldap/get_text_fallback.rb", "lib/active_ldap/get_text_support.rb", "lib/active_ldap/helper.rb", "lib/active_ldap/human_readable.rb", "lib/active_ldap/ldap_error.rb", "lib/active_ldap/ldif.rb", "lib/active_ldap/object_class.rb", "lib/active_ldap/operations.rb", "lib/active_ldap/populate.rb", "lib/active_ldap/schema.rb", "lib/active_ldap/schema/syntaxes.rb", "lib/active_ldap/timeout.rb", "lib/active_ldap/timeout_stub.rb", "lib/active_ldap/user_password.rb", "lib/active_ldap/validations.rb", "lib/active_ldap/xml.rb", "po/en/active-ldap.po", "po/ja/active-ldap.po", "rails/README", "rails/init.rb", "rails_generators/model_active_ldap/USAGE", "rails_generators/model_active_ldap/model_active_ldap_generator.rb", "rails_generators/model_active_ldap/templates/model_active_ldap.rb", "rails_generators/model_active_ldap/templates/unit_test.rb", "rails_generators/scaffold_active_ldap/scaffold_active_ldap_generator.rb", "rails_generators/scaffold_active_ldap/templates/ldap.yml", "test/al-test-utils.rb", "test/command.rb", "test/config.yaml.sample", "test/fixtures/lower_case_object_class_schema.rb", "test/run-test.rb", "test/test_acts_as_tree.rb", "test/test_adapter.rb", "test/test_associations.rb", "test/test_attributes.rb", "test/test_base.rb", "test/test_base_per_instance.rb", "test/test_bind.rb", "test/test_callback.rb", "test/test_configuration.rb", "test/test_connection.rb", "test/test_connection_per_class.rb", "test/test_connection_per_dn.rb", "test/test_dn.rb", "test/test_find.rb", "test/test_groupadd.rb", "test/test_groupdel.rb", "test/test_groupls.rb", "test/test_groupmod.rb", "test/test_ldif.rb", "test/test_load.rb", "test/test_lpasswd.rb", "test/test_object_class.rb", "test/test_reflection.rb", "test/test_schema.rb", "test/test_syntax.rb", "test/test_user.rb", "test/test_user_password.rb", "test/test_useradd-binary.rb", "test/test_useradd.rb", "test/test_userdel.rb", "test/test_userls.rb", "test/test_usermod-binary-add-time.rb", "test/test_usermod-binary-add.rb", "test/test_usermod-binary-del.rb", "test/test_usermod-lang-add.rb", "test/test_usermod.rb", "test/test_validation.rb"]
  s.homepage = %q{http://rubyforge.org/projects/ruby-activeldap/}
  s.rdoc_options = ["--main", "lib/active_ldap.rb"]
  s.require_paths = ["lib"]
  s.rubyforge_project = %q{ruby-activeldap}
  s.rubygems_version = %q{1.3.5}
  s.summary = %q{ActiveLdap is a object-oriented API to LDAP}
  s.test_files = ["test/test_lpasswd.rb", "test/test_groupadd.rb", "test/test_groupdel.rb", "test/test_base_per_instance.rb", "test/test_groupls.rb", "test/test_connection_per_dn.rb", "test/test_connection.rb", "test/test_usermod-lang-add.rb", "test/test_associations.rb", "test/test_schema.rb", "test/test_dn.rb", "test/test_attributes.rb", "test/test_object_class.rb", "test/test_acts_as_tree.rb", "test/test_usermod-binary-add.rb", "test/test_find.rb", "test/test_bind.rb", "test/test_useradd-binary.rb", "test/test_callback.rb", "test/test_useradd.rb", "test/test_usermod.rb", "test/test_syntax.rb", "test/test_usermod-binary-add-time.rb", "test/test_user.rb", "test/test_user_password.rb", "test/test_base.rb", "test/test_adapter.rb", "test/test_groupmod.rb", "test/test_reflection.rb", "test/test_load.rb", "test/test_configuration.rb", "test/test_userls.rb", "test/test_userdel.rb", "test/test_validation.rb", "test/test_ldif.rb", "test/test_connection_per_class.rb", "test/test_usermod-binary-del.rb"]

  if s.respond_to? :specification_version then
    current_version = Gem::Specification::CURRENT_SPECIFICATION_VERSION
    s.specification_version = 3

    if Gem::Version.new(Gem::RubyGemsVersion) >= Gem::Version.new('1.2.0') then
      s.add_runtime_dependency(%q<activerecord>, ["~> 2.3.11"])
      s.add_runtime_dependency(%q<locale>, ["= 2.0.5"])
      s.add_runtime_dependency(%q<fast_gettext>, ["= 0.5.8"])
      s.add_runtime_dependency(%q<gettext_i18n_rails>, ["= 0.2.2"])
      s.add_development_dependency(%q<rubyforge>, [">= 2.0.4"])
      s.add_development_dependency(%q<hoe>, [">= 2.6.1"])
    else
      s.add_dependency(%q<activerecord>, ["~> 2.3.11"])
      s.add_dependency(%q<locale>, ["= 2.0.5"])
      s.add_dependency(%q<fast_gettext>, ["= 0.5.8"])
      s.add_dependency(%q<gettext_i18n_rails>, ["= 0.2.2"])
      s.add_dependency(%q<rubyforge>, [">= 2.0.4"])
      s.add_dependency(%q<hoe>, [">= 2.6.1"])
    end
  else
    s.add_dependency(%q<activerecord>, ["~> 2.3.11"])
    s.add_dependency(%q<locale>, ["= 2.0.5"])
    s.add_dependency(%q<fast_gettext>, ["= 0.5.8"])
    s.add_dependency(%q<gettext_i18n_rails>, ["= 0.2.2"])
    s.add_dependency(%q<rubyforge>, [">= 2.0.4"])
    s.add_dependency(%q<hoe>, [">= 2.6.1"])
  end
end
