require 'subversion_hook/base'
require 'uri'

module SubversionHook
  class PostCommit < Base
    def initialize(repos, revision)
      super repos
      self.revision = revision
      config = load_config["post_commit"] || {}
      
      (load_config["post_commit"] || {}).each {|method, options|
        self.send(method, options)
      }
    end

    def run_background(cmd)
      unless @wsh
        require 'win32ole'
        @wsh = WIN32OLE.new("WScript.Shell")
      end
      @wsh.run(cmd, 0, false)
    end

    def fetch_changesets(options)
      run_background(%Q[ruby "#{HOME}/redmine/script/runner" "Repository.fetch_changesets"])
    end

    def perform_build(options)
      return unless jobs = options["jobs"]

      port = service_config["apache"]["port"]
      jobs.each {|job|
        next unless changed_files(:in => job["path"]).size > 0
        name = job["name"]
        token = jenkins_token(name)

        run_background(%Q[ruby -e "require 'net/http'; Net::HTTP.get('localhost', '/jenkins/job/#{URI.escape(name)}/build?token=#{token}', #{port})"])
      }
    end
  end
end
