module Redmine
  def self.install(options)
    ENV["RAILS_ENV"] = "production"
    lang = (ENV["REDMINE_LANG"] ||= "ja")

    Dir.chdir(options[:redmine_root]) {
      system_or_raise("rake generate_session_store")
      system_or_raise("rake db:migrate")
      system_or_raise("rake redmine:load_default_data")
      system_or_raise("rake db:migrate_plugins")

      require 'config/boot'
      require 'config/environment'

      # create or update LDAP settings
      opt = {
        :host => options[:ldap_host],
        :port => options[:ldap_port],
        :base_dn => options[:ldap_base_dn]
      }
      ldap = AuthSourceLdap.find(:first, :conditions => opt) || AuthSourceLdap.new(opt)
      ldap.name = options[:ldap_host] if ldap.name.blank?
      ldap.account = options[:ldap_bind_dn]
      ldap.account_password = options[:ldap_bind_password]
      ldap.attr_login = options[:ldap_user_attribute]
      ldap.attr_firstname = options[:ldap_first_name_attribute]
      ldap.attr_lastname = options[:ldap_last_name_attribute]
      ldap.attr_mail = options[:ldap_mail_attribute]
      ldap.onthefly_register = true
      ldap.tls = false
      ldap.save!

      # delete default admin user
      User.destroy(1) rescue nil

      # create or update admin user
      admin = User.find_by_login(options[:admin_account]) || User.new
      admin.login = options[:admin_account]
      admin.firstname = options[:admin_first_name]
      admin.lastname = options[:admin_last_name]
      admin.mail = options[:admin_mail]
      admin.admin = true
      admin.language = lang
      admin.auth_source = ldap
      admin.status = 1
      # ignore required user custom fields
      admin.save_without_validation! 

      setting = RedmineLeSetting.instance
      setting.use_external_ldap = options[:ldap_setting]
      setting.auth_source = ldap
      setting.admin_account = options[:admin_account]
      setting.admin_password = options[:admin_password]
      RedmineLeSetting.skip_callbacks do
        setting.save_without_validation!
      end

      host_name = Setting[:host_name] = "#{options[:apache_host]}/redmine"
      Setting[:emails_footer] = Setting[:emails_footer].gsub(
        /http\S+/, "http://#{host_name}/my/account"
      )

      Setting[:autofetch_changesets] = "0"
      Setting[:commit_fix_status_id] = "5"

      if (Setting[:default_language] = lang) == "ja"
        Setting[:user_format] = "lastname_firstname"
        Setting[:repositories_encodings] = "utf-8,shift-jis,euc-jp"
      end

      if options[:smtp_setting]
        Setting[:mail_from] = options[:mail_sender_address]
      end
    }
  end

  def self.system_or_raise(command)
    raise "\"#{command}\" failed" unless system command
  end
end
