require 'erb'
require 'find'
require 'uri'

module Template
  class Env
    def initialize(options)
      @env = options
    end

    def _binding
      binding
    end

    def method_missing(name, *args)
      @env[name] || @env[name.to_s]
    end
  end

  def self.install(options={})
    options[:package_home] ||= File.expand_path(ENV["PACKAGE_HOME"])
    env = Env.new(options)
    home = env.package_home
    template_dir = File.join(home, "template")
    skip_opends = options[:ldap_setting]

    Dir.chdir(template_dir) {
      Find.find(".") {|input|
        Find.prune if skip_opends && File.basename(input) == "opends"
        next if File.directory?(input) || File.extname(input) != ".erb"
        output = File.expand_path(File.join(home, input[0..-5]))

        puts output
        File.open(output, "w") {|f|
          f.print ERB.new(File.read(input)).result(env._binding)
        }
      }
    }
  end
end
