/*
 * IzPack - Copyright 2001-2008 Julien Ponge, All Rights Reserved.
 *
 * http://izpack.org/
 * http://izpack.codehaus.org/
 *
 * Copyright 2005 Marc Eppelmann
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.izforge.izpack.util;

/**
 * Holds some OS (Version) Constants
 *
 * @author marc.eppelmann&#064;reddot.de
 */
public interface OsVersionConstants
{
    //~ Static fields/initializers *********************************************************

    /**
     * OSNAME = "os.name"
     */
    public final static String OSNAME = "os.name";

    /**
     * OSARCH = "os.arch"
     */
    public final static String OSARCH = "os.arch";

    /**
     * OSARCH = "os.arch"
     */
    public final static String OSVERSION = "os.version";

    /**
     * X86 = "x86"
     */
    public static final String X86 = "x86";

    /**
     * I386 = "i386"
     */
    public static final String I386 = "i386";

    /**
     * PPC = "ppc"
     */
    public static final String PPC = "ppc";

    /**
     * SPARC = "sparc"
     */
    public static final String SPARC = "sparc";

    /**
     * FREEBSD = "FreeBSD"
     */
    public final static String FREEBSD = "FreeBSD";

    /**
     * LINUX = "Linux"
     */
    public final static String LINUX = "Linux";

    /**
     * HP_UX = "HP-UX"
     */
    public final static String HP_UX = "HP-UX";

    /**
     * AIX = "AIX"
     */
    public final static String AIX = "AIX";

    /**
     * SUNOS = "SunOS"
     */
    public final static String SUNOS = "SunOS";

    /**
     * SOLARIS = "Solaris"
     */
    public static final String SOLARIS = "Solaris";

    /**
     * OS_2 = "OS/2"
     */
    public final static String OS_2 = "OS/2";

    /**
     * MAC = "Mac"
     */
    public final static String MAC = "Mac";

    /**
     * Mac OS X
     */
    public final static String MACOSX = "mac os x";

    /**
     * WINDOWS = "Windows"
     */
    public final static String WINDOWS = "Windows";

    /**
     * Windows XP
     */
    public final static String WINDOWS_XP_VERSION = "5.1";

    /**
     * Windows Server 2003
     */
    public final static String WINDOWS_2003_VERSION = "5.2";

    /**
     * Windows Vista
     */
    public final static String WINDOWS_VISTA_VERSION = "6.0";

    /**
     * Windows 7
     */
    public final static String WINDOWS_7_VERSION = "6.1";

    /**
     * REDHAT  = "RedHat"
     */
    public final static String REDHAT = "RedHat";

    /**
     * RED_HAT = "Red Hat"
     */
    public final static String RED_HAT = "Red Hat";

    /**
     * FEDORA = "Fedora"
     */
    public final static String FEDORA = "Fedora";

    /**
     * MANDRAKE = "Mandrake"
     */
    public final static String MANDRAKE = "Mandrake";

    /**
     * MANDRIVA = "Mandriva"
     */
    public final static String MANDRIVA = "Mandriva";

    /**
     * SUSE = "SuSE"
     */
    public final static String SUSE = "SuSE";

    /**
     * DEBIAN = "Debian"
     */
    public final static String DEBIAN = "Debian";

    /**
     * PROC_VERSION = "/proc/version"
     */
    public final static String PROC_VERSION = "/proc/version";
}
