package jp.co.ase.izpack.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class WindowsUtils {
	// サービス名が登録されているかチェック。すでに登録されていれば1の文字列、されていなければ0の文字列を返す
	public static final String SERVICE_CHECK_SCRIPT = "var args = WScript.Arguments;\r\n"
	        + "var wmi = GetObject(\"winmgmts:{impersonationLevel=impersonate}\\\\\\\\.\");\r\n"
	        + "for (var i = 0; i < args.length; i++) {  \r\n"
	        + "var query = \"select * from Win32_Service where Name = '\" + args(i) + \"'\";\r\n"
	        + "if (wmi.ExecQuery(query).Count > 0) {\r\n" + "    WScript.StdOut.Write(1);  \r\n"
	        + "} else {\r\n" + "    WScript.StdOut.Write(0);  \r\n" + "}\r\n" + "}";

	/**
	 * すでにサービス名が登録されているかチェックする
	 *
	 * @param serviceName
	 *            サービス名
	 * @return
	 * @throws Exception
	 */
	public static boolean existService(String serviceName) {
		String[] cmdParameterArray = { serviceName };
		boolean result = executeCmd(SERVICE_CHECK_SCRIPT, cmdParameterArray);
		return result;
	}

	/**
	 * コマンドを実行し結果を返却する。
	 *
	 * @param scriptContent
	 * @param cmdParameterArray
	 * @return
	 */
	public static boolean executeCmd(String scriptContent, String[] cmdParameterArray) {
		// 一時ファイルとしてチェックスクリプトファイルを作成
		String tempFilePath = "";
		BufferedWriter writer = null;
		File tempFile = null;
		try {
			tempFile = File.createTempFile("izpack", ".js");
			tempFilePath = tempFile.getAbsolutePath();
			writer = new BufferedWriter(new FileWriter(tempFilePath));
			writer.write(scriptContent);
			writer.newLine();
			writer.close();

			ArrayList<String> cmdList = new ArrayList<String>();
			cmdList.add("cscript");
			cmdList.add("/Nologo");
			cmdList.add(tempFilePath);
			if (cmdParameterArray.length != 0) {
				for (int i = 0; i < cmdParameterArray.length; i++) {
					String parameter = cmdParameterArray[i];
					cmdList.add(parameter);
				}
			}
			// サービス名が登録されていれば1が出力される
			// String commandStr = "cscript /Nologo " + tempFilePath;
			String[] cmdArray = (String[]) cmdList.toArray(new String[0]);
			Process process = Runtime.getRuntime().exec(cmdArray);

			// 実行結果を読み込む
			InputStream is = process.getInputStream();
			BufferedReader br = new BufferedReader(new InputStreamReader(is));
			String line;
			while ((line = br.readLine()) != null) {
				if (line.equals("1")) {
					return true;
				} else {
					return false;
				}
			}
		} catch (IOException e) {
			return false;
		} finally {
			try {
				if (writer != null) {
					writer.close();
				}
			} catch (Exception e) {
				return false;
			}

			// 一時スクリプトファイルを削除
			tempFile.delete();
		}
		return false;
	}

}