# XNvgrbg}bv
# Authors:: fukuyama
# Date:: 2011/12/28
# Copyright:: Copyright (c) 2011 rgss-lib
# License:: BSD License

module Cache
  # XNvgrbg}bv
  def self.script_bitmap(filename)
    path = 'Script/'+filename
    @cache[path] = Script_Bitmap[filename].dup unless include?(path)
    @cache[path]
  end
end

# XNvgŃrbg}bv𐶐邽߂̃W[
module Script_Bitmap
  # R[hLbV
  @codes = []
  # rbg}bvǗpnbV
  @bitmaps = {}
  System_Event.add_init_handler() do
    @codes.each() do |code|
      create(code)
    end
  end

  # rbg}bv̎擾
  def self.[](name)
    return @bitmaps[name]
  end

  # rbg}bv̍쐬
  def self.create(code)
    @codes.push(code) unless @codes.include?(code)
    lines = code.split(/\n/)

    # O
    name = lines.shift
    if @bitmaps.include?(name) and (not @bitmaps[name].disposed?)
      return @bitmaps[name]
    end
    # rbg}bvTCYƃJ[pbg
    width,height,max_color = lines.shift.split(/,/)
    # J[pbgǂݍ
    colors = {}
    for i in 0 ... max_color.to_i
      arg = lines.shift.split(/,/)
      case arg.size
      when 4
        r,g,b,o = arg
        colors[i.to_s] = Color.new(r.to_i,g.to_i,b.to_i,o.to_i)
      when 5
        k,r,g,b,o = arg
        colors[k] = Color.new(r.to_i,g.to_i,b.to_i,o.to_i)
      end
    end

    # rbg}bv쐬
    bitmap = Bitmap.new(width.to_i,height.to_i)
    y = 0
    lines.each do |line|
      x = 0
      line.split(//).each do |key|
        bitmap.set_pixel(x, y, colors[key])
        x += 1
      end
      y += 1
    end

    # rbg}bvǉ
    @bitmaps[name] = bitmap
  end
end
