# VXeCxg
# Authors:: fukuyama
# Date:: 2011/12/28
# Copyright:: Copyright (c) 2011 rgss-lib
# License:: BSD License
#
# ex)
# System_Event.add_init_handler() { p 'game init' }
#
module SceneManager
  def self.run
    DataManager.init
    System_Event.process_init
    Audio.setup_midi if use_midi?
    @scene = first_scene_class.new
    @scene.main while @scene
  end
end

module System_Event
  @handlers = {}

  def self.add_handler(key,object=nil,&handler)
    @handlers[key] = @handlers[key] || []
    if object.nil?
      @handlers[key].push(handler)
      return
    end
    if object.is_a? Method
      @handlers[key].push(object)
      return
    end
    @handlers[key].push(object.method(key))
  end

  def self.process_handler(key)
    @handlers[key].each() {|h|h.call}
  end

  def self.add_init_handler(object=nil,&handler)
    add_handler(:init,object,&handler)
  end

  def self.process_init
    process_handler(:init)
  end

end
