# Game_ActorĒ`
# Authors:: fukuyama
# Date:: 2011/12/26
# Copyright:: Copyright (c) 2011 rgss-lib
# License:: BSD License

class Game_Actor
  include Backpack_Module
  # ACeIuWFNg̔z擾
  def items
    @backpack.find_all_items(Game_Item)
  end

  # SĂ̑iIuWFNg̔z擾
  def equip_items
    weapons + armors
  end

  # SẴACeIuWFNg̔z擾
  def all_items
    @backpack.find_all_items()
  end

  # X^bNACe̔z擾
  def stack_items
    @backpack.stack_items()
  end

  # ȉ
  # equips:: ̔z
  def init_equips(equips)
    @equips = Array.new(equip_slots.size) { Game_BaseItem.new }
    equips.each_with_index do |item_id, i|
      etype_id = index_to_etype_id(i)
      slot_id = empty_slot(etype_id)
      @equips[slot_id].set_equip(etype_id == 0, item_id) if slot_id
    end
    # obNpbNɓ
    @equips.each() do |o|
      self.backpack.add_item(o.object) if not o.object.nil?
    end
    refresh
  end

  # ̕ύX
  # slot_id:: Xbg ID
  # item:: ^hinil Ȃ瑕j
  def change_equip(slot_id, item)
    # 镨ꍇAXbgĂāAobNpbNTĂΑ
    return if item and equip_slots[slot_id] != item.etype_id and self.backpack.include?(item)
    @equips[slot_id].object = item
    refresh
  end

  # ̕ύXiID Ŏwj
  # slot_id:: Xbg ID
  # item_id:: ^h ID
  def change_equip_by_id(slot_id, item_id)
    # obNpbNTĂ΁A
    if equip_slots[slot_id] == 0
      if self.backpack.item_count_by_id(Game_Weapon,item_id) > 0
        change_equip(slot_id, self.backpack.find_item(Game_Weapon,item_id))
      end
    else
      if self.backpack.item_count_by_id(Game_Armor,item_id) > 0
        change_equip(slot_id, self.backpack.find_item(Game_Armor,item_id))
      end
    end
  end

  # łȂiO
  # item_gain:: Oip[eBɖ߂
  def release_unequippable_items(item_gain = true)
    # XXX: ƂƎĂACe𑕔̂Ŗ߂ȂB
    @equips.each_with_index do |item, i|
      if !equippable?(item.object) || item.object.etype_id != equip_slots[i]
        item.object = nil
      end
    end
  end

  # \
  # Game_BattlerBase Œ`Ă邯ǁ@Actor łgȂۂ̂łŕύX
  def equippable?(item)
    return false if item.nil?
    # {̃f[^擾ĊmF
    super(item.data)
  end

  # OƑ̔\͌vZ
  def equip_new_param(item,param_id)
    # O
    equip_prev = self.param(param_id)

    # 
    equip_next = equip_prev + item.params[param_id]
    equips.compact.each() do |o|
      # XXX: 񓁗Ƃǂ悤H
      if o.etype_id == item.etype_id
        equip_next -= o.params[param_id]
      end
    end

    return equip_prev, equip_next
  end

end
