# 킽ACeAN^[j[
# Authors:: fukuyama
# Date:: 2012/01/09
# Copyright:: Copyright (c) 2011 rgss-lib
# License:: BSD License

module DQ
  # ACeEBhẼwvs
  WINDOW_ACTOR_MENU_ITEM_HELP_LINE_NUMBER = 2 if not defined? WINDOW_ACTOR_MENU_ITEM_HELP_LINE_NUMBER
  # 킽ACeAN^[j[
  class Window_Actor_Menu_Item_Trade < ::DQ::Window_Actor_Menu_Base
    include Window_Command_Title_Module
    include Menu_Log_Item_Module
    # 
    def initialize(parent)
      self.title = Vocab::MenuActorItemTradeTitle
      # EBhEʒu
      super(parent,parent.find_window(Window_Item_Menu).right,parent.top_window.top)

      # ACeEBhE쐬
      @window_item = Window_Item_Trade.new(self)

      # ACewvEBhE쐬
      item_window = find_window(Window_Item)
      help_window = Window_Help.new(WINDOW_ACTOR_MENU_ITEM_HELP_LINE_NUMBER)
      help_window.width = @window_item.right - self.left
      help_window.create_contents
      help_window.top = item_window.y + item_window.height
      help_window.left = item_window.x
      add_child(help_window)
      self.help_window = help_window
    end

    # R}hXg̍쐬
    def make_command_list
      super
      add_command(Vocab::MenuBackpack, :select_party_backpack)
    end

    # ܂I
    def select_party_backpack
      owner = find_window(Window_Actor_Menu_Item).owner
      item = find_window(Window_Item).item
      Item_Facade.trade_item(owner,item,$game_party)
      menu_log_trade_item(owner,item,$game_party)
    end

    # AN^[I
    def select_actor
      owner = find_window(Window_Actor_Menu_Item).owner
      item = find_window(Window_Item).item
      if self.actor.backpack.addit?(item)
        # ǉłꍇ͋󔒗ɃJ[\킹
        @window_item.index = self.actor.backpack.item_count
      else
        # ǉłȂꍇ͑i̎̃ACe
        @window_item.index = self.actor.equips.compact.size
        # iĂȂꍇ́Aԉɂ
        if self.actor.backpack.item_count <= @window_item.index
          @window_item.index = self.actor.backpack.item_count - 1
        end
      end
      # ACeEBhEANeBu
      self.active_window = @window_item.class
    end

    # Iς̏
    def change_index
      @window_item.refresh
      @window_item.show
    end

    # wvEBhE̍XV
    def update_help
      return if self.help_window.disposed?
      self.help_window.show if self.help_window.visible
      item_window = find_window(Window_Item)
      item = item_window.item
      if self.actor.nil?
        refresh_help_backpack(item)
      else
        case item
        when Game_Item
          refresh_help_item(item)
        when Game_Weapon
          refresh_help_weapon(item)
        when Game_Armor
          refresh_help_armor(item)
        else
          self.help_window.clear
        end
      end
    end

    def refresh_help_item(item)
      self.help_window.set_item(item)
    end

    def refresh_help_param(item,param_id)
      text = item.description.dup
      text.gsub!(/\n/,' ')
      text += '\\bottom'
      if actor.equippable?(item)
        (equip_prev,equip_next) = actor.equip_new_param(item,param_id)
        equip_text = "#{equip_prev}  #{equip_next}"
        text += "\\right[#{equip_text}]"
      else
        text += "\\right[тłȂ]"
      end
      self.help_window.set_text(text)
    end

    def refresh_help_weapon(weapon)
      refresh_help_param(weapon,2)
    end

    def refresh_help_armor(armor)
      refresh_help_param(armor,3)
    end

    def refresh_help_backpack(item)
      text = "#{Vocab::BackpackName}̂Ȃ\n"
      count = $game_party.backpack.item_number(item)
      if 0 < count
        text += '͂Ă'
      else
        text += '͂ĂȂ'
      end
      self.help_window.set_text(text)
    end

  end
end
