# XLEBhE
# Authors:: fukuyama
# Date:: 2012/01/14
# Copyright:: Copyright (c) 2012 rgss-lib
# License:: BSD License

module DQ
  # XLEBhẼwvs
  WINDOW_SKILL_HELP_LINE_NUMBER = 7 if not defined? WINDOW_SKILL_HELP_LINE_NUMBER
  class Window_Skill < ::DQ::Window_Command_Base
    include Window_Tree_Module
    include Menu_Log_Skill_Module
    # 
    def initialize(parent,help=true)
      super(parent,parent.right,parent.top_window.top)
      self.unselect
      self.deactivate

      # wvEBhE쐬
      if help
        window = find_window(Window_Gold)
        help_window = Window_Help.new(WINDOW_SKILL_HELP_LINE_NUMBER)
        help_window.width = window.right - self.right
        help_window.top = window.top + fitting_height(2)
        help_window.left = self.right
        help_window.create_contents()
        help_window.hide
        add_child(help_window)
        self.help_window = help_window
      end
    end

    # EBhE̕
    def window_width
      gold_window = find_window(Window_Gold)
      return gold_window.left - self.parent.right
    end

    # j[̕\s
    def visible_line_number
      12
    end

    # R}hXg̍쐬
    # AN^[XL̍XV
    def make_command_list
      if not self.actor.nil?
        skills = self.actor.skills.select() {|s|s.menu_ok?}
        skills.each do |skill|
          add_command(skill.name, :select_skill, true, skill)
        end
      end
    end

    # nh[ݒ
    def set_handlers()
      # ȅꍇɁAadd_command ȂāAnh쐬Ȃꍇ̂ŁAKǉB
      set_handler(:select_skill, method(:select_skill))
      super
    end

    # wvEBhE̍XV
    def update_help
      if not self.help_window.disposed?
        if not self.help_window.visible
          self.help_window.show
        end
        if not self.skill.nil? and not self.actor.nil?
          text = self.skill.description
          text << "\\bottom\\right[#{skill.mp_cost}]"
          self.help_window.set_text(text)
        else
          self.help_window.clear
        end
      end
    end

    # AN^[̎擾
    def actor
      self.parent.actor
    end

    # XL̎擾
    def skill
      return current_ext
    end

    # XLI
    def select_skill
      actor = find_window(Window_Actor_Menu_Skill).actor
      skill = self.skill
      # gpłȂꍇ
      if not actor.usable?(skill)
        # SP Ȃꍇ͎gps
        if not actor.skill_cost_payable?(skill)
          menu_log_use_skill_sp_cost_error(skill,actor)
          return
        end
        # ^CvɂgȂꍇ
        if not actor.skill_wtype_ok?(skill)
          menu_log_use_skill_wtype_error(skill,actor)
          return
        end
        # 퓬s\̏ꍇ͎gps
        if actor.dead?
          menu_log_use_skill_state_error(skill,actor)
          return
        end
        # ُԂ̏ꍇAXLȊO͎gps
        if actor.skill_sealed?(skill.id) or actor.skill_type_sealed?(skill.stype_id)
          menu_log_use_skill_state_error(skill,actor)
          return
        end
        menu_log_use_skill_error(skill,actor)
        return
      end
      # ʔ͈͂ŚA{l݂̂Ŏg[U[܂Ăꍇ
      if skill.for_all? or (skill.for_user? and not actor.nil?)
        targets = []
        if skill.for_all?
          # ʔ͈͂Ŝ̏ꍇ
          targets = $game_party.members
        else
          # {l̂
          targets = [actor]
        end
        # XLgp
        used = false
        targets.each() do |target|
          target.item_apply(actor, skill)
          used |= target.result.used
        end
        # XLgꍇ
        if used
          # ʂ
          Sound.play_use_item
          actor.use_item(skill)
          menu_log_use_skill(skill,actor,targets)
          # RCxg\񔻒
          SceneManager.goto(Scene_Map) if $game_temp.common_event_reserved?
          # Q[I[o[
          SceneManager.goto(Scene_Gameover) if $game_party.all_dead?
        else
          # ʂȂ
          menu_log_use_skill_miss(skill,actor,targets)
        end
      elsif skill.for_one? # ʔ͈͂P̂̏ꍇ
        window = Window_Actor_Menu_Skill_Use.new(self)
        self.active_window = window.class
      else
        menu_log_use_skill_miss(skill,actor)
      end
    end

    # LZ
    def cancel
      self.help_window.hide
      self.unselect
      self.active_window = self.parent.class
    end

  end

end
